C:::::      ,,,,,VEMU08...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU08(T,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                  LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                  LBIG,RBIG,IBIG,USERU0)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU08  sets the inital solution                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
      include "bytes.h"

      INTEGER          LU,LIVEM,LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,
     &                 LIDPRM,LNOD,LNOPRM,LBIG,LNODN

      DOUBLE PRECISION T,U(LU),RPARM(LRPARM),RDPARM(LRDPRM),
     &                 NOD(LNOD),NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER          IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                 IDPARM(LIDPRM),IBIG(LBIG*RPI),NODNUM(LNODN)

      EXTERNAL         USERU0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see man vemu08)                    ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      include "archi.h"

      DOUBLE PRECISION  TIME,VEMSCD

      INTEGER           NQMAX,WQ,Q,S,DSDV,X,IWORK,ENOP,COUNO,U0

      INTEGER           LOUT,OUTCNT,ERR,IERR,G,K,J,Z,
     &                  STORE,L,NELIS,D,COMPU,LOCU,RWORK0,RWORK,
     &                  MYPROC,MYTID,NPROC,NMSG,TIDS,MPINFO,SBT,
     &                  MESH,NGROUP,NDEG,NK,DIM,NN,GINFO,GINFO1,
     &                  NE,NELTYP,FORM,CLASS,SKIP,NOP,NOP1,NK3,
     &                  OWN,NK2,GEOTYP,ADDGEO,GEO1,TOTNT,PRFLIB,
     &                  SORTI,NJUMP,JUMP,NBLK,BLKLST,BLK,NBIG,ORD,
     &                  NQ,NU,RW1,IW1,POINT,NBUF,NLOCU,ALOCU,LMATBK,
     &                  PTRMBK,COBUF,UBUF,LM,LLNGTH(16),NLNGTH(16)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT=IVEM(30)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      MYTID=IVEM(TIDS-1+MYPROC)
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9300)
	IVEM(2)=99
	RETURN
      ENDIF
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=LU
      LLNGTH(15)=0
      LLNGTH(16)=0
      TIME=VEMSCD()
      IF (LOUT.LE.0) LOUT=6
      OUTCNT=MAX(0,IVEM(31))
      MESH=IVEM(1)
      IERR=0
      RWORK0=0
      NBIG=0
      CALL VEM000('VEMU08',OUTCNT,LOUT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        WRITE (LOUT,9100) 30,LOUT
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check input parameters :                                      ***
C**   ----------------------                                        ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      CALL VEM098('VEMU08',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** fetch values from IVEM  :                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      NDEG  =IVEM(MESH+1)
      NK    =IVEM(MESH+2)
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      NOP1  =IVEM(MESH+13)
      NOP   =IVEM(MESH+14)
      OWN   =IVEM(MESH+15)
      LM     =IVEM(MESH+16)
      SORTI    =IVEM(MESH+19)+MESH
      NJUMP=IVEM(SORTI)
      NBLK=IVEM(SORTI+1)
      JUMP=SORTI+2
      LMATBK=JUMP+NPROC
      PTRMBK=LMATBK+NPROC
      BLKLST=JUMP+3*NPROC
      BLK=BLKLST+NGROUP
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      NU=LM
      NK2=MAX(1,OWN)
      NK3=NK-NK2+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create buffers :                                              ***
C**   --------------                                                ***
C**                                                                 ***
      NLOCU=0
      DO 15 G=1,NGROUP
        NE=IVEM(GINFO+GINFO1*(G-1))
        TOTNT=IVEM(GINFO+GINFO1*(G-1)+22)
	NLOCU=NLOCU+NE*NK3*TOTNT
15    CONTINUE
      NBIG=NLOCU+(NGROUP+RPI-1)/RPI+(LM+(LM+RPI-1)/RPI)*SBT

      NLNGTH(4)=NBIG
      NLNGTH(14)=NU
      CALL VEM098('VEMU08',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
      IF (OUTCNT.NE.0) WRITE (LOUT,9400)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** begin of group loop :                                         ***
C**   ---------------------                                         ***
C**                                                                 ***
      SKIP=1
      LOCU=(SKIP+NGROUP-1+RPI-1)/RPI+1
      RWORK0=LOCU+NLOCU

      ALOCU=LOCU
      DO 10 G=1,NGROUP

        NE     = IVEM(GINFO+GINFO1*(G-1)   )
        GEOTYP = IVEM(GINFO+GINFO1*(G-1)+ 1)
        FORM   = IVEM(GINFO+GINFO1*(G-1)+ 2)
        CLASS  = IVEM(GINFO+GINFO1*(G-1)+ 3)
        ADDGEO = IVEM(GINFO+GINFO1*(G-1)+ 4)
        GEO1   = IVEM(GINFO+GINFO1*(G-1)+ 5)
        TOTNT  = IVEM(GINFO+GINFO1*(G-1)+22)
	IF (NE.GT.0) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** begin of component loop :                                 ***
C**       -----------------------                                   ***
C**                                                                 ***
          DO 11 D=1,NK2
            NELTYP = GINFO+GINFO1*(G-1)+22+D
            PRFLIB = GINFO+GINFO1*(G-1)+22+NK+D
            IF ((IVEM(PRFLIB).EQ.0).OR.(IVEM(PRFLIB).EQ.2)) THEN
              ORD=0
            ELSE
              ORD=-IVEM(NELTYP)
            ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** storage for shape functions :                           ***
C**         ---------------------------                             ***
C**                                                                 ***
            CALL VEMPR0(0,G,CLASS,FORM,0,ORD,NQ,
     &                  GEOTYP,IVEM(NELTYP),IVEM(PRFLIB),TOTNT,
     &                  RW1,IW1,MYPROC,MYTID,LOUT,IERR)
	    IF (IERR.GT.0) THEN
	      ERR=99 
              GOTO 9998
            ENDIF
	    
            NQMAX=NQ
            WQ   =RWORK0+1
            Q    =WQ  +1           *NQMAX
            S    =Q   +CLASS       *NQMAX
            DSDV =S   +GEOTYP      *NQMAX
            RWORK=DSDV+GEOTYP*CLASS*NQMAX
            IWORK=(RWORK+RW1)*RPI+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** check storage :                                         ***
C**         -------------                                           ***
C**                                                                 ***
  	    L=MIN(MV,NE)
	    STORE=DIM+NOP+1
	    NBIG=MAX(NBIG,(IWORK+IW1-1+RPI-1)/RPI+STORE*L)
            IF (NBIG.GT.LBIG) GOTO 9998
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** set shape functions at nodes of proposal functions :    ***
C**         --------------------------------------------------      ***
C**                                                                 ***
            CALL VEMPRF(0,G,CLASS,FORM,0,ORD,NQ,NQMAX,RBIG(WQ),
     &                  RBIG(Q),GEOTYP,RBIG(S),RBIG(DSDV),
     &                  IVEM(NELTYP),IVEM(PRFLIB),
     &                  GEOTYP,RBIG(S),RBIG(DSDV),RBIG(S),RBIG(DSDV),
     &                  RW1,RBIG(RWORK),IW1,IBIG(IWORK),
     &                  MYPROC,MYTID,LOUT,ERR)
            IF (ERR.NE.0) GOTO 9998
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** set start addresses :                                   ***
C**         -------------------                                     ***
C**                                                                 ***
            X    =RWORK
            ENOP  =X+L*DIM
	    U0=ENOP+L*NOP
C**                                                                 ***
C********** loop over the nodes :                                   ***
C**         -------------------                                     ***
C**                                                                 ***
            DO   3000   POINT = 1,IVEM(NELTYP)
C**                                                                 ***
C************ section loop :                                        ***
C**           ------------                                          ***
C**                                                                 ***
              DO 2000 J=1,NE,L
                NELIS=MIN(L,NE-J+1)
C**                                                                 ***
C************** compute coordinates in the elements :               ***
C**             -----------------------------------                 ***
C**                                                                 ***
                CALL VEM901(NELIS,J,DIM,NN,NOD,
     &                      GEO1,GEOTYP,NEK(ADDGEO),L,
     &                      RBIG(S+(POINT-1)*GEOTYP),RBIG(X))
C**                                                                 ***
C************** compute the node parameters :                       ***
C**             ---------------------------                         ***
C**                                                                 ***
                IF (NOP.GT.0) THEN
                  CALL VEM901(NELIS,J,NOP,NOP1,NOPARM,
     &                        GEO1,GEOTYP,NEK(ADDGEO),L,
     &                        RBIG(S+(POINT-1)*GEOTYP),RBIG(ENOP))
                ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C************** elvaluate initial solution :                        ***
C**             --------------------------                          ***
C**                                                                 ***
	        DO 500 K=1,NK3
	          COMPU=K+NK3*(D-1)
	          DO 501 Z=1,NELIS
501                 RBIG(U0-1+Z)=0

                  CALL USERU0(T,NELIS,L,DIM,RBIG(X),NOP,RBIG(ENOP),
     &                        COMPU,RBIG(U0))
	          include "norec.h"
	          DO 502 Z=J,MIN(J+L,NE)
	             RBIG(ALOCU-1+Z+NE*(IVEM(NELTYP)*(K-1)+POINT-1))=
     &                                  RBIG(U0+Z-J)
 502              CONTINUE
500             CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C************** end of section loop :                               ***
C**             --------------------                                ***
C**                                                                 ***
2000          CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C************ end of node loop :                                    ***
C**           ----------------                                      ***
C**                                                                 ***
3000        CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********** end of component loop :                                 ***
C**         ---------------------                                   ***
C**                                                                 ***
  	    ALOCU=ALOCU+IVEM(NELTYP)*NK3*NE
11        CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** output :                                                  ***
C**       -------                                                   ***
C**                                                                 ***
          IF (OUTCNT.NE.0) WRITE(LOUT,9410) G,NE,L,(NE+L-1)/L,TOTNT
          IBIG(SKIP-1+G)=0
        ELSE
	  IF (OUTCNT.NE.0) WRITE(LOUT,9410) G,NE,0,0,0
          IBIG(SKIP-1+G)=1
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** end of group loop :                                         ***
C**     -----------------                                           ***
C**                                                                 ***
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** error handling:                                               ***
C**   --------------                                                ***
C**                                                                 ***
9998  CONTINUE
      NLNGTH(4)=NBIG
      CALL VEM098('VEMU08',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the element results are distributed to the vector U:      ***
C**   --------------------------------------------------------      ***
C**                                                                 ***
      NBUF=LM*SBT
      UBUF=RWORK0
      COBUF=(UBUF+NBUF-1)*RPI+1

      CALL VEM662(LM,COUNO,U,OWN,NK,NGROUP,GINFO1,IVEM(GINFO),NEK,
     &            NJUMP,IVEM(JUMP),IVEM(LMATBK),IVEM(PTRMBK),
     &            NLOCU,RBIG(LOCU),SBT,NBUF/SBT,IBIG(COBUF),
     &            RBIG(UBUF),IBIG(SKIP),IVEM(BLKLST),IVEM(BLK),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print end cards :                                             ***
C**   ---------------                                               ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMU08',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** output section :                                              ***
C**   ---------------                                               ***
C**                                                                 ***
9100  FORMAT(/'    line output unit ....................... LOUT =',
     &                                          ' IVEM(',I4,') = ',I10)
9300  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
9400  FORMAT(/'  evaluation at global nodes'
     &       /'  --------------------------'/
     &       /'      group |     NE    |    ELM1   | ',
     &                                       ' stripes  |  points   |'
     &       /6X,55('-'))
9410  FORMAT(9X,I2,4(' | ',I9),' |')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU08----------------------------------------------------
      E    N    D
