C:::::      ,,,,,VEMU09...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU09(LCU,CU,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                  LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                  LBIG,RBIG,IBIG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU09  evaluation of U given at the geometrical nodes     ***
C**              at the gauss points                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights Lutz Grosz Canberra, 1998                     ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
      include "bytes.h"

      INTEGER          LU,LCU,LIVEM,LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,
     &                 LIDPRM,LNOD,LNOPRM,LBIG,LNODN

      DOUBLE PRECISION U(LU),CU(LCU),RPARM(LRPARM),RDPARM(LRDPRM),
     &                 NOD(LNOD),NOPARM(LNOPRM),RBIG(LBIG)

      INTEGER          IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                 IDPARM(LIDPRM),IBIG(LBIG*RPI),NODNUM(LNODN)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      include "archi.h"

      DOUBLE PRECISION  TIME,VEMSCD

      INTEGER           LOUT,OUTCNT,ORDER,ERR,G,NQ2,
     &                  MYPROC,NPROC,U2,U1,WQ,S,DSDV,Q,
     &                  MESH,NGROUP,GINFO,GINFO1,IERR1,IERR2,
     &                  NE,FORM,CLASS,TIDS,NMSG,ORD,IPOINT,
     &                  ADDCU,CU1,GEOTYP,ADDGEO,GEO1,NCU,RWORK0,
     &                  NBIG,IW,RW,LIW1,LIW2,LRW1,LRW2,
     &                  LLNGTH(16),NLNGTH(16),LRW,LIW,NQ
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT=IVEM(30)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9300)
	IVEM(2)=99
	RETURN
      ENDIF
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=LU
      LLNGTH(15)=LCU
      LLNGTH(16)=0
      TIME=VEMSCD()
      IF (LOUT.LE.0) LOUT=6
      MESH=IVEM(1)
      OUTCNT=MAX(0,IVEM(31))
      ERR=0
      NBIG=0
      U1=MAX(0,IVEM(36))
      U2=MAX(0,IVEM(37))
      ORDER=MAX(IVEM(35),0)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('VEMU09',OUTCNT,LOUT)
        WRITE (LOUT,9100) 30,LOUT
        WRITE (LOUT,9130) 35,ORDER
        WRITE (LOUT,9121) 36,U1
	WRITE (LOUT,9110) 37,U2
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check input data :                                            ***
C**   ----------------                                              ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,OUTCNT,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))

      NBIG=0
      NCU=0
      NLNGTH(14)=U1*U2
      NLNGTH(4)=NBIG
      NLNGTH(15)=NCU
      CALL VEM098('VEMU09',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute length of CU and U :                                  ***
C**   --------------------------                                    ***
C**                                                                 ***
      NGROUP=IVEM(MESH+4)
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** STORE gives the storage per element                           ***
C**   -----------------------------------                           ***
C**                                                                 ***
      RWORK0=1
      ADDCU=1
      ERR=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** begin of group loop :                                         ***
C**   -------------------                                           ***
C**                                                                 ***
      DO 10   G=1,NGROUP

        NE     = IVEM(GINFO+GINFO1*(G-1)   )
        GEOTYP = IVEM(GINFO+GINFO1*(G-1)+ 1)
        FORM   = IVEM(GINFO+GINFO1*(G-1)+ 2)
        CLASS  = IVEM(GINFO+GINFO1*(G-1)+ 3)
        ADDGEO = IVEM(GINFO+GINFO1*(G-1)+ 4)
        GEO1   = IVEM(GINFO+GINFO1*(G-1)+ 5)
	CU1=NE

	IF (NE.GT.0) THEN
    	   ORD=ORDER
	   CALL VEMQD0(CLASS,FORM,ORD,NQ,LRW1,LIW1,IERR1)
	   CALL VEMSH0(CLASS,FORM,GEOTYP,LRW2,LIW2,IERR2)
	   LRW=MAX(LRW1,LRW2)
	   LIW=MAX(LIW1,LIW2)
	   ERR=MAX(IERR1,IERR2,ERR)

           WQ   =RWORK0+1
           Q    =WQ+NQ
           S    =Q+CLASS*NQ
           DSDV =S+GEOTYP*NQ
           RW   =DSDV+GEOTYP*CLASS*NQ

	   IW=(RW+LRW-1)*RPI+1
	   NBIG=MAX((IW-1*LIW+RPI-1)/RPI,NBIG)

	   IF ((NBIG.GT.LBIG) .OR.(ERR.GT.0)) GOTO 9998

           ORD=ORDER
           CALL VEMQDF(CLASS,FORM,ORD,NQ,NQ2,RBIG(WQ),RBIG(Q),
     &                 LRW,RBIG(RW),LIW,IBIG(IW),IERR1)
	   ERR=MAX(IERR1,ERR)
           CALL VEMSHF(CLASS,FORM,GEOTYP,NQ,RBIG(Q),RBIG(S),
     &                 RBIG(DSDV),LRW,RBIG(RW),LIW,IBIG(IW),IERR1)
	   ERR=MAX(IERR1,ERR)

           NCU=ADDCU+NE*U2*NQ-1
           IF ((NCU.GT.LCU).OR.(ERR.GT.0)) GOTO 9998

           DO 1234 IPOINT=1,NQ
             CALL VEM901(NE,1,U2,U1,U,GEO1,GEOTYP,NEK(ADDGEO),
     &          CU1,RBIG(S+GEOTYP*(IPOINT-1)),
     &          CU(ADDCU+NE*U2*(IPOINT-1)))
1234       CONTINUE
           IVEM(GINFO+GINFO1*(G-1)+17)=ADDCU
           IVEM(GINFO+GINFO1*(G-1)+18)=NE
           IVEM(GINFO+GINFO1*(G-1)+19)=NQ
	   ADDCU=ADDCU+NE*U2*NQ
        ELSE
          IVEM(GINFO+GINFO1*(G-1)+17)=ADDCU
          IVEM(GINFO+GINFO1*(G-1)+18)=0
          IVEM(GINFO+GINFO1*(G-1)+19)=0
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** End of group loop :                                         ***
C**     -----------------                                           ***
C**                                                                 ***
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** error handling :                                              ***
C**   ---------------                                               ***
C**                                                                 ***
9998  CONTINUE
      NLNGTH(4)=NBIG
      NLNGTH(15)=NCU
      CALL VEM098('VEMU09',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMU09',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9100  FORMAT(/'    line output unit....................... LOUT =',
     &                                         ' IVEM(',I4,') = ',I10)
9110  FORMAT('    number of components of U ................ NU =',
     &                                          ' IVEM(',I4,') = ',I10)
9121  FORMAT('    leading dimension of U ................... U1 =',
     &                                         ' IVEM(',I4,') = ',I10)
9130  FORMAT('    integration order ..................... ORDER =',
     &                                         ' IVEM(',I4,') = ',I10)
9300  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU09----------------------------------------------------
      E    N    D
