C:::::      ,,,,,VEMU13...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU13(LU,U,NORMU,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                  NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU13   print nodal results                               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include"bytes.h"
      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,
     &                  LDNOD,LRDPRM,LIDPRM,LNOD,LNOPRM,LU,LNODN,LBIG

      DOUBLE PRECISION  RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),U(LU),NORMU(*),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  DNOD(LDNOD),IDPARM(LIDPRM),IBIG(LBIG*RPI)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  TIME,VEMSCD,LIMIT
      INTEGER           MESH,ERR,LOUT,NDEG,N,NU,I,TOKEN(1),TOTID,FRTID,
     &                  OUTCNT,COUNT,TID,LLNGTH(16),NLNGTH(16),Z,
     &                  NPROC,MYPROC,IOTID,MYTID,U1,LBF,MPINFO,SBT,
     &                  NMAX,NMIN,NDEGL,NDEG0L,NUBUF,LCOUNT,NBIG,UBUF,
     &                  LL9MAP,P,MIDR,MIDS,INFO,J,NH,NMSG,TIDS,
     &                  SWPBUF,RCVBUF,SNDBUF,OUTCN2,IHELP(1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT=IVEM(23)
      TIME=VEMSCD()
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      IF (IVEM(1).LT.203+IVEM(200)) THEN
        WRITE (LOUT,9300)
	IVEM(2)=99
	RETURN
      ENDIF
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=LU
      MESH   = IVEM(1)
      NDEG   = IVEM(MESH+1)
      OUTCNT = IVEM(24)
      U1=MAX(IVEM(25),0)
      N =MAX(IVEM(26),0)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      LIMIT=10.D0**IVEM(4)
      NU=N*U1
      IF (LOUT.LT.0) LOUT=6
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title:                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('VEMU13',OUTCNT,LOUT)
	WRITE (LOUT,9330) 25,U1
	WRITE (LOUT,9320) 26,N
      ENDIF
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,0,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      LLNGTH(16)=NU
      CALL VEM098('VEMU13',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
      TOKEN(1)=OUTCNT
      CALL LL4INM(1,1,1,TOKEN,OUTCN2,IHELP,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create buffer:                                                ***
C**   ------------                                                  ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMAX,IHELP,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMIN,IHELP,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-NMIN
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,NUBUF,MYPROC,NPROC)

      LCOUNT=3
      UBUF=(LCOUNT+N*NUBUF-1+RPI-1)/RPI+1
      LBF=UBUF+N*NUBUF-1
      NBIG=LBF*SBT

      NLNGTH(4)=NBIG
      CALL VEM098('VEMU13',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** distribution of solution :                                    ***
C**   ------------------------                                      ***
C**                                                                 ***
      TOTID=IVEM(TIDS-1+LL9MAP(MYPROC+1,NPROC))
      FRTID=IVEM(TIDS-1+LL9MAP(MYPROC-1,NPROC))
      RCVBUF=0
      SNDBUF=RCVBUF+(SBT-1)*LBF
	
      IBIG(1+SNDBUF*RPI)=NDEGL
      IBIG(2+SNDBUF*RPI)=NDEG0L
      DO 100 P=1,NPROC
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,IVEM(NMSG)+P,IINT*2,IBIG(RCVBUF*RPI+1),
     &                                                      MIDR,INFO)
	    CALL MPSNDA(TOTID,IVEM(NMSG)+P,IINT*2,IBIG(SNDBUF*RPI+1),
     &                                                      MIDS,INFO)
          ENDIF
	  DO 101 Z=1,N*NUBUF
	    IBIG(LCOUNT+Z-1+RCVBUF*RPI)=0
	    RBIG(UBUF+Z-1+RCVBUF)=0
101       CONTINUE
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,IVEM(NMSG)+P,IINT*2,IBIG(RCVBUF*RPI+1),
     &                                                      MIDR,INFO)
	    CALL MPSNDW(TOTID,IVEM(NMSG)+P,IINT*2,IBIG(SNDBUF*RPI+1),
     &                                                      MIDS,INFO)
          ENDIF
	ELSE
	  CALL MPRCVA(FRTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(RCVBUF+1),
     &                                                     MIDR,INFO)
	  CALL MPSNDA(TOTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(SNDBUF+1),
     &                                                     MIDS,INFO)
	  CALL MPRCVW(FRTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(RCVBUF+1),
     &                                                     MIDR,INFO)
	  CALL MPSNDW(TOTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(SNDBUF+1),
     &                                                     MIDS,INFO)
        ENDIF
        NDEGL=IBIG(1+RCVBUF*RPI)
        NDEG0L=IBIG(2+RCVBUF*RPI)
	DO 130 J=1,N
	  DO 130 Z=1,NDEG
	    NH=NODNUM(Z)-NDEG0L
	    IF ((NH.GT.0).AND.(NH.LE.NDEGL).AND.
     &                                   (U(Z+U1*(J-1)).LT.LIMIT)) THEN
	      IBIG(LCOUNT-1+NH+NUBUF*(J-1)+RCVBUF*RPI)=1
	      RBIG(UBUF-1+NH+NUBUF*(J-1)+RCVBUF)=U(Z+U1*(J-1))
            ENDIF
130      CONTINUE
         SWPBUF=RCVBUF
         RCVBUF=SNDBUF
         SNDBUF=SWPBUF
100    CONTINUE
       IVEM(NMSG)=IVEM(NMSG)+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** count the entries :                                           ***
C**   -----------------                                             ***
C**                                                                 ***
       DO 240 J=2,N
         DO 240 Z=1,NDEGL
          IBIG(LCOUNT-1+Z+SNDBUF*RPI)=IBIG(LCOUNT-1+Z+SNDBUF*RPI)+
     &                          IBIG(LCOUNT-1+Z+NUBUF*(J-1)+SNDBUF*RPI)
240    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the maximum norm:                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      DO 250 J=1,N
        NORMU(J)=0.
        DO 250 Z=1,NDEGL
         IF (IBIG(LCOUNT-1+Z+SNDBUF*RPI).GE.N) THEN
           NORMU(J)=MAX(NORMU(J),
     &                        ABS(RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF)))
         ENDIF
250   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      IF (OUTCN2.GT.1) THEN
       IF (MYTID.EQ.IOTID) THEN
        WRITE(LOUT,9200) (J,J=1,N)
        WRITE(LOUT,9205)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****  print results:                                               ***
C**    -------------                                                ***
C**                                                                 ***
1112   COUNT=0
       DO 400 P=1,NPROC
          TID=IVEM(TIDS-1+P)
	  IF (TID.NE.IOTID) THEN
	    CALL MPSNDA(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TID,IVEM(NMSG)+NPROC+P,IREAL*LBF,RBIG(SNDBUF+1),
     &                                                       MIDR,INFO)
	    CALL MPRCVW(TID,IVEM(NMSG)+NPROC+P,IREAL*LBF,RBIG(SNDBUF+1),
     &                                                       MIDR,INFO)
          ENDIF
          NDEGL=IBIG(1+SNDBUF*RPI)
          NDEG0L=IBIG(2+SNDBUF*RPI)
          DO 300 Z=1,NDEGL
             IF (IBIG(LCOUNT-1+Z+SNDBUF*RPI).GE.N) THEN
               COUNT=COUNT+1
               WRITE(LOUT,9210) Z+NDEG0L,
     &               (RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF),J=1,MIN(N,3))
               IF (N.GE.4) THEN
                 WRITE(LOUT,9220)
     &                      (RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF),J=4,N)
                 WRITE(LOUT,9205)
               ENDIF
             ENDIF
 300      CONTINUE
400     CONTINUE
        IF (OUTCNT.GT.0) WRITE(LOUT,9380) COUNT
       ELSE
	 CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
	 CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
	 CALL MPSNDA(IOTID,IVEM(NMSG)+NPROC+MYPROC,IREAL*LBF,
     &                                    RBIG(SNDBUF+1),MIDS,INFO)
	 CALL MPSNDW(IOTID,IVEM(NMSG)+NPROC+MYPROC,IREAL*LBF,
     &                                    RBIG(SNDBUF+1),MIDS,INFO)
       ENDIF
      ENDIF
      IVEM(NMSG)=IVEM(NMSG)+2*NPROC
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Now the norms:                                                ***
C**                                                                 ***
      CALL LL4RNM(1,N,1,NORMU,RBIG,RBIG(N+1),
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      DO 500 J=1,N
	NORMU(J)=RBIG(J)
500   CONTINUE
      IF (OUTCNT.GT.0) WRITE (LOUT,9390) (J,NORMU(J),J=1,N)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it:                                                    ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEMU13',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9200  FORMAT(/'   node number         components of nodal values'
     &       /(13X,3(8X,I3,7X) ))
9205  FORMAT(1X,70('-'))
9210  FORMAT(3X,I10,3X,3(E16.9,2X))
9220  FORMAT((16X,3(E16.9,2X)))
9320  FORMAT('     number of components ..................... NU =',
     &        ' IVEM(',I4,') = ',I10)
9330  FORMAT('     leading dimension of result array ........ U1 =',
     &        ' IVEM(',I4,') = ',I10)
9380  FORMAT(/'     written nodal results .................... = ',I10)
9390  FORMAT('     norm of the components :'
     &      /(4X,I3,'-th : ',E16.9))
9300  FORMAT('>>VEMCD:30:0105'/'>>illegal MESH=IVEM(1) !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU13----------------------------------------------------
      E    N    D
