C:::::      ,,,,,VEMU20...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU20(LIVEM,IVEM,LNEK,NEK,LRPRM,RPARM,LIPRM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,
     &                  LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU20       print mesh arrays at one process              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           LIVEM,LNEK,LRPRM,LIPRM,LNODN,
     &                  LDNOD,LRDPRM,LIDPRM,LNOD,LNOPRM

      DOUBLE PRECISION  RPARM(LRPRM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPRM),
     &                  DNOD(LDNOD),IDPARM(LIDPRM),NODNUM(LNODN)
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide of vemu01)        ***
C**   -------------------------                                     ***
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      include "bytes.h"

      INTEGER           LOUT,OUTCNT,K,G,D,I,J,START,NINFO,
     &                  MESH,NGROUP,NDEG,NK,DIM,NN,OWN,GINFO,
     &                  NOP1,NOP,GINFO1,DINFO,DINFO1,NPROC,MYPROC,
     &                  NE,GEOTYP,FORM,CLASS,ADDGEO,GEO1,
     &                  ADRSP,NRSP,ADRVP,RVP1,NRVP,ADISP,NISP,
     &                  ADIVP,IVP1,NIVP,NDC,ADDCG,ADRSDP,
     &                  NRSDP,ADRVDP,RVDP1,NRVDP,ADISDP,NJUMP,
     &                  NISDP,ADIVDP,IVDP1,NIVDP,NT,ADDC,SORTI,
     &                  NT0,ADDNEK,NEK1,NELTYP,M,NK2,DIS,M0,NBLK
      INTEGER           LSUM,NSUM,NNOD,NNOPRM,NNEK,NRPRM,NIPRM,
     &                  NDNOD,NRDPRM,NIDPRM,NIVEM
      DOUBLE PRECISION  RMARK
      LOGICAL           HEAD
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LOUT=IVEM(20)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      IF (LOUT.LE.0) LOUT=6
      OUTCNT=MAX(0,IVEM(21))
      RMARK=DBLE(OUTCNT)
      MESH=IVEM(1)
      NDEG=IVEM(MESH+1)
      NK  =IVEM(MESH+2)
      DIM =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN  =IVEM(MESH+5)
      NINFO =IVEM(MESH+12)
      NOP1=IVEM(MESH+13)
      NOP =IVEM(MESH+14)
      OWN =IVEM(MESH+15)
      GINFO =IVEM(MESH+21)
      GINFO1=IVEM(MESH+22)
      DINFO =IVEM(MESH+23)
      DINFO1=IVEM(MESH+24)
      DIS   =IVEM(MESH+18)
      SORTI =IVEM(MESH+19)
      NJUMP=IVEM(MESH+SORTI)
      NBLK=IVEM(MESH+SORTI+1)
      NK2=MAX(1,OWN)
      M     =IVEM(MESH+SORTI+1+NPROC+MYPROC)
      M0    =IVEM(MESH+SORTI+1+2*NPROC+MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** mesh informations :
C**   -----------------
C**                                                                 ***
      K=INT((RMARK/10000.-AINT(RMARK/10000.))*10.+.5)
      RMARK=RMARK-K*1000.
      IF (K.NE.0) THEN

        WRITE (LOUT,9000)
        WRITE (LOUT,9600) 1,MESH

        WRITE (LOUT,9621) MESH+1,NDEG
        WRITE (LOUT,9630) MESH+2,NK
        WRITE (LOUT,9640) MESH+3,DIM
        WRITE (LOUT,9650) MESH+4,NGROUP
        WRITE (LOUT,9660) MESH+5,NN
        WRITE (LOUT,9665) MESH+12,NINFO
        WRITE (LOUT,9666) MESH+13,NOP1
        WRITE (LOUT,9667) MESH+14,NOP
        WRITE (LOUT,9668) MESH+15,OWN
        IF (OWN.LE.0) THEN
           WRITE (LOUT,9696)
        ELSEIF (OWN.LT.NK) THEN
           WRITE (LOUT,9693)
        ELSE
           WRITE (LOUT,9692)
        ENDIF
        WRITE (LOUT,9194) MESH+18,DIS
        IF (DIS.NE.220964) THEN
           WRITE (LOUT,9196)
        ELSE
           WRITE (LOUT,9195)
           WRITE (LOUT,9197) MESH+19,SORTI
	ENDIF


        WRITE (LOUT,9670) MESH+21,GINFO
        WRITE (LOUT,9680) MESH+22,GINFO1
        WRITE (LOUT,9690) MESH+23,DINFO
        WRITE (LOUT,9699) MESH+24,DINFO1
        IF (DIS.EQ.220964) THEN
           WRITE (LOUT,9198) MESH+SORTI,NJUMP
           WRITE (LOUT,9199) MESH+SORTI+1,NBLK
           WRITE (LOUT,9620) MESH+SORTI+1+MYPROC+NPROC,M
           WRITE (LOUT,9619) MESH+SORTI+1+MYPROC+2*NPROC,M0
	ENDIF

         WRITE (LOUT,9500)
         START=MESH+GINFO

	 IF ((OWN.EQ.0).AND.(DIS.NE.220964)) THEN
           WRITE (LOUT,9511)
           DO 120 G=1,NGROUP
             WRITE (LOUT,9520) G,(IVEM(START+J+GINFO1*(G-1)),J=0,3)
120        CONTINUE
	 ELSE
           WRITE (LOUT,9510)
           DO 123 G=1,NGROUP
             WRITE (LOUT,9521) G,(IVEM(START+J+GINFO1*(G-1)),J=0,5)
123        CONTINUE
	 ENDIF

         WRITE (LOUT,9530)
         DO 121 G=1,NGROUP
           WRITE (LOUT,9550) G,(IVEM(START+J+GINFO1*(G-1)),J=7,11)
121      CONTINUE

         WRITE (LOUT,9540)
         DO 122 G=1,NGROUP
           WRITE (LOUT,9550) G,(IVEM(START+J+GINFO1*(G-1)),J=12,16)
122      CONTINUE

           WRITE (LOUT,9541)
           WRITE (LOUT,9542) (J,J=1,MIN(NK2,2))
           WRITE (LOUT,9546)
           DO 24 G=1,NGROUP
             WRITE (LOUT,9543) G,IVEM(START+20+GINFO1*(G-1)),
     &                           IVEM(START+21+GINFO1*(G-1)),
     &                           IVEM(START+22+GINFO1*(G-1)),
     &                           (IVEM(START+J+GINFO1*(G-1)),
     &                            IVEM(START+J+NK+GINFO1*(G-1)),
     &                                               J=23,22+MIN(NK2,2))
24         CONTINUE
           IF (NK2.GT.2) THEN
             DO 25 I=3,NK2,5
               WRITE (LOUT,9544) (J,J=I,MIN(NK2,I+5))
               WRITE (LOUT,9546)
               DO 25 G=1,NGROUP
                 WRITE (LOUT,9545) G,(IVEM(START+J+GINFO1*(G-1)),
     &                                IVEM(START+J+NK+GINFO1*(G-1)),
     &                                          J=22+I,22+MIN(NK2,I+5))
25           CONTINUE
           ENDIF

         WRITE (LOUT,9560)
         START=MESH+DINFO

         IF ((OWN.LE.0).AND.(DIS.NE.220964)) THEN
           WRITE (LOUT,9565)
           DO 40 D=1,NK
            WRITE (LOUT,9566) D,IVEM(START+DINFO1*(D-1)),
     &                              IVEM(START+DINFO1*(D-1)+2)
40        CONTINUE
        ELSE
          WRITE (LOUT,9567)
          DO 43 D=1,NK
            WRITE (LOUT,9568) D,(IVEM(START+DINFO1*(D-1)+J),J=0,2)
43        CONTINUE
        ENDIF

         WRITE (LOUT,9570)
         DO 41 D=1,NK
           WRITE (LOUT,9590) D,(IVEM(START+J+DINFO1*(D-1)),J=3,7)
41       CONTINUE

         WRITE (LOUT,9580)
         DO 42 D=1,NK
           WRITE (LOUT,9590) D,(IVEM(START+J+DINFO1*(D-1)),J=8,12)
42       CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** node coordinates :                                            ***
C**   ----------------                                              ***
C**                                                                 ***
      K=INT((RMARK/1000.-AINT(RMARK/1000.))*10.+.5)
      RMARK=RMARK-K*100
      IF (K.NE.0) THEN


        WRITE (LOUT,9100)
        WRITE (LOUT,9110) NOP
        IF (NOP.EQ.0) THEN
          WRITE (LOUT,9111)
        ENDIF
        WRITE (LOUT,9125)

        DO 10 I=1,NDEG
          IF (NOP.GT.0) THEN
            WRITE(LOUT,9130) I,NODNUM(I)
            WRITE(LOUT,9131) (NOD((J-1)*NN+I),J=1,DIM)
            WRITE(LOUT,9132) (NOPARM(I+NOP1*(J-1)),J=1,MIN(NOP,3))
            IF (NOP.GT.3) THEN
               WRITE(LOUT,9133) (NOPARM(I+NOP1*(J-1)),J=3,NOP)
            ENDIF
            WRITE(LOUT,9125)
          ELSE
            WRITE(LOUT,9120) I,NODNUM(I),(NOD((J-1)*NN+I),J=1,DIM)
          ENDIF
 10     CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** elements:                                                     ***
C**   --------                                                      ***
C**                                                                 ***
      K=INT((RMARK/100.-AINT(RMARK/100.))*10.+.5)
      RMARK=RMARK-K*10.
      IF (K.NE.0) THEN

        WRITE (LOUT,9200)
        START= MESH+GINFO

        DO 20 G=1,NGROUP

          NE     = IVEM(START+GINFO1*(G-1)   )
          GEOTYP = IVEM(START+GINFO1*(G-1)+ 1)
          FORM   = IVEM(START+GINFO1*(G-1)+ 2)
          CLASS  = IVEM(START+GINFO1*(G-1)+ 3)

          ADRSP  = IVEM(START+GINFO1*(G-1)+ 7)
          NRSP   = IVEM(START+GINFO1*(G-1)+ 8)
          ADRVP  = IVEM(START+GINFO1*(G-1)+ 9)
          RVP1   = IVEM(START+GINFO1*(G-1)+10)
          NRVP   = IVEM(START+GINFO1*(G-1)+11)

          ADISP  = IVEM(START+GINFO1*(G-1)+12)
          NISP   = IVEM(START+GINFO1*(G-1)+13)
          ADIVP  = IVEM(START+GINFO1*(G-1)+14)
          IVP1   = IVEM(START+GINFO1*(G-1)+15)
          NIVP   = IVEM(START+GINFO1*(G-1)+16)
          ADDNEK= IVEM(START+GINFO1*(G-1)+20)
          NEK1  = IVEM(START+GINFO1*(G-1)+21)
          NELTYP= START+GINFO1*(G-1)+22
          IF ((OWN.EQ.0).AND.(DIS.NE.220964)) THEN
	    ADDGEO=ADDNEK
	    GEO1=NEK1
          ELSE
            ADDGEO = IVEM(START+GINFO1*(G-1)+ 4)
            GEO1   = IVEM(START+GINFO1*(G-1)+ 5)
          ENDIF

          WRITE (LOUT,9125)
          WRITE (LOUT,9210) G,NE,GEOTYP,FORM,CLASS

          IF (NRSP.GT.0) THEN
            WRITE (LOUT,9220) NRSP,(RPARM(ADRSP+J),J=0,MIN(NRSP-1,1))
            IF (NRSP.GT.2) THEN
              WRITE (LOUT,9225) (RPARM(ADRSP+J),J=2,NRSP-1)
            ENDIF
          ENDIF

          IF (NISP.GT.0) THEN
            WRITE (LOUT,9250) NISP,(IPARM(ADISP+J),J=0,MIN(NISP-1,3))
            IF (NISP.GT.4) THEN
              WRITE (LOUT,9255) (IPARM(ADISP+J),J=4,NISP-1)
            ENDIF
          ENDIF

          DO 22 I=1,NE

            WRITE (LOUT,9125)
            WRITE (LOUT,9280) I,G
            WRITE (LOUT,9201)
            WRITE (LOUT,9290) (NEK(ADDGEO+I-1+J*GEO1),J=0,GEOTYP-1)

            IF ((DIS.EQ.220964).OR.(OWN.GT.0)) THEN
              NT0=-1
              DO 100 D=1,MAX(1,OWN)
                NT=IVEM(NELTYP+D)
                WRITE (LOUT,9202) D,NT
                IF (NT.GT.0) THEN
                 WRITE (LOUT,9290) (NEK(ADDNEK+I-1+NEK1*(J+NT0)),J=1,NT)
                 NT0=NT0+NT
                ENDIF
  100         CONTINUE
            ENDIF

            IF (NRVP.GT.0) THEN
              WRITE (LOUT,9300) NRVP,
     &                     (RPARM(ADRVP+I-1+RVP1*J),J=0,MIN(NRVP-1,1))
              IF (NRVP.GT.2) THEN
                WRITE (LOUT,9225) (RPARM(ADRVP+I-1+RVP1*J),J=2,NRVP-1)
              ENDIF
            ENDIF

            IF (NIVP.GT.0) THEN
              WRITE (LOUT,9320) NIVP,
     &                     (IPARM(ADIVP+I-1+IVP1*J),J=0,MIN(NIVP-1,3))
              IF (NIVP.GT.4) THEN
                WRITE (LOUT,9255) (IPARM(ADIVP+I-1+IVP1*J),J=4,NIVP-1)
              ENDIF
            ENDIF

 22     CONTINUE

        WRITE(LOUT,9125)

20     CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** dirichlet conditions:                                         ***
C**   --------------------                                          ***
C**                                                                 ***
      K=INT(RMARK+.5)
      IF (K.NE.0) THEN

        WRITE (LOUT,9400)

        START= MESH+DINFO

        DO 30 D=1,NK

          NDC  = IVEM(START+DINFO1*(D-1)   )
          ADDC= IVEM(START+DINFO1*(D-1)+ 2)
          IF ((OWN.GT.0).OR.(DIS.EQ.220964)) THEN
            ADDCG  = IVEM(START+DINFO1*(D-1)+ 1)
          ELSE
            ADDCG  = ADDC
          ENDIF

          ADRSDP = IVEM(START+DINFO1*(D-1)+ 3)
          NRSDP  = IVEM(START+DINFO1*(D-1)+ 4)
          ADRVDP = IVEM(START+DINFO1*(D-1)+ 5)
          RVDP1  = IVEM(START+DINFO1*(D-1)+ 6)
          NRVDP  = IVEM(START+DINFO1*(D-1)+ 7)

          ADISDP = IVEM(START+DINFO1*(D-1)+ 8)
          NISDP  = IVEM(START+DINFO1*(D-1)+ 9)
          ADIVDP = IVEM(START+DINFO1*(D-1)+10)
          IVDP1  = IVEM(START+DINFO1*(D-1)+11)
          NIVDP  = IVEM(START+DINFO1*(D-1)+12)

          WRITE (LOUT,9125)
          WRITE (LOUT,9410) D,NDC

          IF (NRSDP.GT.0) THEN
            WRITE (LOUT,9420) NRSDP,RDPARM(ADRSDP)
            IF (NRSDP.GT.1) THEN
              WRITE (LOUT,9225) (RDPARM(ADRSDP+J),J=1,NRSDP-1)
            ENDIF
          ENDIF

          IF (NISDP.GT.0) THEN
            WRITE (LOUT,9440) NISDP,(IDPARM(ADISDP+J),
     &                               J=0,MIN(NISDP-1,2))
            IF (NISDP.GT.3) THEN
              WRITE (LOUT,9255) (IDPARM(ADISDP+J),J=3,NISDP-1)
            ENDIF
          ENDIF

          DO 32 I=1,NDC

            WRITE (LOUT,9125)
            IF ((OWN.GT.0).OR.(DIS.EQ.220964)) THEN
              WRITE (LOUT,9461) I,D,DNOD(ADDC+I-1),DNOD(ADDCG+I-1)
            ELSE
              WRITE (LOUT,9460) I,D,DNOD(ADDCG+I-1)
            ENDIF

            IF (NRVDP.GT.0) THEN
              WRITE (LOUT,9300) NRVDP,(RDPARM(ADRVDP+I-1+RVP1*J),
     &                             J=0,MIN(NRVDP-1,1))
              IF (NRVDP.GT.2) THEN
                WRITE (LOUT,9225) (RDPARM(ADRVDP+I-1+RVDP1*J),
     &                             J=2,NRVDP-1)
              ENDIF
            ENDIF

            IF (NIVDP.GT.0) THEN
              WRITE (LOUT,9320) NIVDP,
     &                (IDPARM(ADIVDP+I-1+IVDP1*J),J=0,MIN(NIVDP-1,3))
              IF (NIVDP.GT.4) THEN
                WRITE (LOUT,9255) (IDPARM(ADIVDP+I-1+IVDP1*J),
     &                             J=4,NIVDP-1)
              ENDIF
            ENDIF

 32     CONTINUE

        WRITE(LOUT,9125)

30     CONTINUE

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** statistics :                                                  ***
C**   ----------                                                    ***
C**                                                                 ***
C**                                                                 ***
      IF (OUTCNT.GT.0) THEN

        HEAD=.FALSE.
        LSUM=0
        NSUM=0

        NIVEM =IVEM(5)
        NNOD  =IVEM(MESH+3)*IVEM(MESH+5)
        NNOPRM=IVEM(MESH+13)*IVEM(MESH+14)
        NNEK  =IVEM(MESH+ 6)
        NRPRM =IVEM(MESH+ 7)
        NIPRM =IVEM(MESH+ 8)
        NDNOD =IVEM(MESH+ 9)
        NRDPRM=IVEM(MESH+10)
        NIDPRM=IVEM(MESH+11)

       CALL VEM609('IVEM                   ',NIVEM,LIVEM,HEAD,LOUT)
        LSUM=LSUM+LIVEM*IINT
        NSUM=NSUM+NIVEM*IINT
       CALL VEM609('node coordinates       ',NNOD,LNOD,HEAD,LOUT)
        LSUM=LSUM+LNOD*IREAL
        NSUM=NSUM+NNOD*IREAL
       CALL VEM609('     numbers           ',NDEG,LNODN,HEAD,LOUT)
        LSUM=LSUM+LNODN*IINT
        NSUM=NSUM+NDEG*IINT
       CALL VEM609('     parameters        ',NNOPRM,LNOPRM,HEAD,LOUT)
        LSUM=LSUM+LNOPRM*IREAL
        NSUM=NSUM+NNOPRM*IREAL
       CALL VEM609('element array          ',NNEK,LNEK,HEAD,LOUT)
        LSUM=LSUM+LNEK*IINT
        NSUM=NSUM+NNEK*IINT
       CALL VEM609('  real parameters      ',NRPRM,LRPRM,HEAD,LOUT)
        LSUM=LSUM+LRPRM*IREAL
        NSUM=NSUM+NRPRM*IREAL
       CALL VEM609('  integer parameters   ',NIPRM,LIPRM,HEAD,LOUT)
        LSUM=LSUM+LIPRM*IINT
        NSUM=NSUM+NIPRM*IINT
       CALL VEM609('Dirichlet conditions   ',NDNOD,LDNOD,HEAD,LOUT)
        LSUM=LSUM+LDNOD*IINT
        NSUM=NSUM+NDNOD*IINT
       CALL VEM609('  real parameters      ',NRDPRM,LRDPRM,HEAD,LOUT)
        LSUM=LSUM+LRDPRM*IREAL
        NSUM=NSUM+NRDPRM*IREAL
       CALL VEM609('  integer parameters   ',NIDPRM,LIDPRM,HEAD,LOUT)
        LSUM=LSUM+LIDPRM*IINT
        NSUM=NSUM+NIDPRM*IINT
       CALL VEM609('total bytes            ',NSUM,LSUM,HEAD,LOUT)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   --------                                                      ***
C**                                                                 ***
9000  FORMAT(/'  mesh informations'/2X,17('-')/)
9600  FORMAT('    start of mesh infos in IVEM .............. MESH =',
     &                                          ' IVEM(',I4,') = ',I10)
9619  FORMAT('    first global node on process -1 ........ PTRMBK =',
     &                                          ' IVEM(',I4,') = ',I10)
9620  FORMAT('    number of nodes on process ............. LMATBK =',
     &                                          ' IVEM(',I4,') = ',I10)
9621  FORMAT('    number of geometrical nodes .............. NDEG =',
     &                                          ' IVEM(',I4,') = ',I10)
9630  FORMAT('    number of components ....................... NK =',
     &                                          ' IVEM(',I4,') = ',I10)
9640  FORMAT('    dimension ................................. DIM =',
     &                                          ' IVEM(',I4,') = ',I10)
9650  FORMAT('    number of groups ....................... NGROUP =',
     &                                          ' IVEM(',I4,') = ',I10)
9660  FORMAT('    leading dimension of node array ............ NN =',
     &                                          ' IVEM(',I4,') = ',I10)
9665  FORMAT('    storage of mesh infos ................... NINFO =',
     &                                          ' IVEM(',I4,') = ',I10)
9666  FORMAT('    leading dimension of node parameters ..... NOP1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9667  FORMAT('    number of node parameters ................. NOP =',
     &                                          ' IVEM(',I4,') = ',I10)
9668  FORMAT('    number of proposal functions .............. OWN =',
     &                                          ' IVEM(',I4,') = ',I10)
9696  FORMAT('    => isoparametrical mesh')
9692  FORMAT('    => mixed mesh')
9693  FORMAT('    => mixed mesh with identical proposal functions')
9194  FORMAT('    indicator of distributed mesh ............. DIS =',
     &                                          ' IVEM(',I4,') = ',I10)
9195  FORMAT('    => distibuted mesh')
9196  FORMAT('    => mesh has to be distributed')
9197  FORMAT('    start address of resorting informations . SORTI =',
     &                                          ' IVEM(',I4,') = ',I10)
9198  FORMAT('    number of communication jumps ........... NJUMP =',
     &                                          ' IVEM(',I4,') = ',I10)
9199  FORMAT('    number of blocks ......................... NBLK =',
     &                                          ' IVEM(',I4,') = ',I10)

9670  FORMAT('    start address of group infos ............ GINFO =',
     &                                          ' IVEM(',I4,') = ',I10)
9680  FORMAT('    number of infos per group .............. GINFO1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9690  FORMAT('    start address of Dirichlet infos ........ DINFO =',
     &                                          ' IVEM(',I4,') = ',I10)
9699  FORMAT('    number of infos per components ......... DINFO1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9100  FORMAT(/'  geometrical nodes'/2X,17('-')/)
9110  FORMAT(2X,'number of node parameters : ',I5/)
9111  FORMAT('            number'
     &      /'  consecutive   global          coordinates')
9120  FORMAT(2X,2I10,2X,3(E16.9,2X))
9130  FORMAT('  consecutive number :',I10,'   global number :',I10)
9131  FORMAT(2X,'coordinates :',5X,3(E16.9,2X))
9132  FORMAT(2X,'parameters  :',5X,3(E16.9,2X))
9133  FORMAT((20X,3(E16.9,2X)))
9125  FORMAT(2X,77('-'))
9200  FORMAT(/'  elements'/2X,8('-')/)
9201  FORMAT('  geometry:')
9202  FORMAT('  proposal functions for component ',I6,' NELTYP =',I6)
9210  FORMAT('  group :',I3,25X,'NE     = ',I10,'    GEOTYP = ',I10
     &      /37X,'FORM   = ',I10,'    CLASS  = ',I10)
9220  FORMAT(2X,I3,' real    group parameters :   ',2(1X,E16.9))
9225  FORMAT((1X,4(1X,E16.9)))
9250  FORMAT(2X,I3,' integer group parameters :',4(I10) )
9255  FORMAT((2X,7(I10)) )
9280  FORMAT(2X,'element number   ',I10,' in group ',I3,' :')
9290  FORMAT((8(I10)))
9300  FORMAT(2X,I3,' real    parameters :         ',2(1X,E16.9))
9320  FORMAT(2X,I3,' integer parameters :      ',4(I10) )
9400  FORMAT(/'  Dirichlet conditions'/3X,20('-')/)
9410  FORMAT('  component :',I3,25X,'NDC  = ',I10)
9420  FORMAT(2X,I3,' real    parameters for component :            ',
     &                                                      1X,E16.9)
9440  FORMAT(2X,I3,' integer parameters for component :  ',3(I10) )
9460  FORMAT(2X,'condition ',I10,' for component ',I3,
     &                                   ' at geometrical node ',I10)
9461  FORMAT(2X,'condition ',I10,' for component ',I3,
     &                                   ' at global      node ',I10
     &      /40X,' at geometrical node ',I10)
9500  FORMAT(/'    element groups :'/)
9510  FORMAT('      grp |     NE    | GEOTYP | FORM | CLASS | ',
     &                                     ' ADDGEO   |    GEO1   |'
     &      /6X,65('-'))
9511  FORMAT('      grp |     NE    | GEOTYP | FORM | CLASS |',
     &      /6X,41('-'))
9521  FORMAT(7X,I2,' | ',I9,' | ',I6,' | ',I4,' | ',I5,' | ',I9,
     &                                                ' | ',I9,' |')
9520  FORMAT(7X,I2,' | ',I9,' | ',I6,' | ',I4,' | ',I5,' | ')
9530  FORMAT(/'      real parameter management'
     &      //'      grp |   ADRSP   | NRSP |   ADRVP   | ',
     &                                         '  RVP1    | NRVP |'
     &       /6X,55('-'))
9540  FORMAT(/'      integer parameter management'
     &      //'      grp |   ADISP   | NISP |   ADIVP   | ',
     &                                         '  IVP1    | NIVP |'
     &       /6X,55('-'))
9541  FORMAT(/'      proposal functions'/)
9542  FORMAT('      grp |  ADDNEK   |   NEK1    |   TOTNT   ',
     &                            '| NELTYP ->PRFLIB for component'
     &      /'          |           |           |           | ',
     &                                                 2(2X,I5,7X))
9546  FORMAT(6X,70('-'))
9543  FORMAT(7X,I2,' | ',3(I9,' | '),2(I5,' ->',I5))
9544  FORMAT(/'      grp | NELTYP ->PRFLIB for component'
     &       /'          |  ',6(2X,I5,7X))
9545  FORMAT(7X,I2,' |  ',6(I5,' ->',I5))
9550  FORMAT(7X,I2,' | ',I9,' | ',I4,2(' | ',I9),' | ',I4,' |')
9560  FORMAT(/'    Dirichlet conditions :'/)
9565  FORMAT('      comp. |    NDC  |    ADDCG  |'/6X,31('-'))
9566  FORMAT(9X,I2,2(' | ',I9),' |')
9567  FORMAT('      comp. |    NDC  |    ADDCG  |   ADDC  |'
     &      /6X,43('-'))
9568  FORMAT(9X,I2,3(' | ',I9),' |')
9570  FORMAT(/'      real parameter management'
     &      //'      comp. |   ADRSDP  | NRSDP | ',
     &                             ' ADRVDP   |   RVDP1   | NRVDP |'
     &       /6X,59('-'))
9580  FORMAT(/'      integer parameter management'
     &      //'      comp. |   ADISDP  | NISDP | ',
     &                             ' ADIVDP   |   IVDP1   | NIVDP |'
     &       /6X,59('-'))
9590  FORMAT(9X,I2,' | ',I9,' | ',I5,2(' | ',I9),' | ',I5,' |')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU20----------------------------------------------------
      E    N    D
