C:::::      ,,,,,VEMU21...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU21 (OWN,NDEGL,DIM,NOP,NGROUP,GINFO1,GINFO,
     &                   NK,DINFO1,DINFO,LBFIN,LBFRN,LBFN,
     &                   LBFRE,LBFIE,LBFE,LBFRD,LBFID,LBFD,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU21     check input values and compute buffer sizes     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NDEGL,NGROUP,GINFO1,NK,DINFO1,LBFIN,LBFRN,LBFN,
     &                  LBFRE,LBFIE,LBFE,LBFRD,LBFID,LBFD,DIM,NOP,
     &                  IOTID,MYPROC,NPROC,NMSG,OWN
      INTEGER           GINFO(GINFO1,NGROUP),DINFO(DINFO1,NK),
     &                  TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NDEGL  I  I   I in  I number of geometrical nodes in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  arrary: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components (NK<=6!)
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I Dirchlet informations  arrary: DINFO(GINFO1,NK)
C--------I------I-----I------------------------------------------------
C LBFIN  I  I   I out I length of integer buffer to write nodes
C--------I------I-----I------------------------------------------------
C LBFRN  I  I   I out I length of real buffer to write nodes
C--------I------I-----I------------------------------------------------
C LBFN   I  I   I out I length of buffer to write nodes in IBIG
C--------I------I-----I------------------------------------------------
C LBFIE  I  I   I out I length of integer buffer to write elements
C--------I------I-----I------------------------------------------------
C LBFRE  I  I   I out I length of real buffer to write elements
C--------I------I-----I------------------------------------------------
C LBFE   I  I   I out I length of buffer to write elements in IBIG
C--------I------I-----I------------------------------------------------
C LBFID  I  I   I out I length of integer buffer to write Dirichlets
C--------I------I-----I------------------------------------------------
C LBFRD  I  I   I out I length of real buffer to write Dirichlets
C--------I------I-----I------------------------------------------------
C LBFD   I  I   I out I length of buffer to write Dirichlets in IBIG
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           GEOTYP,G,NE,TOTNT,D,NDC,NRVDP,NIVDP,
     &                  MYTID,H3(10),H1(10),H2(10),NRVP,NIVP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   nodes:                                                        ***
C**   -----                                                         ***
C**                                                                 ***
      LBFRN=(DIM+NOP)*NDEGL
      LBFIN=2+NDEGL
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   elements:                                                     ***
C**   --------                                                      ***
C**                                                                 ***
      LBFRE=0
      LBFIE=0
      DO 200 G=1,NGROUP
        NE     = GINFO(1,G)
        GEOTYP = GINFO(2,G)
        NRVP   = GINFO(12,G)
        NIVP   = GINFO(17,G)
        TOTNT = GINFO(23,G)
        IF (OWN.EQ.0) THEN
	  LBFIE=MAX(LBFIE,1+NE*(NIVP+GEOTYP))
        ELSE
	  LBFIE=MAX(LBFIE,1+NE*(NIVP+GEOTYP+TOTNT))
        ENDIF
	LBFRE=MAX(LBFRE,NE*NRVP)
 200  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Dirichlet conditions :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      LBFRD=0
      LBFID=0
      DO 300 D=1,NK
        NDC=DINFO(1,D)
        NRVDP=DINFO(8,D)
        NIVDP=DINFO(13,D)
        IF (OWN.EQ.0) THEN
	  LBFID=MAX(LBFID,1+NDC*(1+NIVDP))
        ELSE
	  LBFID=MAX(LBFID,1+NDC*(NIVDP+2))
        ENDIF
	LBFRD=MAX(LBFRD,NDC*NRVDP)
 300  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   global buffer length is set:                                  ***
C**   ---------------------------                                   ***
C**                                                                 ***
      H1(1)=LBFRN
      H1(2)=LBFIN
      H1(3)=LBFRE
      H1(4)=LBFIE
      H1(5)=LBFRD
      H1(6)=LBFID
      CALL LL4INM(1,6,1,H1,H2,H3,MYPROC,NPROC,TIDS,NMSG)
      LBFRN=H2(1)
      LBFIN=H2(2)
      LBFRE=H2(3)
      LBFIE=H2(4)
      LBFRD=H2(5)
      LBFID=H2(6)
      LBFN=(LBFRN+(LBFIN+RPI-1)/RPI)*RPI
      LBFE=(LBFRE+(LBFIE+RPI-1)/RPI)*RPI
      LBFD=(LBFRD+(LBFID+RPI-1)/RPI)*RPI
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU21----------------------------------------------------
      E    N    D
