C:::::      ,,,,,VEMU22...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU22 (LOUT,NODNUM,NOD,DIM,NN,NOPARM,NOP,NOP1,NDEG,
     &                   SBT,LBFI,IBUF,LBFR,RBUF,NDEGL,NDEG0L,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU22   prints the nodes over all processes               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           LOUT,NN,DIM,NDEG,NDEGL,NDEG0L,NOP1,NOP,
     &                  IOTID,MYPROC,NPROC,NMSG,LBFI,LBFR,SBT
      INTEGER           NODNUM(NDEG),IBUF(LBFI,SBT),TIDS(NPROC)
      DOUBLE PRECISION  NOD(NN,DIM),NOPARM(NOP1,NOP),RBUF(LBFR,SBT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I output file
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers           array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I node coordinates          array: NOD(NN,DIM)
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C NOPARM I  R   I in  I node parameters        array: NOPARM(NOP1,NOP)
C--------I------I-----I------------------------------------------------
C NDEGL  I  I   I in  I number of geometrical nodes in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C NDEG0L I  I   I in  I first geometrical node-1 in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer            array: IBUF(LBFI,SBT)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I -   I real buffer               array: RBUF(LBFR,SBT)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I  process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I  task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           J,TOTID,FRTID,LL9MAP,P,MIDS1,MIDR1,NH,INFO,
     &                  Z,MYTID,NOD0,NOPRM0,SWPBUF,RCVBUF,SNDBUF,MIDR2,
     &                  MIDS2,TOKEN(1)
      include"bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** distribution of nodes:                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      TOTID=TIDS(LL9MAP(MYPROC+1,NPROC))
      FRTID=TIDS(LL9MAP(MYPROC-1,NPROC))
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)
	
      IBUF(1,SNDBUF)=NDEGL
      IBUF(2,SNDBUF)=NDEG0L
      DO 100 P=1,NPROC
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,NMSG+P,IINT*2,IBUF(1,RCVBUF),MIDR1,INFO)
	    CALL MPSNDA(TOTID,NMSG+P,IINT*2,IBUF(1,SNDBUF),MIDS1,INFO)
          ENDIF
	  DO 101 Z=3,LBFI
101         IBUF(Z,RCVBUF)=0
	  DO 102 Z=1,LBFR
102         RBUF(Z,RCVBUF)=0
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,NMSG+P,IINT*2,IBUF(1,RCVBUF),MIDR1,INFO)
          ENDIF
	ELSE
	  CALL MPRCVA(FRTID,NMSG+P,IINT*LBFI,IBUF(1,RCVBUF),MIDR1,INFO)
	  CALL MPRCVA(FRTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,RCVBUF),
     &                                                      MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*LBFI,IBUF(1,SNDBUF),MIDS1,INFO)
	  CALL MPSNDA(TOTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,SNDBUF),
     &                                                      MIDS2,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*LBFI,IBUF(1,RCVBUF),MIDR1,INFO)
        ENDIF
C**                                                                 ***
        NDEGL=IBUF(1,RCVBUF)
        NDEG0L=IBUF(2,RCVBUF)
	NOD0=0
	NOPRM0=NOD0+DIM*NDEGL
	DO 130 Z=1,NDEG
	  NH=NODNUM(Z)-NDEG0L
	  IF ((NH.GT.0).AND.(NH.LE.NDEGL)) IBUF(2+NH,RCVBUF)=1
130     CONTINUE
C**                                                                 ***
	IF (P.GT.1)
     &      CALL MPRCVW(FRTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,RCVBUF),
     &                                                      MIDR2,INFO)
C**                                                                 ***
	DO 131 J=1,DIM
	  DO 131 Z=1,NDEG
	    NH=NODNUM(Z)-NDEG0L
	    IF ((NH.GT.0).AND.(NH.LE.NDEGL))
     &                         RBUF(NOD0+DIM*(NH-1)+J,RCVBUF)=NOD(Z,J)
131     CONTINUE
	DO 132 J=1,NOP
	  DO 132 Z=1,NDEG
	    NH=NODNUM(Z)-NDEG0L
	    IF ((NH.GT.0).AND.(NH.LE.NDEGL))
     &                    RBUF(NOPRM0+NOP*(NH-1)+J,RCVBUF)=NOPARM(Z,J)
132     CONTINUE
C**                                                                 ***
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) 
     &       CALL MPSNDW(TOTID,NMSG+P,IINT*2,IBUF(1,SNDBUF),MIDS1,INFO)
	ELSE
	  CALL MPSNDW(TOTID,NMSG+P,IINT*LBFI,IBUF(1,SNDBUF),MIDS1,INFO)
	  CALL MPSNDW(TOTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,SNDBUF),
     &                                                      MIDS2,INFO)
        ENDIF
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
100   CONTINUE
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   Print the node values :                                       ***
C**   ----------------------                                        ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        WRITE (LOUT,9100)
        WRITE (LOUT,9110) NOP
        IF (NOP.EQ.0) WRITE (LOUT,9111)
        WRITE (LOUT,9125)
        DO 400 P=1,NPROC
	  IF (TIDS(P).NE.IOTID) THEN
	    CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS1,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS1,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+NPROC,IINT*LBFI,IBUF(1,SNDBUF),
     &                                                      MIDR1,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+2*NPROC,IREAL*LBFR,RBUF(1,SNDBUF),
     &                                                      MIDR2,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+NPROC,IINT*LBFI,IBUF(1,SNDBUF),
     &                                                      MIDR1,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+2*NPROC,IREAL*LBFR,RBUF(1,SNDBUF),
     &                                                      MIDR2,INFO)
          ENDIF
          NDEGL=IBUF(1,SNDBUF)
          NDEG0L=IBUF(2,SNDBUF)
	  NOD0=0
	  NOPRM0=NOD0+DIM*NDEGL
          DO 300 Z=1,NDEGL
            IF (IBUF(2+Z,SNDBUF).GT.0) THEN
              IF (NOP.GT.0) THEN
                WRITE(LOUT,9130) Z+NDEG0L
                WRITE(LOUT,9131) 
     &                  (RBUF(NOD0+J+DIM*(Z-1)+J,SNDBUF),J=1,DIM)
                WRITE(LOUT,9132)
     &                (RBUF(NOPRM0+J+NOP*(Z-1),SNDBUF),J=1,MIN(NOP,3))
                IF (NOP.GT.3) WRITE(LOUT,9133)
     &                       (RBUF(NOPRM0+J+NOP*(Z-1),SNDBUF),J=3,NOP)
                WRITE(LOUT,9125)
              ELSE
                 WRITE(LOUT,9120) Z+NDEG0L,
     &                        (RBUF(NOD0+J+DIM*(Z-1),SNDBUF),J=1,DIM)
              ENDIF
            ENDIF
 300      CONTINUE
400     CONTINUE
      ELSE
	CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR1,INFO)
	CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR1,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC+NPROC,IINT*LBFI,IBUF(1,SNDBUF),
     &                                                       MIDS1,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC+2*NPROC,IREAL*LBFR,RBUF(1,SNDBUF),
     &                                                       MIDS2,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+NPROC,IINT*LBFI,IBUF(1,SNDBUF),
     &                                                       MIDS1,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+2*NPROC,IREAL*LBFR,RBUF(1,SNDBUF),
     &                                                       MIDS2,INFO)
      ENDIF
      NMSG=NMSG+3*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9100  FORMAT(/'  geometrical nodes'/2X,17('-')/)
9110  FORMAT(2X,'number of node parameters : ',I5/)
9111  FORMAT('  global number         coordinates')
9120  FORMAT(3X,I10,6X,3(E16.9,2X))
9130  FORMAT('  global number :',I10)
9131  FORMAT(2X,'coordinates :',5X,3(E16.9,2X))
9132  FORMAT(2X,'parameters  :',5X,3(E16.9,2X))
9133  FORMAT((20X,3(E16.9,2X)))
9125  FORMAT(2X,77('-'))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU22----------------------------------------------------
      E    N    D
