C:::::      ,,,,,VEMU23...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU23 (LOUT,DIS,OWN,NODNUM,NDEG,NGROUP,GINFO1,GINFO,
     &                   SUMNE,LNEK,NEK,LIPRM,IPARM,LRPRM,RPARM,
     &                   LBFI,IBUF,LBFR,RBUF,LBF,BUF,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMU23      print elements over all processes                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           OWN,NDEG,LBF,GINFO1,NGROUP,LIPRM,LNEK,
     &                  IOTID,MYPROC,NPROC,NMSG,LOUT,DIS,
     &                  LBFI,LBFR,LRPRM
      INTEGER           NODNUM(NDEG),TIDS(NPROC),BUF(LBF),
     &                  GINFO(GINFO1,NGROUP),IPARM(LIPRM),NEK(LNEK),
     &                  IBUF(LBFI),SUMNE(NGROUP)
      DOUBLE PRECISION  RPARM(LRPRM),RBUF(LBFR)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I unit for messages
C--------I------I-----I------------------------------------------------
C DIS    I  I   I in  I =220964 => GEONEK refers to processwise
C        I      I     I            numbering of geometrical nodes
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers           array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  arrary: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I in  I integer parameters for elements
C--------I------I-----I------------------------------------------------
C RPARM  I  I   I in  I real parameters for elements
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer            array: IBUF(LBFI)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I -   I real buffer            array: RBUF(LBFR)
C--------I------I-----I------------------------------------------------
C BUF    I  I   I -   I buffer            array: BUF(LBF)
C        I      I     I it is equivalent to (RBUF,IBUF) !
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           GEOTYP,I,G,NE,ADIVP,J,NEK1,ADISP,
     &                  ADDGEO,FORM,GEO1,NIVP,CLASS,INFO,
     &                  MYTID,P,MIDS,MIDR,NEK0,IP0,RP0,
     &                  GEO0,NELTYP,NT,D,SUM,NT0,NRSP,ADRSP,ADRVP,
     &                  RVP1,NRVP,ADDNEK,TOTNT,NISP,IVP1,TOKEN(1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      IF (MYTID.EQ.IOTID) WRITE (LOUT,9200)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of group loop:                                          ***
C**   -------------------                                           ***
C**                                                                 ***
      DO 9999 G=1,NGROUP
        NE     = GINFO(1,G)
        GEOTYP = GINFO(2,G)
        FORM   = GINFO(3,G)
        CLASS  = GINFO(4,G)

        ADRSP  = GINFO(8,G)
        NRSP   = GINFO(9,G)
        ADRVP  = GINFO(10,G)
        RVP1   = GINFO(11,G)
        NRVP   = GINFO(12,G)

        ADISP  = GINFO(13,G)
        NISP   = GINFO(14,G)
        ADIVP  = GINFO(15,G)
        IVP1   = GINFO(16,G)
        NIVP   = GINFO(17,G)
        ADDNEK= GINFO(21,G)
        NEK1  = GINFO(22,G)
        TOTNT = GINFO(23,G)
        NELTYP= 23
        IF ((OWN.EQ.0).AND.(DIS.NE.220964)) THEN
          ADDGEO=ADDNEK
          GEO1=NEK1
        ELSE
          ADDGEO = GINFO(5,G)
          GEO1   = GINFO(6,G)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** copy elements into buffer :                                 ***
C**     -------------------------                                   ***
C**                                                                 ***
        IBUF(1)=NE
        GEO0=1
        IP0=GEO0+NE*GEOTYP
        NEK0=IP0+NE*NIVP
        RP0=0
        IF (DIS.EQ.220964) THEN
         DO 300 J=1,GEOTYP
           DO 300 I=1,NE
             IBUF(GEO0+GEOTYP*(I-1)+J)=
     &                         NODNUM(NEK(ADDGEO+I-1+(J-1)*GEO1))
  300     CONTINUE
        ELSE
          DO 301 J=1,GEOTYP
            DO 301 I=1,NE
              IBUF(GEO0+GEOTYP*(I-1)+J)=NEK(ADDGEO+I-1+(J-1)*GEO1)
  301     CONTINUE
        ENDIF
        IF (OWN.GT.0) THEN
           DO 310 J=1,TOTNT
             DO 310 I=1,NE
               IBUF(NEK0+TOTNT*(I-1)+J)=NEK(ADDNEK+I-1+NEK1*(J-1))
  310      CONTINUE
        ENDIF
        DO 320 J=1,NIVP
          DO 320 I=1,NE
            IBUF(IP0+NIVP*(I-1)+J)=IPARM(ADIVP+I-1+IVP1*(J-1))
  320   CONTINUE
        DO 330 J=1,NRVP
          DO 330 I=1,NE
            RBUF(RP0+NRVP*(I-1)+J)=RPARM(ADRVP+I-1+RVP1*(J-1))
  330   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** print element values :                                      ***
C**     --------------------                                        ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        WRITE(LOUT,9125)
        WRITE(LOUT,9210) G,SUMNE(G),GEOTYP,FORM,CLASS,NRSP,
     &                                                 NRVP,NISP,NIVP
        IF (NRSP.GT.0) THEN
          WRITE(LOUT,9220) NRSP,(RPARM(ADRSP+J),J=0,MIN(NRSP-1,1))
          IF (NRSP.GT.2) WRITE(LOUT,9225) (RPARM(ADRSP+J),J=2,NRSP-1)
        ENDIF
        IF (NISP.GT.0) THEN
          WRITE(LOUT,9250) NISP,(IPARM(ADISP+J),J=0,MIN(NISP-1,3))
          IF (NISP.GT.4) WRITE(LOUT,9255) (IPARM(ADISP+J),J=4,NISP-1)
        ENDIF
	SUM=0
        DO 400 P=1,NPROC
	  IF (TIDS(P).NE.IOTID) THEN
	    CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+NPROC,IINT*LBF,BUF,MIDR,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+NPROC,IINT*LBF,BUF,MIDR,INFO)
          ENDIF
	  NE=IBUF(1)
          GEO0=1
          IP0=GEO0+NE*GEOTYP
          NEK0=IP0+NE*NIVP
          RP0=0
          DO 22 I=1,NE
            WRITE(LOUT,9125)
            WRITE(LOUT,9280) SUM+I,G
            WRITE(LOUT,9201)
            WRITE(LOUT,9290) (IBUF(GEO0+GEOTYP*(I-1)+J),J=1,GEOTYP)
            IF (OWN.GT.0) THEN
              NT0=0
              DO 100 D=1,MAX(1,OWN)
                NT=GINFO(NELTYP+D,G)
                WRITE(LOUT,9202) D,NT
                IF (NT.GT.0) THEN
                 WRITE(LOUT,9290) (IBUF(NEK0+TOTNT*(I-1)+J+NT0),J=1,NT)
                 NT0=NT0+NT
                ENDIF
  100         CONTINUE
            ENDIF

            IF (NRVP.GT.0) THEN
              WRITE(LOUT,9300) NRVP,
     &                   (RBUF(RP0+NRVP*(I-1)+J),J=1,MIN(NRVP,2))
              IF (NRVP.GT.2) WRITE(LOUT,9225)
     &                          (RBUF(RP0+NRVP*(I-1)+J),J=3,NRVP)
            ENDIF

            IF (NIVP.GT.0) THEN
              WRITE(LOUT,9320) NIVP,
     &                   (IBUF(IP0+NIVP*(I-1)+J),J=1,MIN(NIVP,4))
              IF (NIVP.GT.4) WRITE(LOUT,9255)
     &                          (IBUF(IP0+NIVP*(I-1)+J),J=5,NIVP)
            ENDIF

 22     CONTINUE
	SUM=SUM+NE
400     CONTINUE
        WRITE(LOUT,9125)
      ELSE
	CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
	CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,BUF,MIDS,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,BUF,MIDS,INFO)
      ENDIF
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of group loop:                                            ***
C**   -----------------                                             ***
C**                                                                 ***
9999  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9125  FORMAT(2X,77('-'))
9200  FORMAT(/'  elements'/2X,8('-')/)
9201  FORMAT('  geometry:')
9202  FORMAT('  proposal functions for component ',I6,' NELTYP =',I6)
9210  FORMAT('  group :',I3,25X,'NE     = ',I10,'    GEOTYP = ',I10
     &       /37X,'FORM   = ',I10,'    CLASS  = ',I10
     &       /37X,'NRSP   = ',I10,'    NRVP   = ',I10
     &       /37X,'NISP   = ',I10,'    NIVP   = ',I10)
9220  FORMAT(2X,I3,' real    group parameters :   ',2(1X,E16.9))
9225  FORMAT((1X,4(1X,E16.9)) )
9250  FORMAT(2X,I3,' integer group parameters :',4(I10) )
9255  FORMAT((2X,7(I10)) )
9280  FORMAT(2X,'element number   ',I10,' in group ',I3,' :')
9290  FORMAT((8(I10)) )
9300  FORMAT(2X,I3,' real    parameters :         ',2(1X,E16.9))
9320  FORMAT(2X,I3,' integer parameters :      ',4(I10) )
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU23----------------------------------------------------
      E    N    D
