C:::::      ,,,,,VEMU24...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU24 (LOUT,DIS,OWN,NODNUM,NDEG,NK,DINFO1,DINFO,
     &                   SUMNDC,LDNOD,DNOD,LIDPRM,IDPARM,LRDPRM,RDPARM,
     &                   LBFI,IBUF,LBFR,RBUF,LBF,BUF,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEMU24    print Dirichlet conditions over all processors     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           OWN,NDEG,LBF,DINFO1,NK,LIDPRM,LDNOD,
     &                  IOTID,MYPROC,NPROC,NMSG,LOUT,DIS,
     &                  LBFI,LBFR,LRDPRM
      INTEGER           NODNUM(NDEG),TIDS(NPROC),BUF(LBF),
     &                  DINFO(DINFO1,NK),IDPARM(LIDPRM),DNOD(LDNOD),
     &                  IBUF(LBFI),SUMNDC(NK)
      DOUBLE PRECISION  RDPARM(LRDPRM),RBUF(LBFR)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I print unit
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I number of proposal functions
C--------I------I-----I------------------------------------------------
C DIS    I  I   I in  I =220964 => GEODNOD refers to processwise
C        I      I     I            numbering of geometrical nodes
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers             array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I group informations     arrary: DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I in  I element array
C--------I------I-----I------------------------------------------------
C IDPARM I  I   I in  I integer parameters for Dirichlets conditions
C--------I------I-----I------------------------------------------------
C RDPARM I  I   I in  I real parameters for Dirichlets conditions
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer                array: IBUF(LBFI)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I -   I real buffer                   array: RBUF(LBFR)
C--------I------I-----I------------------------------------------------
C BUF    I  I   I -   I buffer                          array: BUF(LBF)
C        I      I     I it is equivalent to (RBUF,IBUF) !
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           I,G,NDC,ADIVDP,J,ADISDP,ADDCG,NIVDP,INFO,
     &                  MYTID,P,MIDS,MIDR,DNOD0,IP0,RP0,TOKEN(1),
     &                  DNODG0,SUM,NRSDP,ADRSDP,ADRVDP,
     &                  RVDP1,NRVDP,ADDCC,NISDP,IVDP1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      IF (MYTID.EQ.IOTID) WRITE (LOUT,9560)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start of component loop :                                     ***
C**   -----------------------                                       ***
C**                                                                 ***
      DO 9999 G=1,NK
        NDC   = DINFO(1,G)
        ADDCC = DINFO(3,G)
        ADRSDP  = DINFO(4,G)
        NRSDP   = DINFO(5,G)
        ADRVDP  = DINFO(6,G)
        RVDP1   = DINFO(7,G)
        NRVDP   = DINFO(8,G)

        ADISDP  = DINFO(9,G)
        NISDP   = DINFO(10,G)
        ADIVDP  = DINFO(11,G)
        IVDP1   = DINFO(12,G)
        NIVDP   = DINFO(13,G)
        IF ((OWN.EQ.0).AND.(DIS.NE.220964)) THEN
          ADDCG=ADDCC
        ELSE
          ADDCG=DINFO(2,G)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** copy Dirichlet conditions into buffer :                     ***
C**     -------------------------------------                       ***
C**                                                                 ***
        IBUF(1)=NDC
        DNODG0=1
        IP0=DNODG0+NDC
        DNOD0=IP0+NDC*NIVDP
        RP0=0
        IF (DIS.EQ.220964) THEN
          DO 300 I=1,NDC
            IBUF(DNODG0+I)=NODNUM(DNOD(ADDCG+I-1))
  300     CONTINUE
        ELSE
          DO 301 I=1,NDC
            IBUF(DNODG0+I)=DNOD(ADDCG+I-1)
  301     CONTINUE
        ENDIF
        IF (OWN.GT.0) THEN
           DO 310 I=1,NDC
             IBUF(DNOD0+I)=DNOD(ADDCC+I-1)
  310      CONTINUE
        ENDIF
        DO 320 J=1,NIVDP
          DO 320 I=1,NDC
            IBUF(IP0+NIVDP*(I-1)+J)=IDPARM(ADIVDP+I-1+IVDP1*(J-1))
  320   CONTINUE
        DO 330 J=1,NRVDP
          DO 330 I=1,NDC
            RBUF(RP0+NRVDP*(I-1)+J)=RDPARM(ADRVDP+I-1+RVDP1*(J-1))
  330   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** print Dirichlet conditions:                                 ***
C**     --------------------------                                  ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        WRITE(LOUT,9125)
        WRITE(LOUT,9410) G,SUMNDC(G)
        IF (NRSDP.GT.0) THEN
          WRITE(LOUT,9420) NRSDP,RDPARM(ADRSDP+J)
          IF (NRSDP.GT.1) WRITE(LOUT,9225)
     &                                  (RDPARM(ADRSDP+J),J=1,NRSDP-1)
        ENDIF
        IF (NISDP.GT.0) THEN
          WRITE(LOUT,9440) NISDP,(IDPARM(ADISDP+J),J=0,MIN(NISDP-1,2))
          IF (NISDP.GT.3) WRITE(LOUT,9255)
     &                                  (IDPARM(ADISDP+J),J=3,NISDP-1)
        ENDIF
	SUM=0
        DO 400 P=1,NPROC
	  IF (TIDS(P).NE.IOTID) THEN
	    CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+NPROC,IINT*LBF,BUF,MIDR,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+NPROC,IINT*LBF,BUF,MIDR,INFO)
          ENDIF
	  NDC=IBUF(1)
          DNODG0=1
          IP0=DNODG0+NDC
          DNOD0=IP0+NDC*NIVDP
          RP0=0
          DO 22 I=1,NDC
            WRITE (LOUT,9125)
            IF (OWN.GT.0) THEN
              WRITE (LOUT,9461) SUM+I,G,IBUF(DNOD0+I),IBUF(DNODG0+I)
            ELSE
              WRITE (LOUT,9460) SUM+I,G,IBUF(DNODG0+I)
            ENDIF
            IF (NRVDP.GT.0) THEN
              WRITE(LOUT,9300) NRVDP,
     &                   (RBUF(RP0+NRVDP*(I-1)+J),J=1,MIN(NRVDP,2))
              IF (NRVDP.GT.2) WRITE(LOUT,9225)
     &                          (RBUF(RP0+NRVDP*(I-1)+J),J=3,NRVDP)
            ENDIF

            IF (NIVDP.GT.0) THEN
              WRITE(LOUT,9320) NIVDP,
     &                   (IBUF(IP0+NIVDP*(I-1)+J),J=1,MIN(NIVDP,4))
              IF (NIVDP.GT.4) WRITE(LOUT,9255)
     &                          (IBUF(IP0+NIVDP*(I-1)+J),J=5,NIVDP)
            ENDIF

 22     CONTINUE
	SUM=SUM+NDC
400     CONTINUE
        WRITE(LOUT,9125)
      ELSE
	CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
	CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,BUF,MIDS,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,BUF,MIDS,INFO)
      ENDIF
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** end of component loop:                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
9999  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
9560  FORMAT(/'    Dirichlet conditions :'/)
9125  FORMAT(2X,77('-'))
9225  FORMAT((1X,4(1X,E16.9)) )
9255  FORMAT((2X,7(I10)) )
9290  FORMAT((8(I10)) )
9300  FORMAT(2X,I3,' real    parameters :         ',2(1X,E16.9))
9320  FORMAT(2X,I3,' integer parameters :      ',4(I10) )
9400  FORMAT(/'  Dirichlet conditions'/3X,20('-')/)
9410  FORMAT('  component :',I3,25X,'NDC  = ',I10)
9420  FORMAT(2X,I3,' real    parameters for component :            ',
     &                                                      1X,E16.9)
9440  FORMAT(2X,I3,' integer parameters for component :  ',3(I10) )
9460  FORMAT(2X,'condition ',I10,' for component ',I3,
     &                                   ' at geometrical node ',I10)
9461  FORMAT(2X,'condition ',I10,' for component ',I3,
     &                                   ' at global      node ',I10
     &      /40X,' at geometrical node ',I10)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU24----------------------------------------------------
      E    N    D
