C:::::      ,,,,,VEMU30...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU30 (DIM,NOP,NK,COMP6,LLNGTH,NLNGTH,
     &                   MAXTYP,NGROUP,GINFO,GINFO1,DINFO,DINFO1,NINFO,
     &                   LIBUF,LRBUF,
     &                   GNDEG,TOTNE,GNE,GNDC,LENTAB,LCNDEG,LCNE,LCNDC,
     &                   MYPROC,IOTID,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU30  stoarge manager for mesh read                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**               >                                                 ***
      INTEGER      DIM,NOP,NK,COMP6,LIBUF,LRBUF,GNDEG,
     &             MAXTYP,NGROUP,GINFO,GINFO1,DINFO,DINFO1,NINFO,
     &             TOTNE,GNDC,MYPROC,IOTID,NPROC,NMSG

      INTEGER      LENTAB(9,NPROC),LCNDEG(NPROC),LCNE(NPROC),
     &             LCNDC(NPROC),TIDS(NPROC),GNE(0:3,8,32),LLNGTH(9),
     &             NLNGTH(9)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C LLNGTH I  I   I in  I allocated length of mesh arrays 
C        I      I     I                                array: LLNGTH(9)
C--------I------I-----I------------------------------------------------
C NLNGTH I  I   I in  I needed length of mesh arrays 
C        I      I     I                                array: NLNGTH(9)
C--------I------I-----I------------------------------------------------
C MAXTYP I  I   I out I maximal number of nodes in elements GEOTYP
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I only on IOPROC:  actual number of nodes
C        I      I out I all processes
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I out I length managment arrays for element
C GINFO1 I      I     I
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I out I length managment arrays for Dirichlet
C DINFO1 I      I     I conditions
C--------I------I-----I------------------------------------------------
C NINFO  I  I   I out I needed length for mesh infos in IVEM
C--------I------I-----I------------------------------------------------
C LIBUF  I  I   I out I length of integer buffer to distrubute mesh
C        I      I     I may be different on the processes !
C--------I------I-----I------------------------------------------------
C LRBUF  I  I   I out I length of real buffer to distrubute mesh
C        I      I     I may be different on the processes !
C--------I------I-----I------------------------------------------------
C GNDEG  I  I   I in  I global number of nodes      (only on io-process)
C--------I------I-----I------------------------------------------------
C TOTNE  I  I   I in  I global number of elements   (only on io-process)
C--------I------I-----I------------------------------------------------
C GNE    I  I   I in  I GNE(CLASS,FORM,GEOTYP) is the number of
C        I      I     I elements with (CLASS,FORM,GEOTYP)
C        I      I     I (only on io-process)       array: GNE(0:3,8,32)
C--------I------I-----I------------------------------------------------
C GNDC   I  I   I in  I number of nodes with Dirichlet Conditions in
C        I      I     I any component               (only on io-process)
C--------I------I-----I------------------------------------------------
C LENTAB I  I   I out I local length of the mesh arrays
C        I      I     I   (1,P) LNODN  at process P
C        I      I     I   (2,P) LNOD   at process P
C        I      I     I   (3,P) LNOPRM at process P
C        I      I     I   (4,P) LNEK   at process P
C        I      I     I   (5,P) LIPRAM at process P
C        I      I     I   (6,P) LRPRAM at process P
C        I      I     I   (7,P) LDNOD  at process P
C        I      I     I   (8,P) LIDPRM at process P
C        I      I     I   (9,P) LRDPRM at process P
C        I      I     I (only on io-process)     array: LENTAB(9,NPROC)
C--------I------I-----I------------------------------------------------
C LCNDEG I  I   I out I max. LCNDEG(P) geometrical nodes
C        I      I     I are send to processor P
C        I      I     I (only on io-process)       array: LCNDEG(NPROC)
C--------I------I-----I------------------------------------------------
C LCNE   I  I   I out I only on IOPROC. max. LCNE(P) elements
C        I      I     I are send to processor P
C        I      I     I (only on io-process)         array: LCNE(NPROC)
C--------I------I-----I------------------------------------------------
C LCNDC  I  I   I out I max. LCNDC(P) nodes with
C        I      I     I Dirichlet conditions in any component
C        I      I     I are send to processor P
C        I      I     I (only on io-process)         array: LCNE(NPROC)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I logical process id of the process
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I physical process id of io-process
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I logical to physical process id map
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include           "bytes.h"
      INTEGER           CLASS,FORM,GEOTYP,MYTID,I,INFO,MIDS,MIDR,P,
     &                  MYDEG,MYNE,MYNDC,J,NGLEN(9),LGLEN(9),MESS(6),
     &                  NE0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set the needed storage NGLEN over all processes:              ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        NGLEN(1) = GNDEG
        NGLEN(2) = GNDEG*DIM
        NGLEN(3) = GNDEG*NOP
	MAXTYP=0
        DO 1 CLASS=0,3
	  DO 1 FORM=1,8
	    DO 1 GEOTYP=1,32
	      IF (GNE(CLASS,FORM,GEOTYP).GT.0) MAXTYP=MAX(MAXTYP,GEOTYP)
1       CONTINUE
        NGLEN(4) = TOTNE*MAXTYP
        NGLEN(5) = TOTNE*2
        NGLEN(6) = GNE(0,1,1)*6
        IF (COMP6.EQ.0) THEN
          NGLEN(7) = GNDC*NK
          NGLEN(8) = GNDC*NK
          NGLEN(9) = GNDC*NK
        ELSE
          NGLEN(7) = GNDC
          NGLEN(8) = 0
          NGLEN(9) = GNDC
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** IOTID gathers the available storages in LENTAB and            ***
C**   computes the available storage LGLEN over all processes:      ***
C**                                                                 ***
      DO 10 J=1,9
 10     LGLEN(J) = 0

      IF (MYTID.NE.IOTID) THEN
        CALL MPSNDA(IOTID,NMSG+MYPROC,9*IINT,LLNGTH,MIDS,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC,9*IINT,LLNGTH,MIDS,INFO)
      ELSE
        DO 20 P=1,NPROC
          IF (TIDS(P).NE.IOTID) THEN
            CALL MPRCVA(TIDS(P),NMSG+P,9*IINT,LENTAB(1,P),MIDR,INFO)
            CALL MPRCVW(TIDS(P),NMSG+P,9*IINT,LENTAB(1,P),MIDR,INFO)
          ELSE
	    DO 21 I=1,9
21            LENTAB(I,P)=LLNGTH(I)
          ENDIF
	  LENTAB(4,P)=LENTAB(4,P)/2
	  LENTAB(7,P)=LENTAB(7,P)/2
          DO 22 I=1,9
  22        LGLEN(I) = LGLEN(I) + LENTAB(I,P)
20      CONTINUE
      ENDIF
      NMSG=NMSG+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the io-process distributes the mesh array corresponding       ***
C**   to the parts of the storages on the process in the            ***
C**   total storage. significant are the lengths of NODNUM          ***
C**   for the geometrical nodes, IPARM for the elements             ***
C**   and DNOD for the Dirichlet conditions:                        ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
	MESS(1)=NGROUP
	MESS(2)=MAXTYP
	MYDEG=0
	MYNE=0
	MYNDC=0
	NE0=0

        DO 42 P=1,NPROC
	  LCNDEG(P)=(LENTAB(1,P)*DBLE(NGLEN(1))+LGLEN(1)-1)/LGLEN(1)
	  LCNE(P)=((LENTAB(5,P)/2)*DBLE(NGLEN(5)/2)+(LGLEN(5)/2)-1)/
     &                                                    (LGLEN(5)/2)
          IF (COMP6.EQ.0) THEN
	   LCNDC(P)=((LENTAB(7,P)/NK)*DBLE(NGLEN(7)/NK)+(LGLEN(7)/NK)
     &                                               -1)/(LGLEN(7)/NK)
          ELSE
            LCNDC(P)=(LENTAB(7,P)*DBLE(NGLEN(7))+LGLEN(7)-1)/LGLEN(7)
          ENDIF

          MESS(3)=LCNDEG(P)
          MESS(4)=LCNE(P)
          MESS(5)=LCNDC(P)
          MESS(6)=GNE(0,1,1)

          MYDEG=MAX(MESS(3),MYDEG)
          MYNE=MAX(MESS(4),MYNE)
          MYNDC=MAX(MESS(5),MYNDC)
          NE0=MAX(MESS(6),NE0)
	  IF (TIDS(P).NE.MYTID) THEN
            CALL MPSNDA(TIDS(P),NMSG+P,6*IINT,MESS,MIDS,INFO)
            CALL MPSNDW(TIDS(P),NMSG+P,6*IINT,MESS,MIDS,INFO)
          ENDIF
42      CONTINUE
      ELSE
        CALL MPRCVA(IOTID,NMSG+MYPROC,6*IINT,MESS,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,6*IINT,MESS,MIDR,INFO)
        NGROUP=MESS(1)
        MAXTYP=MESS(2)
        MYDEG=MESS(3)
        MYNE=MESS(4)
        MYNDC=MESS(5)
        NE0=MESS(6)
      ENDIF
      NMSG=NMSG+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the needed lengths of the mesh arrays are set :           ***
C**   -------------------------------------------------             ***
C**                                                                 ***
      NLNGTH(1) = MYDEG
      NLNGTH(2) = MYDEG*DIM
      NLNGTH(3) = MYDEG*NOP
      NLNGTH(4) = MYNE*MAXTYP*2
      NLNGTH(5) = MYNE*2
      NLNGTH(6) = NE0*6
      IF (COMP6.EQ.0) THEN
        NLNGTH(7) = MYNDC*NK*2
        NLNGTH(8) = MYNDC*NK
        NLNGTH(9) = MYNDC*NK
      ELSE
        NLNGTH(7) = MYNDC*2
        NLNGTH(8) = 0
        NLNGTH(9) = MYNDC
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the max. buffer lengths are set:                          ***
C**   -----------------------------------                           ***
C**                                                                 ***
      LIBUF=1+MYDEG
      LRBUF=MYDEG*(DIM+NOP)
      LIBUF=MAX(1+3*NGROUP+MYNE*(MAXTYP+3),LIBUF)
      LRBUF=MAX(6*GNE(0,1,1),LRBUF)
      IF (COMP6.EQ.0) THEN
        LIBUF=MAX((MYNDC+NK-1)/NK*(NK+1),LIBUF)
        LRBUF=MAX(MYNDC,LRBUF)
      ELSE
        LIBUF=MAX(1+NK+2*MYNDC,LIBUF)
        LRBUF=MAX(MYNDC,LRBUF)
      ENDIF
      GINFO=30
      GINFO1=23+2*NK
      DINFO=GINFO+NGROUP*GINFO1
      DINFO1=14
      NINFO=DINFO+DINFO1*NK+3*(NGROUP+2+NK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU30-----------------------------------------------------
      E    N    D
