C:::::      ,,,,,VEMU31...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU31 (UNITIN,GNDEG,GNE,GROUP,NGROUP,TOTNE,NK,
     &                   GNDC,MYPROC,LOUT,OUTCNT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU31    computes a statistic of a vecfem input file      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**               >                                                 ***
      INTEGER      UNITIN,GNDEG,NGROUP,TOTNE,GNDC,MYPROC,
     &             NK,LOUT,OUTCNT,ERR
      INTEGER      GNE(0:3,8,32),GROUP(0:3,8,32)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNITIN I  I   I in  I unit of vecfem input file
C--------I------I-----I------------------------------------------------
C GNDEG  I  I   I out I global number of geometrical nodes
C--------I------I-----I------------------------------------------------
C GNE    I  I   I out I GNE(CLASS,FORM,GEOTYP) number of elements
C        I      I     I element type (CLASS,FORM,GEOTYP)
C        I      I     I                            array: GNE(0:3,8,32)
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I out I GROUP(CLASS,FORM,GEOTYP) is the group id of
C        I      I     I element type (CLASS,FORM,GEOTYP)
C        I      I     I                            array: GNE(0:3,8,32)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I out I number of groups (including node forces)
C--------I------I-----I------------------------------------------------
C TOTNE  I  I   I out I total number of element (including node forces)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C GNDC   I  I   I out I number of nodes with dirichlet conditions
C        I      I     I and different restrain id.
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I logical process id
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I print unit
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I >0 a protocol is printed
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error code =0 no error
C        I      I     I            =99 read error
C        I      I     I            =96 illegal element or load type
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include           "bytes.h"
      INTEGER          NODNUM,ZW(32),CLASS,FORM,GEOTYP,ELMNUM,NE,G,D,I,
     &                 NG1,NDC,NK1,NCARD,J
      DOUBLE PRECISION X1,X2,X3
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 10 CLASS=0,3
        DO 10 FORM=1,8
          DO 10 GEOTYP=1,32
	    GROUP(CLASS,FORM,GEOTYP)=0
 10         GNE(CLASS,FORM,GEOTYP)=0
      GNDC=0
      GNDEG=0
      IF (OUTCNT.GT.0) WRITE(LOUT,9000)
      ERR=0
      NCARD=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** geometrical nodes:                                            ***
C**   -----------------                                             ***
C**                                                                 ***
      READ(UNITIN,*,ERR=9999,END=9999) GNDEG
      NCARD=NCARD+1
      IF (OUTCNT.GT.0) WRITE(LOUT,9010) GNDEG
      DO 1000 I=1,GNDEG
         READ(UNITIN,*,ERR=9999,END=9999) NODNUM,X1,X2,X3
1000     NCARD=NCARD+1

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** elements :                                                    ***
C**   --------                                                      ***
C**                                                                 ***
      READ(UNITIN,*,ERR=9999,END=9999) NG1
      NCARD=NCARD+1
      DO 2000 G=1,NG1
        READ(UNITIN,*,ERR=9999,END=9999) NE,CLASS,FORM,GEOTYP
	NCARD=NCARD+1
	IF ((CLASS.LT.0).OR.(CLASS.GT.3).OR.
     &      (FORM.LT.1).OR.(FORM.GT.8).OR.
     &      (GEOTYP.LT.1).OR.(GEOTYP.GT.32)) THEN
	  ERR=96
	  WRITE(LOUT,9120) NCARD,NCARD,CLASS,FORM,GEOTYP
	  IF (GEOTYP.GT.32) GOTO 8888
        ELSE
	  GNE(CLASS,FORM,GEOTYP)=NE
        ENDIF
        DO 2010 I=1,NE
           READ(UNITIN,*,ERR=9999,END=9999) ELMNUM,(ZW(J),J=1,GEOTYP)
2010       NCARD=NCARD+1
2000  CONTINUE

      NGROUP=0
      TOTNE=0
      DO 20 CLASS=0,3
        DO 20 FORM=1,8
          DO 20 GEOTYP=1,32
            TOTNE=TOTNE+GNE(CLASS,FORM,GEOTYP)
            IF (GNE(CLASS,FORM,GEOTYP).GT.0) THEN
	       NGROUP=NGROUP+1
               GROUP(CLASS,FORM,GEOTYP)=NGROUP
            ENDIF
 20   CONTINUE
      IF (OUTCNT.GT.0) THEN
         WRITE(LOUT,9020) NG1
         WRITE(LOUT,9021) NGROUP
         WRITE(LOUT,9025) TOTNE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Dirichlet conditions:                                         ***
C**   --------------------                                          ***
C**                                                                 ***
      READ(UNITIN,*,ERR=9999,END=9999) NK1
      NCARD=NCARD+1
      DO 3000 D=1,MIN(NK,NK1)
        READ(UNITIN,*,ERR=9999,END=9999) NDC
	GNDC=GNDC+NDC
	NCARD=NCARD+1
        DO 3010 I=1,NDC
           READ(UNITIN,*,ERR=9999,END=9999) NODNUM,X1
3010       NCARD=NCARD+1
3000  CONTINUE
      IF (OUTCNT.GT.0) WRITE(LOUT,9035) GNDC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the input file is defectiv:                                   ***
C**   --------------------------                                    ***
C**                                                                 ***
      GOTO 8888
9999  ERR=99
      WRITE(LOUT,9130) NCARD+1,NCARD+1
8888  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9000  FORMAT(/1X,'file statistics:')
9010  FORMAT(3X,'number of geometrical nodes ............ NDEG = ',I9)
9020  FORMAT(3X,'number of groups in data set ................ = ',I9)
9021  FORMAT(3X,'actual number of groups .............. NGROUP = ',I9)
9025  FORMAT(3X,'total number of elements .................... = ',I9)
9035  FORMAT(3X,'number of Dirichlet nodes ................... = ',I9)
9120  FORMAT('>>VEMCD:01:0001:',I9
     &      /'>>illegal element type in card ',I9
     &      /'>>(CLASS,FORM,GEOTYP)=(',I3,',',I3,',',I3,')')
9130  FORMAT('>>VEMCD:01:9999:',I9/'>>read error in card ',I9)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU31-----------------------------------------------------
      E    N    D
