C:::::      ,,,,,VEMU32...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU32 (UNITIN,DIM,NOP,NDEG,NN,NOP1,
     &                   LNODN,NODNUM,LNOD,NOD,LNOPRM,NOPARM,
     &                   GNDEG,LCNDEG,LIBUF,IBUF,LRBUF,RBUF,
     &                   MYPROC,IOTID,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU32   reads the node coordinates from the VECFEM        ***
C**               mesh file and distributes it to the               ***
C**               processes.                                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNITIN,DIM,NDEG,NN,LNODN,LNOD,GNDEG,LIBUF,LRBUF,
     &                  MYPROC,IOTID,NPROC,NMSG,NOP,NOP1,LNOPRM
      DOUBLE PRECISION  NOD(LNOD),NOPARM(LNOPRM),RBUF(LRBUF)
      INTEGER           NODNUM(LNODN),LCNDEG(NPROC),IBUF(LIBUF),
     &                  TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNITIN I  I   I in  I unit of a vecfem input file
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C NDEG   I  I   I out I number of geometrical nodes on process
C--------I------I-----I------------------------------------------------
C NN     I  I   I out I leading dimension of NOD
C--------I------I-----I------------------------------------------------
C NOP1   I  I   I out I leading dimension of NOPARM
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I out I id numbers of the geometrical nodes
C        I      I     I array : NODNUM(LNODN)
C--------I------I-----I------------------------------------------------
C NOD    I  R   I out I coordinates of the geometrical nodes
C        I      I     I array : NOD(LNOD)
C--------I------I-----I------------------------------------------------
C NOPARM I  I   I out I node parameters
C        I      I     I array : NOPARM(LNOPRM)
C--------I------I-----I------------------------------------------------
C GNDEG  I  I   I in  I  global number of geometrical nodes
C        I      I     I  (only on io-process)
C--------I------I-----I------------------------------------------------
C LCNDEG I  I   I in  I max. LCNDEG(P) geometrical nodes
C        I      I     I are send to processor P
C        I      I     I array : LCNDEG(NPROC)       (only on io-process)
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I  -  I integer buffer to distrubute mesh
C        I      I     I array : IBUF(LIBUF)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I  -  I real buffer to distrubute mesh
C        I      I     I array : RBUF(LRBUF)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I logical process id of the process
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I physical process id of io-process
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I logical to physical process id map
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***

      include "bytes.h"
      INTEGER           P,MYTID,COUNT,N1,I,Z,MESS(2),MIDS,INFO,MIDR,
     &                  LNDEG
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)

      IF (MYTID.EQ.IOTID) THEN
	READ(UNITIN,*) N1
	LNDEG=0

	DO 1000 P=NPROC,1,-1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** read nodes till the quota of process P is fullfilled:     ***
C**       ----------------------------------------------------      ***
C**                                                                 ***
 	  COUNT=0
1010      CONTINUE
          IF ((COUNT.LT.LCNDEG(P)).AND.(COUNT+LNDEG.LT.GNDEG)) THEN
	    COUNT=COUNT+1
	    READ(UNITIN,*) IBUF(1+COUNT),
     &                            (RBUF(I+DIM*(COUNT-1)),I=1,DIM)
	    GOTO 1010
          ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** send read nodes to process p:                             ***
C**       ----------------------------                              ***
C**                                                                 ***
	  IBUF(1)=COUNT
 	  IF (IOTID.NE.TIDS(P)) THEN
	    MESS(1)=1+COUNT
	    MESS(2)=COUNT*DIM
	    CALL MPSNDA(TIDS(P),NMSG+P,2*IINT,MESS,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,2*IINT,MESS,MIDS,INFO)
	    CALL MPSNDA(TIDS(P),NMSG+NPROC+P,IINT*MESS(1),
     &                                            IBUF,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+NPROC+P,IINT*MESS(1),
     &                                            IBUF,MIDS,INFO)
	    CALL MPSNDA(TIDS(P),NMSG+2*NPROC+P,IREAL*MESS(2),
     &                                            RBUF,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+2*NPROC+P,IREAL*MESS(2),
     &                                            RBUF,MIDS,INFO)
          ENDIF
	  LNDEG=LNDEG+COUNT

1000    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** receive the nodes:                                            ***
C**   -----------------                                             ***
C**                                                                 ***
C**   if IOTID is the first process the data are already on         ***
C**   IBUF and RBUF                                                 ***
C**                                                                 ***
      IF (IOTID.NE.MYTID) THEN
        CALL MPRCVA(IOTID,NMSG+MYPROC,2*IINT,MESS,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,2*IINT,MESS,MIDR,INFO)
        CALL MPRCVA(IOTID,NMSG+NPROC+MYPROC,IINT*MESS(1),
     &                                             IBUF,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+NPROC+MYPROC,IINT*MESS(1),
     &                                             IBUF,MIDR,INFO)
        CALL MPRCVA(IOTID,NMSG+2*NPROC+MYPROC,IREAL*MESS(2),
     &                                             RBUF,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+2*NPROC+MYPROC,IREAL*MESS(2),
     &                                             RBUF,MIDR,INFO)
      ENDIF
      NMSG=NMSG+3*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy data from buffers into mesh arrays:                      ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      NDEG=IBUF(1)
      NN=IBUF(1)
      NOP1=IBUF(1)
      IF ((NDEG.LE.LNODN).AND.(NDEG*DIM.LE.LNOD).AND.
     &                                       (NDEG*NOP.LE.LNOPRM)) THEN
	DO 2000 Z=1,NDEG
	  NODNUM(Z)=IBUF(Z+1)
2000    CONTINUE
	DO 2010 I=1,DIM
	  DO 2010 Z=1,NDEG
	     NOD(Z+NN*(I-1))=RBUF(I+(DIM+NOP)*(Z-1))
2010    CONTINUE
	DO 2020 I=1,NOP
	  DO 2020 Z=1,NDEG
	     NOD(Z+NOP1*(I-1))=RBUF(DIM+I+(DIM+NOP)*(Z-1))
2020    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU32----------------------------------------------------
      E    N    D
