C:::::      ,,,,,VEMU33...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU33 (UNITIN,NGROUP,GINFO1,GINFO,LNEK,NEK,NNEK,
     &                   LIPARM,IPARM,NIPARM,LRPARM,RPARM,NRPARM,
     &                   TOTNE,LCNE,GNE,GROUP,LIBUF,IBUF,LRBUF,RBUF,
     &                   MYPROC,IOTID,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU33   reads the elements from the vecfem                ***
C**               mesh file and distributes it to the               ***
C**               processes.                                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNITIN,NGROUP,GINFO1,LNEK,LIPARM,LIBUF,LRBUF,
     &                  MYPROC,IOTID,NPROC,NMSG,TOTNE,
     &                  LRPARM,NNEK,NIPARM,NRPARM
      DOUBLE PRECISION  RPARM(LRPARM),RBUF(LRBUF)
      INTEGER           NEK(LNEK),IPARM(LIPARM),LCNE(NPROC),
     &                  IBUF(LIBUF),GNE(0:3,8,32),GROUP(0:3,8,32),
     &                  GINFO(GINFO1,NGROUP),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNITIN I  I   I in  I unit of a vecfem input file
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups (including node forces)
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I out I group informations  array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I out I elements                       array: NEK(LNEK)
C--------I------I-----I------------------------------------------------
C NNEK   I  I   I out I needed length of NEK
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I out I integer element parameters
C        I      I     I                            array: IPARM(LIPARM)
C--------I------I-----I------------------------------------------------
C NIPARM I  I   I out I needed length of IPARM
C--------I------I-----I------------------------------------------------
C RPARM  I  R   I out I real element parameters
C        I      I     I                            array: RPARM(LRPARM)
C--------I------I-----I------------------------------------------------
C NRPARM I  I   I out I needed length of RPARM
C--------I------I-----I------------------------------------------------
C TOTNE  I  I   I out I total number of element (including node forces)
C        I      I     I  (only on io-process)
C--------I------I-----I------------------------------------------------
C GNE    I  I   I in  I  GNE(CLASS,FORM,GEOTYP) number of elements
C        I      I     I  element type (CLASS,FORM,GEOTYP)
C        I      I     I  (only on io-process)      array: GNE(0:3,8,32)
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I in  I  GROUP(CLASS,FORM,GEOTYP) is the group id of
C        I      I     I  element type (CLASS,FORM,GEOTYP)
C        I      I     I  (only on io-process)      array: GNE(0:3,8,32)
C--------I------I-----I------------------------------------------------
C LNE    I  I   I in  I max. LCNE(P) elements are send to processor P
C        I      I     I (only on io-process)          array: LNE(NPROC)
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I  -  I integer buffer to distrubute mesh
C        I      I     I                              array: IBUF(LIBUF)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I  -  I real buffer to distrubute mesh
C        I      I     I                              array: RBUF(LRBUF)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I logical process id of the process
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I physical process id of io-process
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I logical to physical process id map
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include "bytes.h"
      INTEGER           P,MYTID,COUNT,N1,I,MESS(2),MIDS,INFO,MIDR,
     &                  CLASS,FORM,GEOTYP,G,ISTART,RSTART,NE,SENDNE,
     &                  E,ADDNEK,NEK1,ADRVP,RVP1,ADIVP,LNE,IVP1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      NNEK=0
      NIPARM=0
      NRPARM=0
      IF (NGROUP.EQ.0) RETURN

      IF (MYTID.EQ.IOTID) THEN
        DO 1000 CLASS=0,3
          DO 1000 FORM=1,8
            DO 1000 GEOTYP=1,32
              G=GROUP(CLASS,FORM,GEOTYP)
              IF (G.GT.0) THEN
	        IBUF(1+G)=0
	        IBUF(1+G+NGROUP)=GEOTYP
	        IBUF(1+G+2*NGROUP)=FORM
	        IBUF(1+G+3*NGROUP)=CLASS
              ENDIF
1000    CONTINUE

	LNE=0
	READ(UNITIN,*) N1
	READ(UNITIN,*) NE,CLASS,FORM,GEOTYP
        G=GROUP(CLASS,FORM,GEOTYP)

	DO 1010 P=NPROC,1,-1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** read elements till the quota of process P is fullfilled:  ***
C**       -------------------------------------------------------   ***
C**                                                                 ***
	  ISTART=1+4*NGROUP+1
	  RSTART=1
 	  COUNT=0
	  DO 1020 I=1,NGROUP
1020        IBUF(1+I)=0

1030      CONTINUE
          IF ((COUNT.LT.LCNE(P)).AND.(LNE+COUNT.LT.TOTNE)) THEN
	    IF (NE.EQ.0) THEN
	      READ(UNITIN,*) NE,CLASS,FORM,GEOTYP
              G=GROUP(CLASS,FORM,GEOTYP)
	      GOTO 1030
            ENDIF
	    COUNT=COUNT+1
            IBUF(1+G)=IBUF(1+G)+1
	    IBUF(ISTART)=G
	    NE=NE-1
	    READ(UNITIN,*) IBUF(ISTART+1),IBUF(ISTART+2),
     &                                   (IBUF(ISTART+I),I=3,GEOTYP+2)
	    ISTART=ISTART+(GEOTYP+3)
	    GOTO 1030
          ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** send read elements to process p:                          ***
C**       -------------------------------                           ***
C**                                                                 ***
	  IBUF(1)=COUNT
 	  IF (IOTID.NE.TIDS(P)) THEN
	    MESS(1)=ISTART-1
	    MESS(2)=RSTART-1
	    CALL MPSNDA(TIDS(P),NMSG+P,2*IINT,MESS,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,2*IINT,MESS,MIDS,INFO)
	    CALL MPSNDA(TIDS(P),NMSG+NPROC+P,IINT*MESS(1),
     &                                        IBUF,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+NPROC+P,IINT*MESS(1),
     &                                        IBUF,MIDS,INFO)
          ENDIF
	  LNE=LNE+COUNT

1010    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** receive the elements :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**   if IOTID is the first process the data are already on         ***
C**   IBUF and RBUF                                                 ***
C**                                                                 ***
      IF (IOTID.NE.MYTID) THEN
        CALL MPRCVA(IOTID,NMSG+MYPROC,2*IINT,MESS,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,2*IINT,MESS,MIDR,INFO)
        CALL MPRCVA(IOTID,NMSG+NPROC+MYPROC,IINT*MESS(1),
     &                                         IBUF,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+NPROC+MYPROC,IINT*MESS(1),
     &                                         IBUF,MIDR,INFO)
      ENDIF
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy data from buffers into mesh arrays:                      ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      DO 2000 G=1,NGROUP
	GINFO(1,G)=0
	GINFO(3,G)=IBUF(1+G+2*NGROUP)
	GINFO(4,G)=IBUF(1+G+3*NGROUP)
	GINFO(9,G)=0
	GINFO(10,G)=NRPARM+1
	GINFO(11,G)=IBUF(1+G)
	GINFO(12,G)=0
	GINFO(14,G)=0
	GINFO(15,G)=NIPARM+1
	GINFO(16,G)=IBUF(1+G)
	GINFO(17,G)=2
	GINFO(21,G)=NNEK+1
	GINFO(22,G)=IBUF(1+G)
	GINFO(24,G)=IBUF(1+G+NGROUP)
	NNEK=NNEK+IBUF(1+G)*IBUF(1+G+NGROUP)
	NIPARM=NIPARM+GINFO(17,G)*GINFO(16,G)
2000  CONTINUE
      NNEK=NNEK*2

      IF ((NNEK.LE.LNEK).AND.(NIPARM.LE.LIPARM).AND.
     &                                        (NRPARM.LE.LRPARM)) THEN
	
	SENDNE=IBUF(1)
	ISTART=1+4*NGROUP+1
	RSTART=1
	
        DO 2020 E=1,SENDNE

	  G=IBUF(ISTART)
	  GEOTYP=GINFO(24,G)
	  NE=GINFO(1,G)
	  ADDNEK=GINFO(21,G)
	  NEK1=GINFO(22,G)
	  ADRVP=GINFO(10,G)
	  RVP1=GINFO(11,G)
	  ADIVP=GINFO(15,G)
	  IVP1=GINFO(16,G)

	  IPARM(ADIVP+NE)=IBUF(ISTART+1)
	  IPARM(ADIVP+NE+IVP1)=IBUF(ISTART+2)
	  DO 2030 I=1,GEOTYP
2030        NEK(ADDNEK+NE+NEK1*(I-1))=IBUF(ISTART+2+I)

	  GINFO(1,G)=NE+1
	  ISTART=ISTART+(GEOTYP+3)
2020    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU33----------------------------------------------------
      E    N    D
