C:::::      ,,,,,VEMU34...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEMU34 (UNITIN,NK,DINFO1,DINFO,LDNOD,DNOD,NDNOD,   
     &                   LIDPRM,IDPARM,NIDPRM,LRDPRM,RDPARM,NRDPRM,
     &                   GNDC,LCNDC,LIBUF,IBUF,LRBUF,RBUF,
     &                   MYPROC,IOTID,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEMU34   reads the node elements from the vecfem           ***
C**               mesh file and distributes it to the               ***
C**               processes.                                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNITIN,NK,DINFO1,LDNOD,LIDPRM,LIBUF,LRBUF,
     &                  MYPROC,IOTID,NPROC,NMSG,GNDC,NDNOD,NIDPRM,
     &                  LRDPRM,NRDPRM
      DOUBLE PRECISION  RDPARM(LRDPRM),RBUF(LRBUF)
      INTEGER           DNOD(LDNOD),IDPARM(LIDPRM),LCNDC(NPROC),
     &                  IBUF(LIBUF),DINFO(DINFO1,NK),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNITIN I  I   I in  I unit of a vecfem input file
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I out I Dirichlet informations  array: DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I out I Dirichlet nodes              array: DNOD(LDNOD)
C--------I------I-----I------------------------------------------------
C NDNOD  I  I   I out I needed length of DNOD
C--------I------I-----I------------------------------------------------
C IDPARM I  I   I out I integer Dirichlet parameters
C        I      I     I                           array: IDPARM(LIDPRM)
C--------I------I-----I------------------------------------------------
C NIDPRM I  I   I out I needed length of IDPARM
C--------I------I-----I------------------------------------------------
C RDPARM I  R   I out I real Dirichlet parameters
C        I      I     I                           array: RDPARM(LRDPRM)
C--------I------I-----I------------------------------------------------
C NRDPRM I  I   I out I needed length of RDPARM
C--------I------I-----I------------------------------------------------
C GNDC   I  I   I out I total number of Dirichlet conditions
C        I      I     I (only on io-process)
C--------I------I-----I------------------------------------------------
C LCNDC  I  I   I in  I max. LCNDC(P) conditions are send to processor P
C        I      I     I (only on io-process)        array: LCNDC(NPROC)
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I  -  I integer buffer to distrubute mesh
C        I      I     I                              array: IBUF(LIBUF)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I  -  I real buffer to distrubute mesh
C        I      I     I                              array: RBUF(LRBUF)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I logical process id of the process
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I physical process id of io-process
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I logical to physical process id map
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include "bytes.h"
      INTEGER           P,MYTID,COUNT,N1,I,MESS(2),MIDS,INFO,MIDR,
     &                  ISTART,RSTART,SENDNC,NDC,ADRVDP,ADIVDP,
     &                  E,ADDC,LNDC,D
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      NDNOD=0
      NIDPRM=0
      NRDPRM=0
      IF (NK.EQ.0) RETURN

      IF (MYTID.EQ.IOTID) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
	LNDC=0
	READ(UNITIN,*) N1
	IF (N1.EQ.0) RETURN
	READ(UNITIN,*) NDC
	D=1

	DO 1010 P=NPROC,1,-1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** read data till the quota of process P is fullfilled:        ***
C**     ---------------------------------------------------         ***
C**                                                                 ***
	  ISTART=1+NK+1
	  RSTART=1
 	  COUNT=0
	  DO 1020 I=1,NK
1020        IBUF(1+I)=0
C**                                                                 ***
1030      CONTINUE
          IF ((COUNT.LT.LCNDC(P)).AND.(LNDC+COUNT.LT.GNDC)) THEN
	    IF (NDC.EQ.0) THEN
	      READ(UNITIN,*) NDC
	      D=D+1
	      GOTO 1030
            ENDIF
	    COUNT=COUNT+1
            IBUF(1+D)=IBUF(1+D)+1
	    NDC=NDC-1
	    IBUF(ISTART)=D
	    READ(UNITIN,*) IBUF(ISTART+1),RBUF(RSTART)
	    ISTART=ISTART+2
	    RSTART=RSTART+1
	    GOTO 1030
          ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** send read data to prcocess P:                               ***
C**     ---------------------------                                 ***
C**                                                                 ***
	  IBUF(1)=COUNT
 	  IF (IOTID.NE.TIDS(P)) THEN
	    MESS(1)=ISTART-1
	    MESS(2)=RSTART-1
	    CALL MPSNDA(TIDS(P),NMSG+P,2*IINT,MESS,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,2*IINT,MESS,MIDS,INFO)
	    CALL MPSNDA(TIDS(P),NMSG+NPROC+P,IINT*MESS(1),
     &                                        IBUF,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+NPROC+P,IINT*MESS(1),
     &                                        IBUF,MIDS,INFO)
	    CALL MPSNDA(TIDS(P),NMSG+2*NPROC+P,IREAL*MESS(2),
     &                                        RBUF,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+2*NPROC+P,IREAL*MESS(2),
     &                                        RBUF,MIDS,INFO)
          ENDIF
	  LNDC=LNDC+COUNT

1010    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** receive the data:                                             ***
C**   -----------------                                             ***
C**                                                                 ***
C**   if IOTID is the first process the data are already on IBUF    ***
C**   and RBUF:                                                     ***
C**                                                                 ***
      IF (IOTID.NE.MYTID) THEN
        CALL MPRCVA(IOTID,NMSG+MYPROC,2*IINT,MESS,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,2*IINT,MESS,MIDR,INFO)
        CALL MPRCVA(IOTID,NMSG+NPROC+MYPROC,IINT*MESS(1),
     &                                         IBUF,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+NPROC+MYPROC,IINT*MESS(1),
     &                                         IBUF,MIDR,INFO)
        CALL MPRCVA(IOTID,NMSG+2*NPROC+MYPROC,IREAL*MESS(2),
     &                                         RBUF,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+2*NPROC+MYPROC,IREAL*MESS(2),
     &                                         RBUF,MIDR,INFO)
      ENDIF
      NMSG=NMSG+3*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy data from buffers into mesh arrays:                      ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      DO 2000 D=1,NK
	DINFO(1,D)=0
	DINFO(3,D)=NDNOD+1
	DINFO(5,D)=0
	DINFO(6,D)=NRDPRM+1
	DINFO(7,D)=IBUF(1+D)
	DINFO(8,D)=1
	DINFO(10,D)=0
	DINFO(13,D)=0

	NDNOD=NDNOD+IBUF(1+D)
	NRDPRM=NRDPRM+IBUF(1+D)
2000  CONTINUE
	
      IF ((NDNOD.LE.LDNOD).AND.(NIDPRM.LE.LIDPRM).AND.
     &                                (NRDPRM.LE.LRDPRM)) THEN

	SENDNC=IBUF(1)
	ISTART=1+NK+1
	RSTART=1
	
        DO 2020 E=1,SENDNC

	  D=IBUF(ISTART)
	  NDC=DINFO(1,D)
	  ADDC=DINFO(3,D)
	  ADRVDP=DINFO(6,D)
	  ADIVDP=DINFO(11,D)

	  DNOD(ADDC+NDC)=IBUF(ISTART+1)
	  RDPARM(ADRVDP+NDC)=RBUF(RSTART)

	  DINFO(1,D)=NDC+1
	  ISTART=ISTART+2
	  RSTART=RSTART+1
2020    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEMU34----------------------------------------------------
      E    N    D
