C:::::      ,,,,,VEPA03...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEPA03 (UNIOUT,DIS,NODNUM,NDEG,NGROUP,GINFO1,GINFO,
     &                   LNEK,NEK,LIPRM,IPARM,LBF,IBUF,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG,NCARD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEPA03    write element data to neutral file               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNIOUT,NDEG,LBF,GINFO1,NGROUP,LIPRM,LNEK,
     &                  IOTID,MYPROC,NPROC,NMSG,DIS,NCARD
      INTEGER           NODNUM(NDEG),TIDS(NPROC),IBUF(LBF),
     &                  GINFO(GINFO1,NGROUP),IPARM(LIPRM),NEK(LNEK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DATOUT I  I   I in  I output file
C--------I------I-----I------------------------------------------------
C DIS    I  I   I in  I =220964 => GEONEK refers to processwise
C        I      I     I            numbering of geometrical nodes
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers             array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  arrary: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I in  I integer parameters for elements
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer                array: IBUF(LBFI)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I -   I real buffer                   array: RBUF(LBFR)
C--------I------I-----I------------------------------------------------
C BUF    I  I   I -   I buffer                          array: BUF(LBF)
C        I      I     I it is equivalent to (RBUF,IBUF) !
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C NCARD  I  I   I i/o I card counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           ID,GEOTYP,I,G,NE,ADIVP,TOKEN(1),
     &                  ADDGEO,FORM,GEO1,NIVP,CLASS,NE0,ID0,INFO,
     &                  Z,MYTID,NODES0,P,MIDS,MIDR,ELID
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy elements into buffer :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
      NE0=0
      ID0=NE0+NGROUP
      DO 200 G=1,NGROUP
	NE=GINFO(1,G)
	GEOTYP=GINFO(2,G)
        ADDGEO=GINFO(5,G)
        GEO1  =GINFO(6,G)
        ADIVP =GINFO(15,G)
        NIVP  =GINFO(17,G)
	IF ((NE*NIVP.GT.0).AND.(GEOTYP.NE.1)) THEN
	  NODES0=ID0+NE
	  DO 250 Z=1,NE
	    IBUF(ID0+Z)=IPARM(ADIVP-1+Z)
	    IF (DIS.EQ.220964) THEN
              DO 252 I=1,GEOTYP
 252            IBUF(NODES0+GEOTYP*(Z-1)+I)=
     &                               NODNUM(NEK(ADDGEO-1+GEO1*(I-1)+Z))
            ELSE
              DO 253 I=1,GEOTYP
 253            IBUF(NODES0+GEOTYP*(Z-1)+I)=NEK(ADDGEO-1+GEO1*(I-1)+Z)
            ENDIF
 250      CONTINUE
          ID0=NODES0+NE*GEOTYP
	  IBUF(NE0+G)=NE
        ELSE
          IBUF(NE0+G)=0
        ENDIF
 200  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write elements (packet type 02):                              ***
C**   -------------------------------                               ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        DO 400 P=1,NPROC
	  IF (TIDS(P).NE.IOTID) THEN
	    CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+NPROC,IINT*LBF,IBUF,MIDR,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+NPROC,IINT*LBF,IBUF,MIDR,INFO)
          ENDIF
	  NE0=0
	  ID0=NE0+NGROUP
	  DO 300 G=1,NGROUP
	    GEOTYP=GINFO(2,G)
            FORM  =GINFO(3,G)
	    CLASS=GINFO(4,G)
	    NE=IBUF(NE0+G)
            CALL VEPA10(CLASS,FORM,GEOTYP,ELID)
	    IF (NE*ELID.GT.0) THEN
	      NODES0=ID0+NE
	      DO 350 Z=1,NE
	        ID=IBUF(ID0+Z)
                WRITE(UNIOUT,'(I2,8I8)') 2,ID,ELID,
     &                                   1+((GEOTYP+9)/10),(0,I=1,5)
                WRITE(UNIOUT,'(4I8,3E16.9)') GEOTYP,0,1,0,(0.,I=1,3)
                WRITE(UNIOUT,'(10I8)')
     &                    (IBUF(NODES0+GEOTYP*(Z-1)+I),I=1,GEOTYP)
		NCARD=NCARD+2+(GEOTYP+9)/10
 350          CONTINUE
	      ID0=NODES0+NE*GEOTYP
            ENDIF
 300      CONTINUE
400     CONTINUE
      ELSE
        CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,IBUF,MIDS,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,IBUF,MIDS,INFO)
      ENDIF
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEPA03----------------------------------------------------
      E    N    D
