C:::::      ,,,,,VEPA04...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEPA04 (UNIOUT,DIS,NODNUM,NDEG,NGROUP,GINFO1,GINFO,
     &                   LNEK,NEK,LRPRM,RPARM,
     &                   LBFI,IBUF,LBFR,RBUF,LBF,BUF,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG,NCARD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEPA04      write nodal forces to neutral file             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNIOUT,GINFO1,NGROUP,LRPRM,LNEK,LBFI,LBFR,LBF,
     &                  NDEG,IOTID,MYPROC,NPROC,NMSG,DIS,NCARD
      INTEGER           TIDS(NPROC),IBUF(LBFI),BUF(LBF),NODNUM(NDEG),
     &                  GINFO(GINFO1,NGROUP),NEK(LNEK)
      DOUBLE PRECISION  RBUF(LBFR),RPARM(LRPRM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C UNIOUT I  I   I in  I output file
C--------I------I-----I------------------------------------------------
C DIS    I  I   I in  I =220964 => GEONEK refers to processwise
C        I      I     I            numbering of geometrical nodes
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers              array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                  array: NEK(LNEK)
C--------I------I-----I------------------------------------------------
C RPARM  I  R   I in  I real parameters            array: RPARM(LRPARM)
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer                array: IBUF(LBFI)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I -   I real buffer                   array: RBUF(LBFR)
C--------I------I-----I------------------------------------------------
C BUF    I  I   I -   I buffer                          array: BUF(LBF)
C        I      I     I it is equivalent to (RBUF,IBUF) !
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C NCARD  I  I   I i/o I card counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           GEOTYP,I,G,NE,ADRVP,NRVP,RVP1,TOKEN(1),
     &                  ADDGEO,NE0,ID0,FORCE0,
     &                  Z,MYTID,COMP0,P,MIDS,MIDR,INFO
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy elements into buffer :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
      NE0=0
      ID0=NE0+NGROUP
      FORCE0=0
      DO 200 G=1,NGROUP
	NE    =GINFO(1,G)
	GEOTYP=GINFO(2,G)
        ADDGEO=GINFO(5,G)
        ADRVP =GINFO(10,G)
        RVP1  =GINFO(11,G)
        NRVP  =GINFO(12,G)
	IF (GEOTYP.EQ.1) THEN
	  COMP0=ID0+NE
	  DO 250 Z=1,NE
	    IF (DIS.EQ.220964) THEN
	      IBUF(ID0+Z)=NODNUM(NEK(ADDGEO-1+Z))
            ELSE
	      IBUF(ID0+Z)=NEK(ADDGEO-1+Z)
            ENDIF
	    DO 251 I=1,MIN(NRVP,6)
              RBUF(FORCE0+6*(Z-1)+I)=RPARM(ADRVP-1+RVP1*(I-1)+Z)
 251          IBUF(COMP0+6*(Z-1)+I)=1
	    DO 252 I=MIN(NRVP,6)+1,6
              RBUF(FORCE0+6*(Z-1)+I)=0.
 252          IBUF(COMP0+6*(Z-1)+I)=0
 250      CONTINUE
          IBUF(NE0+G)=NE
          FORCE0=FORCE0+6*NE
          ID0   =COMP0+NE*6
        ELSE
          IBUF(NE0+G)=0
        ENDIF
 200  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write node forces (packet type 7):                            ***
C**   ---------------------------------                             ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        DO 400 P=1,NPROC
	  IF (TIDS(P).NE.IOTID) THEN
	    CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+NPROC,IINT*LBF,BUF,MIDR,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+NPROC,IINT*LBF,BUF,MIDR,INFO)
          ENDIF
	  NE0=0
	  ID0=NE0+NGROUP
          FORCE0=0
	  DO 300 G=1,NGROUP
	    NE=IBUF(NE0+G)
	    IF (NE.GT.0) THEN
	      COMP0=ID0+NE
	      DO 350 Z=1,NE
                WRITE(UNIOUT,'(I2,8I8)') 7,IBUF(ID0+Z),1,3,(0,I=1,5)
                WRITE(UNIOUT,'(I8,6I1)') 
     &                               0,(IBUF(COMP0+6*(Z-1)+I),I=1,6)
                WRITE(UNIOUT,'(5E16.9)') (RBUF(FORCE0+6*(Z-1)+I),I=1,6)
		NCARD=NCARD+4
 350          CONTINUE
 	      ID0=COMP0+NE*6
	      FORCE0=FORCE0+NE*6
            ENDIF
 300      CONTINUE
400     CONTINUE
      ELSE
        CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,BUF,MIDS,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,BUF,MIDS,INFO)
      ENDIF
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEPA04----------------------------------------------------
      E    N    D
