C:::::      ,,,,,VEPA97...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEPA97(TEXT1,TEXT2,T,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                  NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEPA97   write PATRAN nodal result file                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include"bytes.h"
      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,
     &                  LDNOD,LRDPRM,LIDPRM,LNOD,LNOPRM,LU,LNODN,LBIG

      DOUBLE PRECISION  T,RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),U(LU),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  DNOD(LDNOD),IDPARM(LIDPRM),IBIG(LBIG*RPI)

      CHARACTER*80      TEXT1,TEXT2
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  TIME,VEMSCD,LIMIT,ZERO,H(3),DEFMAX
      INTEGER           MESH,ERR,LOUT,NDEG,N,NU,I,Z,TOTID,FRTID,
     &                  DATOUT,OUTCNT,TID,NCARD,FTYPE,MYDEG,DEGMAX,
     &                  NPROC,MYPROC,IOTID,MYTID,U1,LBF,NDV,
     &                  NMAX,NMIN,NDEGL,NDEG0L,NUBUF,LCOUNT,NBIG,UBUF,
     &                  LL9MAP,P,MIDR,MIDS,INFO,J,NH,TIDS,NMSG,
     &                  TOKEN(1),TOTDEG,LLNGTH(16),NLNGTH(16),
     &                  SWPBUF,RCVBUF,SNDBUF,MPINFO,SBT

      CHARACTER*80      TEXT3
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      TEXT3='computed by VECFEM 3'
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=LU
      TIME=VEMSCD()
      ZERO=0
      MESH   = IVEM(1)
      NDEG   = IVEM(MESH+1)
      LOUT   = IVEM(120)
      OUTCNT = IVEM(121)
      DATOUT = IVEM(127)
      FTYPE  = IVEM(130)
      IF (FTYPE.EQ.0) THEN
	NDV=MAX(IVEM(129),0)
      ELSEIF (FTYPE.EQ.1) THEN
	NDV=1
      ELSEIF (FTYPE.EQ.2) THEN
	NDV=3
      ELSE
	NDV=9
      ENDIF
      U1=MAX(IVEM(128),0)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      LIMIT=10.D0**IVEM(4)
      N=MIN(MAX(IVEM(129),0),NDV)
      NU=N*U1
      IF (LOUT.LT.0) LOUT=6
      IF (DATOUT.LE.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title:                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('VEPA97',OUTCNT,LOUT)
	WRITE (LOUT,9300) 127,DATOUT
	WRITE (LOUT,9330) 128,U1
	WRITE (LOUT,9320) 129,N
        WRITE(LOUT,9350) 130,FTYPE
        GOTO (5,1,2,4) (FTYPE+1)
           GOTO 997
 5         WRITE(LOUT,9404)
           GOTO 997
 1         WRITE(LOUT,9400)
           GOTO 997
 2         WRITE(LOUT,9401)
           GOTO 997
 4         WRITE(LOUT,9403)
 997    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check the input data :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,0,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF ((MYTID.EQ.IOTID).AND.((FTYPE.LT.0).OR.(FTYPE.GT.3))) THEN
        ERR=99
        WRITE (LOUT,9120) FTYPE
      ENDIF
      IF (U1.LT.NDEG) THEN
	ERR=99
        WRITE (LOUT,9101) MYPROC,MYTID,U1
      ENDIF
      NLNGTH(16)=NU
      CALL VEM098('VEPA97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create buffers:                                               ***
C**   --------------                                                ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMAX,I,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMIN,I,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-NMIN
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,NUBUF,MYPROC,NPROC)

      LCOUNT=3
      UBUF=(LCOUNT+N*NUBUF-1+RPI-1)/RPI+1
      LBF=UBUF+N*NUBUF
      NBIG=SBT*LBF

      NLNGTH(4)=NBIG
      CALL VEM098('VEPA97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** distribution of solution into send around buffer :            ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      TOTID=IVEM(TIDS-1+LL9MAP(MYPROC+1,NPROC))
      FRTID=IVEM(TIDS-1+LL9MAP(MYPROC-1,NPROC))
      RCVBUF=0
      SNDBUF=RCVBUF+(SBT-1)*LBF
	
      IBIG(1+SNDBUF*RPI)=NDEGL
      IBIG(2+SNDBUF*RPI)=NDEG0L
      DO 100 P=1,NPROC
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,IVEM(NMSG)+P,IINT*2,IBIG(RCVBUF*RPI+1),
     &                                                      MIDR,INFO)
	    CALL MPSNDA(TOTID,IVEM(NMSG)+P,IINT*2,IBIG(SNDBUF*RPI+1),
     &                                                      MIDS,INFO)
          ENDIF
	  DO 101 Z=1,N*NUBUF
	    IBIG(LCOUNT+Z-1+RCVBUF*RPI)=0
	    RBIG(UBUF+Z-1+RCVBUF)=0
101       CONTINUE
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,IVEM(NMSG)+P,IINT*2,IBIG(RCVBUF*RPI+1),
     &                                                      MIDR,INFO)
	    CALL MPSNDW(TOTID,IVEM(NMSG)+P,IINT*2,IBIG(SNDBUF*RPI+1),
     &                                                      MIDS,INFO)
          ENDIF
	ELSE
	  CALL MPRCVA(FRTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(RCVBUF+1),
     &                                                     MIDR,INFO)
	  CALL MPSNDA(TOTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(SNDBUF+1),
     &                                                     MIDS,INFO)
	  CALL MPRCVW(FRTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(RCVBUF+1),
     &                                                     MIDR,INFO)
	  CALL MPSNDW(TOTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(SNDBUF+1),
     &                                                     MIDS,INFO)
        ENDIF
        NDEGL=IBIG(1+RCVBUF*RPI)
        NDEG0L=IBIG(2+RCVBUF*RPI)
	DO 130 J=1,N
	  DO 130 Z=1,NDEG
	    NH=NODNUM(Z)-NDEG0L
	    IF ((NH.GT.0).AND.(NH.LE.NDEGL).AND.
     &                                   (U(Z+U1*(J-1)).LT.LIMIT)) THEN
	      IBIG(LCOUNT-1+NH+NUBUF*(J-1)+RCVBUF*RPI)=
     &                      IBIG(LCOUNT-1+NH+NUBUF*(J-1)+RCVBUF*RPI)+1
	      RBIG(UBUF-1+NH+NUBUF*(J-1)+RCVBUF)=
     &                 RBIG(UBUF-1+NH+NUBUF*(J-1)+RCVBUF)+U(Z+U1*(J-1))
            ENDIF
130      CONTINUE
         SWPBUF=RCVBUF
         RCVBUF=SNDBUF
         SNDBUF=SWPBUF
100    CONTINUE
       IVEM(NMSG)=IVEM(NMSG)+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** count the entries:                                            ***
C**   -----------------                                             ***
C**                                                                 ***
      DO 241 J=1,N
         DO 241 Z=1,NDEGL
          IF (IBIG(LCOUNT-1+Z+NUBUF*(J-1)+SNDBUF*RPI).GT.0) THEN
            RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF*RPI)=
     &           RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF*RPI)/
     &           DBLE(IBIG(LCOUNT-1+Z+NUBUF*(J-1)+SNDBUF*RPI))
          ENDIF
241   CONTINUE

      DO 240 J=2,N
        DO 240 Z=1,NDEGL
         IBIG(LCOUNT-1+Z+RPI*SNDBUF)=IBIG(LCOUNT-1+Z+RPI*SNDBUF)+
     &                         IBIG(LCOUNT-1+Z+NUBUF*(J-1)+RPI*SNDBUF)
240   CONTINUE
      MYDEG=0
      DO 245 Z=1,NDEGL
         IF (IBIG(LCOUNT-1+Z+RPI*SNDBUF).EQ.N) MYDEG=MYDEG+1
245   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** find the node of maximal real value :                         ***
C**   -----------------------------------                           ***
C**                                                                 ***
      DEFMAX=-1
      DO 242 J=1,N
        DO 242 Z=1,NDEGL
          IF ((IBIG(LCOUNT-1+Z+RPI*SNDBUF).EQ.N).AND.
     &        (ABS(RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF)).GT.DEFMAX)) THEN
            DEFMAX=ABS(RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF))
            DEGMAX=Z
        ENDIF
242   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** find total id number of written nodes and defmax :            ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      H(1)=DBLE(MYDEG)
      H(2)=DBLE(DEGMAX)
      H(3)=DEFMAX
      IF ((MYPROC.EQ.NPROC).AND.(NPROC.GT.1)) THEN
         TID=IVEM(TIDS-1+NPROC-1)
	 CALL MPSNDA(TID,IVEM(NMSG)+1,3*IREAL,H,MIDS,INFO)
	 CALL MPSNDW(TID,IVEM(NMSG)+1,3*IREAL,H,MIDS,INFO)
      ENDIF
      IF ((MYPROC.LT.NPROC).AND.(MYPROC.GT.1)) THEN
         TID=IVEM(TIDS+MYPROC)
	 CALL MPRCVA(TID,IVEM(NMSG)+1,3*IREAL,H,MIDR,INFO)
	 CALL MPRCVW(TID,IVEM(NMSG)+1,3*IREAL,H,MIDR,INFO)
	 H(1)=H(1)+DBLE(MYDEG)
         IF (DEFMAX.GT.H(3)) THEN
	    H(2)=DBLE(DEGMAX)
	    H(3)=DEFMAX
         ENDIF
         TID=IVEM(TIDS+MYPROC-2)
	 CALL MPSNDA(TID,IVEM(NMSG)+1,3*IREAL,H,MIDS,INFO)
	 CALL MPSNDW(TID,IVEM(NMSG)+1,3*IREAL,H,MIDS,INFO)
      ENDIF
      IF ((MYPROC.EQ.1).AND.(NPROC.GT.1)) THEN
         TID=IVEM(TIDS+1)
	 CALL MPRCVA(TID,IVEM(NMSG)+1,3*IREAL,H,MIDR,INFO)
	 CALL MPRCVW(TID,IVEM(NMSG)+1,3*IREAL,H,MIDR,INFO)
	 H(1)=H(1)+DBLE(MYDEG)
         IF (DEFMAX.GT.H(3)) THEN
	    H(2)=DBLE(DEGMAX)
	    H(3)=DEFMAX
         ENDIF
      ENDIF
      TOTDEG=INT(H(1))+INT(H(1)-INT(H(1))+.5)
      DEGMAX=INT(H(1))+INT(H(2)-INT(H(2))+.5)
      DEFMAX=H(3)
      IVEM(NMSG)=IVEM(NMSG)+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write header of neutral file:                                 ***
C**   ----------------------------                                  ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN

         WRITE(DATOUT,'(A80)') TEXT1
         WRITE(DATOUT,'(2I9,E15.6,2I9)')
     &               TOTDEG,NMAX,DEFMAX,DEGMAX,NDV
         WRITE(DATOUT,'(A80)') TEXT2
         WRITE(DATOUT,'(A80)') TEXT3
	 NCARD=4
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** write results:                                              ***
C**     -------------                                               ***
C**                                                                 ***
        DO 400 P=1,NPROC
          TID=IVEM(TIDS-1+P)
	  IF (TID.NE.IOTID) THEN
	    CALL MPSNDA(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TID,IVEM(NMSG)+P+NPROC,IREAL*LBF,
     &                                      RBIG(SNDBUF+1),MIDR,INFO)
	    CALL MPRCVW(TID,IVEM(NMSG)+P+NPROC,IREAL*LBF,
     &                                      RBIG(SNDBUF+1),MIDR,INFO)
          ENDIF
          NDEGL=IBIG(1+SNDBUF*RPI)
          NDEG0L=IBIG(2+SNDBUF*RPI)
          DO 300 Z=1,NDEGL
             IF (IBIG(LCOUNT-1+Z+RPI*SNDBUF).GE.N) THEN
	       NCARD=NCARD+1
               WRITE(DATOUT,'(I8,9(E13.7))') Z+NDEG0L,
     &              (RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF),J=1,N),
     &              (ZERO,J=N+1,NDV)
            ENDIF
 300      CONTINUE
400     CONTINUE
        IF (OUTCNT.GT.0) WRITE(LOUT,9380) TOTDEG
        IF (OUTCNT.GT.0) WRITE(LOUT,9381) NCARD
      ELSE
        CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC,IREAL*LBF,
     &                                       RBIG(SNDBUF+1),MIDS,INFO)
        CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC,IREAL*LBF,
     &                                       RBIG(SNDBUF+1),MIDS,INFO)
      ENDIF
      IVEM(NMSG)=IVEM(NMSG)+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEPA97',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9300  FORMAT('     unit of PATRAN nodal result file ............ =',
     &                                          ' IVEM(',I4,') = ',I10)
9310  FORMAT('     load case number ............................ =',
     &                                          ' IVEM(',I4,') = ',I10)
9320  FORMAT('     number of components ...................... N =',
     &                                          ' IVEM(',I4,') = ',I10)
9330  FORMAT('     leading dimension of result array ........ U1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9350  FORMAT('     file format ........................... FTYPE =',
     &                                          ' IVEM(',I4,') = ',I10)
9404  FORMAT('        > unknown')
9400  FORMAT('        > scalar')
9401  FORMAT('        > vector')
9403  FORMAT('        > general matrix')
9380  FORMAT('     written nodal results ..................... = ',I10)
9381  FORMAT('     written cards ............................. = ',I10)
4050  FORMAT('     written nodes ............................. = ',I10)
9101  FORMAT('>>VEMCD:02:9998'/
     &       '>>VEPA97 error on process ',I10,' (TID=',I10,')'/
     &       '>>U1 = ',I10,' is defective!')
9120  FORMAT('>>VEMCD:02:0401'/'>>unknown file format FTYPE = ',I10)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEPA97----------------------------------------------------
      E    N    D
