C:::::      ,,,,,VEPA99...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEPA99(TEXT1,TEXT2,T,LCU,CU,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                  NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEPA99   write PATRAN element result file                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include"bytes.h"
      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,
     &                  LDNOD,LRDPRM,LIDPRM,LNOD,LNOPRM,LCU,LNODN,LBIG

      DOUBLE PRECISION  T,RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),CU(LCU),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  DNOD(LDNOD),IDPARM(LIDPRM),IBIG(LBIG*RPI)

      CHARACTER*80      TEXT1,TEXT2
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  TIME,VEMSCD,ZERO
      INTEGER           MESH,ERR,LOUT,CU2,NCU,I,NCARD,TOKEN(1),
     &                  DATOUT,OUTCNT,COUNT,FTYPE,TID,GEOTYP,CLASS,
     &                  NPROC,MYPROC,IOTID,MYTID,CU1,LBF,G,
     &                  NUMBER,NBIG,CUBUF,IH1(3),IH2(3),IH3(3),WIDTH,
     &                  P,MIDR,MIDS,INFO,J,NGROUP,GINFO,GINFO1,NMSG,
     &                  NCUBUF,TOTNE,NIVP,IND0,ADIVP,NE,ADDCU,
     &                  TIDS,ELID,FORM,LLNGTH(16),NLNGTH(16)

      CHARACTER*80      TEXT3
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :
C**   ---------------------                                         ***
C**                                                                 ***
      TEXT3='computed by VECFEM 3'
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=LCU
      LLNGTH(16)=0
      TIME=VEMSCD()
      ZERO=0
      MESH   = IVEM(1)
      NGROUP = IVEM(MESH+4)
      GINFO  = IVEM(MESH+21)+MESH
      GINFO1 = IVEM(MESH+22)
      LOUT   = IVEM(120)
      OUTCNT = IVEM(121)
      DATOUT = IVEM(133)
      FTYPE  = IVEM(134)
      IF (FTYPE.EQ.0) THEN
	WIDTH=0
      ELSEIF (FTYPE.EQ.1) THEN
	WIDTH=1
      ELSEIF (FTYPE.EQ.2) THEN
	WIDTH=3
      ELSE
	WIDTH=9
      ENDIF
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      IF (LOUT.LT.0) LOUT=6
      IF (DATOUT.LE.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title:                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
	CALL VEM000('VEPA99',OUTCNT,LOUT)
	WRITE (LOUT,9300) 133,DATOUT
        WRITE(LOUT,9350) 130,FTYPE
        GOTO (5,1,2,4) (FTYPE+1)
           GOTO 997
 5         WRITE(LOUT,9404)
           GOTO 997
 1         WRITE(LOUT,9400)
           GOTO 997
 2         WRITE(LOUT,9401)
           GOTO 997
 4         WRITE(LOUT,9403)
 997    CONTINUE
      ENDIF
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,0,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF ((MYTID.EQ.IOTID).AND.((FTYPE.LT.0).OR.(FTYPE.GT.3))) THEN
        ERR=99
        WRITE (LOUT,9120) FTYPE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check element groups and compute buffer lengths:              ***
C**   -----------------------------------------------               ***
C**                                                                 ***
      NCU=0
      NCUBUF=0
      TOTNE=0
      IF (FTYPE.EQ.0) THEN
        DO 211 G=1,NGROUP
           NIVP   = IVEM(GINFO+GINFO1*(G-1)+16)
           CU2    = IVEM(GINFO+GINFO1*(G-1)+19)
           IF ((CU2.GT.0).AND.(NIVP.GT.0)) WIDTH=MAX(CU2,WIDTH)
211     CONTINUE
      ENDIF
      DO 200 G=1,NGROUP
         NE     = IVEM(GINFO+GINFO1*(G-1)   )
         NIVP   = IVEM(GINFO+GINFO1*(G-1)+16)
         ADDCU  = IVEM(GINFO+GINFO1*(G-1)+17)
         CU1    = IVEM(GINFO+GINFO1*(G-1)+18)
         CU2    = IVEM(GINFO+GINFO1*(G-1)+19)
         IF ((CU2.GT.0).AND.(NIVP.GT.0)) THEN
           TOTNE=TOTNE+NE
           NCUBUF=NCUBUF+MIN(CU2,WIDTH)*NE
           NCU =MAX(NCU,ADDCU-1+CU1*CU2)
           IF (CU1.LT.NE) THEN
              ERR=99
              WRITE (LOUT,9000) MYPROC,MYTID,G,CU1
           ENDIF
         ENDIF
200   CONTINUE

      NLNGTH(15)=NCU
      CALL VEM098('VEPA99',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (OUTCNT.NE.0) WRITE(LOUT,9390) WIDTH
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create buffer:                                                ***
C**   -------------                                                 ***
C**                                                                 ***
      NUMBER=(1+2*NGROUP)+1
      CUBUF=(NUMBER+TOTNE-1+RPI-1)/RPI
      LBF=CUBUF+NCUBUF

      IH1(1)=LBF
      CALL LL4INM(1,1,1,IH1,IH2,IH3,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      LBF=IH2(1)
      NBIG=LBF
      NLNGTH(4)=NBIG
      CALL VEM098('VEPA99',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** results are copied into the buffer:                           ***
C**   ----------------------------------                            ***
C**                                                                 ***
      IND0=NUMBER-1
      CUBUF=(NUMBER+TOTNE-1+RPI-1)/RPI

      IBIG(1)=TOTNE
      DO 300 G=1,NGROUP
        NE     = IVEM(GINFO+GINFO1*(G-1)   )
        ADIVP  = IVEM(GINFO+GINFO1*(G-1)+14)
        NIVP   = IVEM(GINFO+GINFO1*(G-1)+16)
        ADDCU  = IVEM(GINFO+GINFO1*(G-1)+17)
        CU1    = IVEM(GINFO+GINFO1*(G-1)+18)
        CU2    = MIN(IVEM(GINFO+GINFO1*(G-1)+19),WIDTH)
        IF ((CU2.GT.0).AND.(NIVP.GT.0)) THEN
	  IBIG(1+NGROUP*(1-1)+G)=NE
          IBIG(1+NGROUP*(2-1)+G)=CU2
          DO 310 I=1,NE
  310       IBIG(IND0+I)=IPARM(ADIVP-1+I)
          DO 320 J=1,CU2
            DO 320 I=1,NE
              RBIG(CUBUF+I+(J-1)*NE)=CU(ADDCU-1+I+(J-1)*CU1)
  320     CONTINUE
	  IND0=IND0+NE
	  CUBUF=CUBUF+NE*CU2
        ELSE
	  IBIG(1+NGROUP*(1-1)+G)=0
	  IBIG(1+NGROUP*(2-1)+G)=0
        ENDIF
  300 CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write header:                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        WRITE(DATOUT,'(80A1)') TEXT1
        WRITE(DATOUT,'(I5)') WIDTH
        WRITE(DATOUT,'(80A1)') TEXT2
        WRITE(DATOUT,'(80A1)') TEXT3
	NCARD=4
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write results:                                                ***
C**   -------------                                                 ***
C**                                                                 ***
1112   COUNT=0
       DO 400 P=1,NPROC
          TID=IVEM(TIDS-1+P)
	  IF (TID.NE.IOTID) THEN
	    CALL MPSNDA(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TID,IVEM(NMSG)+NPROC+P,IREAL*LBF,RBIG,MIDR,INFO)
	    CALL MPRCVW(TID,IVEM(NMSG)+NPROC+P,IREAL*LBF,RBIG,MIDR,INFO)
          ENDIF
	  TOTNE=IBIG(1)
          IND0=NUMBER-1
          CUBUF=(NUMBER+TOTNE-1+RPI-1)/RPI
          DO 410 G=1,NGROUP
	    NE=IBIG(1+NGROUP*(1-1)+G)
            CLASS=IVEM(GINFO+GINFO1*(G-1)+3 )
            GEOTYP=IVEM(GINFO+GINFO1*(G-1)+1 )
            FORM=IVEM(GINFO+GINFO1*(G-1)+2 )
            CU2=IBIG(1+NGROUP*(2-1)+G)
	    CALL VEPA10(CLASS,FORM,GEOTYP,ELID)
	    IF (ELID.GT.0) THEN
              DO 420 I=1,NE
 	        COUNT=COUNT+1
 	        NCARD=NCARD+2
                WRITE(DATOUT,3456) IBIG(IND0+I),ELID,
     &           (RBIG(CUBUF+I+(J-1)*NE),J=1,CU2),(ZERO,J=CU2+1,WIDTH)
  420         CONTINUE
	    ENDIF
	    IND0=IND0+NE
            CUBUF=CUBUF+NE*CU2
  410     CONTINUE
400     CONTINUE
        IF (OUTCNT.NE.0) WRITE(LOUT,9380) COUNT
        IF (OUTCNT.NE.0) WRITE(LOUT,9381) NCARD+1
      ELSE
        CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPSNDA(IOTID,IVEM(NMSG)+NPROC+MYPROC,IREAL*LBF,RBIG,
     &                                                    MIDS,INFO)
	CALL MPSNDW(IOTID,IVEM(NMSG)+NPROC+MYPROC,IREAL*LBF,RBIG,
     &                                                    MIDS,INFO)
      ENDIF
      IVEM(NMSG)=IVEM(NMSG)+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEPA99',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9000  FORMAT('>>VEMCD:02:9998'
     &      /'>>VEID99 error on process ',I10,' (TID=',I10,')'
     &      /'>>In group ',I3,' CU1 = ',I10,' is defective!')
9120  FORMAT('>>VEMCD:02:0401'/'>>unknown file format FTYPE = ',I10)
9300  FORMAT('    unit of PATRAN element result file .......... =',
     &                                        ' IVEM(',I4,') = ',I10)
9310  FORMAT('    load case number ............................ =',
     &                                        ' IVEM(',I4,') = ',I10)
9350  FORMAT('    file format ........................... FTYPE =',
     &                                        ' IVEM(',I4,') = ',I10)
9390  FORMAT('    table width ........................ WIDTH = ',I10)
9380  FORMAT('    written elements ........................ = ',I10)
9381  FORMAT('    written cards ........................... = ',I10)
9404  FORMAT('       > unknown')
9400  FORMAT('       > scalar')
9401  FORMAT('       > vector')
9403  FORMAT('       > general matrix')
3456  FORMAT (2I8/(6E13.7))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calulcation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEPA99----------------------------------------------------
      E    N    D
