C**:::      ,,,,,VERLPZ.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VERLPZ(ERRTYP,NELTYP,CLASS,FORM,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VERLPZ  sets the number of nodes in the proposal function    ***
C**            pieces for the piecewise lagrangean proposal         ***
C**            functions.                                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,FORM,NELTYP,ERRTYP,ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C ERRTYP I  I   I out I number nodes in the proposal function piece
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number nodes of the proposal function
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimenson of the element   
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of the element
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10002   illegal NELTYP
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER          HELP,NELT,P
      INTEGER          VEMLPZ
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
      ERR=10000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN
        ERR=10002
        IF( NELTYP .EQ. 1 ) ERR=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        IF (NELTYP.LE.1) THEN
          ERR=10002
          RETURN
        ENDIF
        P=NELTYP/2
        IF (NELTYP.EQ.2) P=0
        ERRTYP=VEMLPZ(P,CLASS,FORM,ERR)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN
        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle :                                                  ***
C**     --------                                                    ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=10002
          NELT=(-1.D0+SQRT(8.D0*DBLE(NELTYP)+1.D0))/2+.5D0
          HELP=((NELT+1)*NELT)/2
          IF (NELTYP.NE.HELP) RETURN
          P=NELT/2
          IF (NELT.EQ.2) P=0
          ERRTYP=VEMLPZ(P,CLASS,FORM,ERR)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** quadrilateral :                                             ***
C**     ---------------                                             ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          NELT=SQRT(DBLE(NELTYP))+.5D0
          HELP=NELT**2
          IF (NELTYP.NE.HELP) RETURN
          P=NELT/2
          IF (NELT.EQ.2) P=0
          ERRTYP=VEMLPZ(P,CLASS,FORM,ERR)
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN
        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** tetrahedron :                                               ***
C**     -------------                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          NELT=0
1234      NELT=NELT+1
          HELP=(NELT**3+3*NELT**2+2*NELT)/6
          IF (HELP.LT.NELTYP) GOTO 1234
          IF (HELP.NE.NELTYP) RETURN
          P=NELT/2
          IF (NELT.EQ.2) P=0
          ERRTYP=VEMLPZ(P,CLASS,FORM,ERR)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism:                                                      ***
C**     ------                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=10002
          NELT=0
1235      NELT=NELT+1
          HELP=(NELT**3+NELT**2)/2
          IF (HELP.LT.NELTYP) GOTO 1235
          IF (HELP.NE.NELTYP) RETURN
          P=NELT/2
          IF (NELT.EQ.2) P=0
          ERRTYP=VEMLPZ(P,CLASS,FORM,ERR)
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          ERR=10002
          NELT=DBLE(NELTYP)**(1.D0/3.D0)+.5D0
          HELP=NELT**3
          IF (HELP.NE.NELTYP) RETURN
          P=NELT/2
          IF (NELT.EQ.2) P=0
          ERRTYP=VEMLPZ(P,CLASS,FORM,ERR)
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VERLPZ ---------------------------------------------------
      E    N    D
