C**:::      ,,,,,VERPR0.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VERPR0(CLASS,FORM,NELTYP,NV,LRWORK,LIWORK,
     &                  VEMXX0,VEMPX0,VERXXZ,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VERPR0  calculates the storage for the setting of the         ***
C**           piecewise shape/lagrangean proposal functions         ***
C**           (VERPRF)                                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,FORM,NELTYP,NV,LRWORK,LIWORK,ERR
      EXTERNAL          VEMXX0,VEMPX0,VERXXZ
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of the element
C--------I------I-----I------------------------------------------------
C NV     I  I   I in  I number of nodes the piecewise proposal
C        I      I     I functions have to be evaluated
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of proposal function
C--------I------I-----I------------------------------------------------
C LRWORK I  I   I out I required real work space
C--------I------I-----I------------------------------------------------
C LIWORK I  I   I out I requierd integer work space
C--------I------I-----I------------------------------------------------
C VEMXX0 I  EX  I in  I routine which specify the storage for the 
C        I      I     I setting of the proposal functions on the
C        I      I     I reference element
C--------I------I-----I------------------------------------------------
C VEMPX0 I  EX  I in  I routine which specify the storage for 
C        I      I     I setting the nodes of proposal function pieces
C        I      I     I on the reference element
C--------I------I-----I------------------------------------------------
C VERXXZ I  EX  I in  I routine which defines the number of nodes
C        I      I     I for proposal functions pieces
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10002   illegal NELTYP
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NP,IW1,IW2,RW1,RW2,ERRTYP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      NP=2**CLASS
      CALL VERXXZ(ERRTYP,NELTYP,CLASS,FORM,ERR)
      IF (ERR.GT.0) RETURN

      LIWORK=0
      LRWORK=CLASS*ERRTYP+NP*(CLASS+CLASS*CLASS)
     &      +ERRTYP*NV+CLASS*ERRTYP*NV+CLASS*ERRTYP*NP
     &      +NELTYP*ERRTYP*NP+CLASS*NELTYP*ERRTYP*NP
      RW1=0
      IW1=0

      CALL VEMPX0(CLASS,FORM,ERRTYP,RW2,IW2,ERR)
      IF (ERR.GT.0) RETURN
      IW1=MAX(IW1,IW2)
      RW1=MAX(RW1,RW2)

      CALL VEMXX0(CLASS,FORM,NELTYP,RW2,IW2,ERR)
      IF (ERR.GT.0) RETURN
      IW1=MAX(IW1,IW2)
      RW1=MAX(RW1,RW2)

      CALL VEMXX0(CLASS,FORM,ERRTYP,RW2,IW2,ERR)
      IF (ERR.GT.0) RETURN
      IW1=MAX(IW1,IW2)
      RW1=MAX(RW1,RW2)

      LIWORK=LIWORK+IW1
      LRWORK=LRWORK+RW1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VERPR0 ---------------------------------------------------
      E    N    D
