C**:::      ,,,,,VERPR1.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VERPR1(CLASS,FORM,NP,ROT,V0,NN,NODEL,NODE,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VERPR1  set the transformation X -> V0 + ROT * X              ***
C**           from the reference elmenent onto its                  ***
C**           partitioning with half edge length                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,FORM,NP,NN,ERR
      DOUBLE PRECISION  V0(CLASS,NP),ROT(CLASS,CLASS,NP),
     &                  NODEL(CLASS,NN),NODE(CLASS,NN,NP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of element
C--------I------I-----I------------------------------------------------
C NP     I  I   I in  I =2**CLASS - number of partitionings
C--------I------I-----I------------------------------------------------
C V0     I  R   I out I translation vector          array: V0(CLASS,NP)
C--------I------I-----I------------------------------------------------
C ROT    I  R   I out I rotation matrix      array: ROT(CLASS,CLASS,NP)
C--------I------I-----I------------------------------------------------
C NODEL  I  R   I in  I points in the reference element
C        I      I     I                          array: NODEL(CLASS,NN)
C--------I------I-----I------------------------------------------------
C NODE   I  R   I out I corresponding points in the reference element
C        I      I     I pieces               array: NODExL(CLASS,NN,NP)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I ERROR NUMBER
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER             I,J,K,L
      DOUBLE PRECISION    HALF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=10000
      HALF=.5D0
      IF (NP.NE.2**CLASS) RETURN

      DO 10 K=1,NP
        DO 10 I=1,CLASS
          V0(I,K)=0
          DO 20 J=1,CLASS
 20         ROT(I,J,K)=0
10    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN
        ERR=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        ERR=0
        ROT(1,1,1)=HALF

        V0(1,2)=HALF
        ROT(1,1,2)=HALF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN
        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle :                                                  ***
C**     --------                                                    ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=0
          ROT(1,1,1)=HALF
          ROT(2,2,1)=HALF

          V0(2,2)=HALF
          ROT(1,1,2)=HALF
          ROT(2,2,2)=HALF

          V0(1,3)=HALF
          ROT(1,1,3)=HALF
          ROT(2,2,3)=HALF

          V0(1,4)=HALF
          V0(2,4)=HALF
          ROT(1,1,4)=-HALF
          ROT(2,2,4)=-HALF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** quadrilateral :                                             ***
C**     ---------------                                             ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=0
          ROT(1,1,1)=HALF
          ROT(2,2,1)=HALF

          V0(2,2)=HALF
          ROT(1,1,2)=HALF
          ROT(2,2,2)=HALF

          V0(1,3)=HALF
          ROT(1,1,3)=HALF
          ROT(2,2,3)=HALF

          V0(1,4)=HALF
          V0(2,4)=HALF
          ROT(1,1,4)=HALF
          ROT(2,2,4)=HALF
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN
        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** tetrahedron :                                               ***
C**     -------------                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=0
          ROT(1,1,1)=HALF
          ROT(2,2,1)=HALF
          ROT(3,3,1)=HALF

          V0(2,2)=HALF
          ROT(1,1,2)=HALF
          ROT(2,2,2)=HALF
          ROT(3,3,2)=HALF

          V0(3,3)=HALF
          ROT(1,1,3)=HALF
          ROT(2,2,3)=HALF
          ROT(3,3,3)=HALF

          V0(1,4)=HALF
          ROT(1,1,4)=HALF
          ROT(2,2,4)=HALF
          ROT(3,3,4)=HALF

          V0(1,5)=HALF
          ROT(1,2,5)=-HALF
          ROT(2,1,5)=HALF
          ROT(2,2,5)=HALF
          ROT(3,3,5)=HALF

          V0(1,6)=HALF
          V0(2,6)=HALF
          ROT(1,1,6)=-HALF
          ROT(1,3,6)=-HALF
          ROT(2,2,6)=-HALF
          ROT(3,1,6)=HALF
          ROT(3,2,6)=HALF

          V0(2,7)=HALF
          V0(3,7)=HALF
          ROT(1,3,7)=HALF
          ROT(2,1,7)=-HALF
          ROT(2,3,7)=-HALF
          ROT(3,2,7)=-HALF

          V0(3,8)=HALF
          ROT(1,1,8)= HALF
          ROT(1,3,8)= HALF
          ROT(2,2,8)= HALF
          ROT(3,1,8)=-HALF
          ROT(3,2,8)=-HALF

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism:                                                      ***
C**     ------                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=0
          ROT(1,1,1)=HALF
          ROT(2,2,1)=HALF
          ROT(3,3,1)=HALF

          V0(2,2)=HALF
          ROT(1,1,2)=HALF
          ROT(2,2,2)=HALF
          ROT(3,3,2)=HALF

          V0(3,3)=HALF
          ROT(1,1,3)=HALF
          ROT(2,2,3)=HALF
          ROT(3,3,3)=HALF

          V0(1,4)=HALF
          ROT(1,1,4)=HALF
          ROT(2,2,4)=HALF
          ROT(3,3,4)=HALF

          V0(1,5)=HALF
          V0(3,5)=HALF
          ROT(1,1,5)=HALF
          ROT(2,2,5)=HALF
          ROT(3,3,5)=HALF

          V0(2,6)=HALF
          V0(3,6)=HALF
          ROT(1,1,6)=HALF
          ROT(2,2,6)=HALF
          ROT(3,3,6)=HALF

          V0(1,7)=HALF
          V0(2,7)=HALF
          ROT(1,1,7)=-HALF
          ROT(2,2,7)=-HALF
          ROT(3,3,7)=HALF

          V0(1,8)=HALF
          V0(2,8)=HALF
          V0(3,8)=HALF
          ROT(1,1,8)=-HALF
          ROT(2,2,8)=-HALF
          ROT(3,3,8)=HALF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          ERR=0
          ROT(1,1,1)=HALF
          ROT(2,2,1)=HALF
          ROT(3,3,1)=HALF

          V0(2,2)=HALF
          ROT(1,1,2)=HALF
          ROT(2,2,2)=HALF
          ROT(3,3,2)=HALF

          V0(3,3)=HALF
          ROT(1,1,3)=HALF
          ROT(2,2,3)=HALF
          ROT(3,3,3)=HALF

          V0(1,4)=HALF
          ROT(1,1,4)=HALF
          ROT(2,2,4)=HALF
          ROT(3,3,4)=HALF

          V0(1,5)=HALF
          V0(3,5)=HALF
          ROT(1,1,5)=HALF
          ROT(2,2,5)=HALF
          ROT(3,3,5)=HALF

          V0(2,6)=HALF
          V0(3,6)=HALF
          ROT(1,1,6)=HALF
          ROT(2,2,6)=HALF
          ROT(3,3,6)=HALF

          V0(1,7)=HALF
          V0(2,7)=HALF
          ROT(1,1,7)=HALF
          ROT(2,2,7)=HALF
          ROT(3,3,7)=HALF

          V0(1,8)=HALF
          V0(2,8)=HALF
          V0(3,8)=HALF
          ROT(1,1,8)=HALF
          ROT(2,2,8)=HALF
          ROT(3,3,8)=HALF
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** and now the transformation is executed:                       ***
C**   --------------------------------------                        ***
C**                                                                 ***
      DO 100 I=1,CLASS
        DO 100 K=1,NP

          DO 110 J=1,NN
 110        NODE(I,J,K)=V0(I,K)

          DO 120 L=1,CLASS
            DO 120 J=1,NN
 120          NODE(I,J,K)=NODE(I,J,K)+ROT(I,L,K)*NODEL(L,J)

100   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VERPR1 ---------------------------------------------------
      E    N    D
