C**:::      ,,,,,VERPR2.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VERPR2(CLASS,NP,ROT,NV,NELTYP,NI,DNIDV,ERRTYP,N,
     &                  NB,DNBDV)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VERPR2  interpolates the proposal function N                  ***
C**           with the piecewise basis function NB. N is given      ***
C**           on the nodes of NB transformed to                     ***
C**           partitioning with half edge length.                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,NP,NV,NELTYP,ERRTYP
      DOUBLE PRECISION  ROT(CLASS,CLASS,NP),N(NELTYP,ERRTYP,NP),
     &                  NI(NELTYP,NV,NP),DNIDV(NELTYP,CLASS,NV,NP),
     &                  NB(ERRTYP,NV),DNBDV(ERRTYP,CLASS,NV)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C NP     I  I   I in  I =2**CLASS = number of partitionings
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of interpolants N
C--------I------I-----I------------------------------------------------
C ERRTYP I  I   I in  I number of interpolations NB
C--------I------I-----I------------------------------------------------
C ROT    I  R   I in  I rotation matrix: reference elment -> pieces
C        I      I out I invers of rotation matrix
C        I      I     I                      array: ROT(CLASS,CLASS,NP)
C--------I------I-----I------------------------------------------------
C N      I  R   I in  I N given at the nodes of NB shifted from the
C        I      I     I reference element to the element pieces
C        I      I     I                       array: N(NELTYP,ERRTYP,NP)
C--------I------I-----I------------------------------------------------
C NB     I  R   I in  I NB given on NV point in the reference element
C        I      I     I                             array: NB(ERRTYP,NV)
C--------I------I-----I-------------------------------------------------
C DNBDV  I  R   I in  I derivative of NB
C        I      I     I                    array: DNBDV(ERRTYP,CLASS,NV)
C--------I------I-----I-------------------------------------------------
C NI     I  R   I in  I interpolation of N at the images of the NV 
C        I      I     I reference element points in the element pieces
C        I      I     I                          array: NI(NELTYP,NV,NP)
C--------I------I-----I-------------------------------------------------
C DNIDV  I  R   I in  I derivatives of NI
C        I      I     I                 array: DNIDV(NELTYP,CLASS,NV,NP)
C--------I------I-----I-------------------------------------------------
C**                                                                 ***
      INTEGER             I,J,K,L,M,L1,L2
      DOUBLE PRECISION    D,R11,R12,R13,R21,R22,R23,R31,R32,R33
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** invers of rotation matrix:                                    ***
C**   -------------------------                                     ***
C**                                                                 ***
      IF (CLASS.EQ.0) THEN
      ELSEIF (CLASS.EQ.1) THEN
          DO 100 J=1,NP
             ROT(1,1,J)=1/ROT(1,1,J)
100       CONTINUE
      ELSEIF (CLASS.EQ.2) THEN
          DO 200 J=1,NP
            R11=ROT(1,1,J)
            R12=ROT(1,2,J)
            R21=ROT(2,1,J)
            R22=ROT(2,2,J)
            D=1/(R11*R22-R12*R21)
            ROT(1,1,J)= R22*D
            ROT(2,1,J)=-R21*D
            ROT(1,2,J)=-R12*D
            ROT(2,2,J)= R11*D
  200    CONTINUE
      ELSE
          DO 300 J=1,NP
             R11=ROT(1,1,J)
             R21=ROT(2,1,J)
             R31=ROT(3,1,J)
             R12=ROT(1,2,J)
             R22=ROT(2,2,J)
             R32=ROT(3,2,J)
             R13=ROT(1,3,J)
             R23=ROT(2,3,J)
             R33=ROT(3,3,J)
             D=1   /(R11*(R22*R33-R23*R32)
     &            +  R12*(R31*R23-R21*R33)
     &            +  R13*(R21*R32-R31*R22))
             ROT(1,1,J)=(R22*R33-R23*R32)*D
             ROT(2,1,J)=(R31*R23-R21*R33)*D
             ROT(3,1,J)=(R21*R32-R31*R22)*D
             ROT(1,2,J)=(R13*R32-R12*R33)*D
             ROT(2,2,J)=(R11*R33-R31*R13)*D
             ROT(3,2,J)=(R12*R31-R11*R32)*D
             ROT(1,3,J)=(R12*R23-R13*R22)*D
             ROT(2,3,J)=(R13*R21-R11*R23)*D
             ROT(3,3,J)=(R11*R22-R12*R21)*D
  300   CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      DO 10 K=1,NP
        DO 10 J=1,NV
         DO 10 I=1,NELTYP
           NI(I,J,K)=0
10    CONTINUE
      DO 20 K=1,NP
        DO 20 J=1,NV
          DO 20 M=1,ERRTYP
            DO 20 I=1,NELTYP
             NI(I,J,K)=NI(I,J,K)+N(I,M,K)*NB(M,J)
20    CONTINUE


      DO 30 K=1,NP
        DO 30 J=1,NV
          DO 30 L=1,CLASS
            DO 30 I=1,NELTYP
              DNIDV(I,L,J,K)=0
30    CONTINUE
      DO 40 K=1,NP
        DO 40 J=1,NV
          DO 40 L2=1,CLASS
            DO 40 L1=1,CLASS
              DO 40 M=1,ERRTYP
                DO 40 I=1,NELTYP
                  DNIDV(I,L1,J,K)=DNIDV(I,L1,J,K)+
     &                           N(I,M,K)*DNBDV(M,L2,J)*ROT(L2,L1,K)
40    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VERPR2 ---------------------------------------------------
      E    N    D
