C**:::      ,,,,,VERPR3.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VERPR3(CLASS,NP,ROT,NQL,WQL,WQ)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VERPR3   changes the value of the integration weights by     ***
C**             the transformation X -> V0 + ROT * X                ***
C**             from the reference element onto the refrences       ***
C**             element partioning with half edge length            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,NP,NQL
      DOUBLE PRECISION  ROT(CLASS,CLASS,NP),WQL(NQL),WQ(NQL,NP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C NP     I  I   I in  I =2**CLASS = number of partitionings
C--------I------I-----I------------------------------------------------
C WQL    I  I   I in  I integration weights in the refrence element
C        I      I     I                                 array: WQL(NQL)
C--------I------I-----I------------------------------------------------
C ROT    I  R   I in  I rotation matrix: reference element -> pieces
C        I      I     I                      array: ROT(CLASS,CLASS,NP)
C--------I------I-----I------------------------------------------------
C WQ     I  I   I out I integration weights in the partitioning
C        I      I     I of the reference elment        array: WQ(NQ,NP)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER             J,I
      DOUBLE PRECISION    FAC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      DO 10 J=1,NP

        IF (CLASS.EQ.1) THEN
           FAC=ROT(1,1,J)
        ELSEIF (CLASS.EQ.2) THEN
           FAC=ROT(1,1,J)*ROT(2,2,J)-ROT(1,2,J)*ROT(2,1,J)
        ELSE
           FAC=(ROT(2,2,J)*ROT(3,3,J)-ROT(2,3,J)*ROT(3,2,J))*ROT(1,1,J)
     &        +(ROT(3,1,J)*ROT(2,3,J)-ROT(2,1,J)*ROT(3,3,J))*ROT(1,2,J)
     &        +(ROT(2,1,J)*ROT(3,2,J)-ROT(3,1,J)*ROT(2,2,J))*ROT(1,3,J)
        ENDIF

        FAC=ABS(FAC)
        DO 10 I=1,NQL
          WQ(I,J)=WQL(I)*FAC
 10   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VERPR3 ---------------------------------------------------
      E    N    D
