C**:::      ,,,,,VERPRF.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VERPRF(CLASS,FORM,NELTYP,NV,V,N,DNDV,
     &                  LRWORK,RWORK,LIWORK,IWORK,
     &                  VEMXXX,VEMPXX,VERXXZ,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VERPRF  calculation of piecewise proposal functions         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,NELTYP,FORM,NV,LIWORK,IWORK(LIWORK),
     &                  LRWORK,ERR
      DOUBLE PRECISION  V(CLASS,NV),N(NELTYP,NV,2**CLASS),
     &                  DNDV(NELTYP,CLASS,NV,2**CLASS),RWORK(LRWORK)

      EXTERNAL          VEMPXX,VERXXZ,VEMXXX
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of the element
C--------I------I-----I------------------------------------------------
C NELTYP I  I   I in  I number of proposal function
C--------I------I-----I------------------------------------------------
C NV     I  I   I in  I number of nodes where the piecewise proposal
C        I      I     I functions have to be evaluated
C--------I------I-----I------------------------------------------------
C V      I  I   I in  I nodes where the piecewise proposal
C        I      I     I functions have to be evaluated
C--------I------I-----I------------------------------------------------
C N      I  R   I out I piecewise proposal functions
C        I      I     I                   array : N(NELTYP,NV,2**CLASS)
C--------I------I-----I------------------------------------------------
C DNDV   I  R   I out I derivatives of piecewise propsal functions
C        I      I     I           array: DNDV(NELTYP,CLASS,NV,2**CLASS)
C--------I------I-----I------------------------------------------------
C RWORK  I  I   I out I real work space            array: RWORK(LRWORK)
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I out I integer work space         array: IWORK(LIWORK)
C--------I------I-----I------------------------------------------------
C VEMXXX I  EX  I in  I routine which sets the proposal functions on the
C        I      I     I reference element
C--------I------I-----I------------------------------------------------
C VEMPXX I  EX  I in  I routine which sets the nodes of proposal 
C        I      I     I function pieces on the reference element
C--------I------I-----I------------------------------------------------
C VERXXZ I  EX  I in  I routine which defines the number of nodes
C        I      I     I for proposal functions pieces
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10002   illegal NELTYP
C        I      I     I 10010   small storage
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER             NODE,NODEL,NP,RW,LRW,ERRTYP,N1,N2,DN1DV,DN2DV,
     &                    V0,ROT
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=0
      IF (NELTYP.LE.0) RETURN
      NP=2**CLASS
      CALL VERXXZ(ERRTYP,NELTYP,CLASS,FORM,ERR)
      IF (ERR.GT.0) RETURN

      NODEL=1
      V0   =NODEL+CLASS*ERRTYP
      ROT  =V0   +NP*CLASS
      N1   =ROT  +NP*CLASS*CLASS
      DN1DV=N1   +ERRTYP*NV
      NODE =DN1DV+CLASS*ERRTYP*NV
      N2   =NODE +CLASS*ERRTYP*NP
      DN2DV=N2   +NELTYP*ERRTYP*NP
      RW   =DN2DV+CLASS*NELTYP*ERRTYP*NP
      LRW=LRWORK-RW+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set the nodes proposal function pieces:                       ***
C**   --------------------------------------                        ***
C**                                                                 ***
      CALL VEMPXX(CLASS,FORM,ERRTYP,RWORK(NODEL),
     &            LRW,RWORK(RW),LIWORK,IWORK,ERR)
      IF (ERR.GT.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** shift the nodes to element pieces:                            ***
C**   ---------------------------------                             ***
C**                                                                 ***
      CALL VERPR1(CLASS,FORM,NP,RWORK(ROT),RWORK(V0),
     &            ERRTYP,RWORK(NODEL),RWORK(NODE),ERR)
      IF (ERR.GT.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** evaluate the proposal function at the nodes of the proposal   ***
C**                                          function pieces:       ***
C**   -----------------------------------------------------------   ***
C**                                                                 ***
      CALL VEMXXX(CLASS,FORM,NELTYP,ERRTYP*NP,RWORK(NODE),RWORK(N2),
     &            RWORK(DN2DV),LRW,RWORK(RW),LIWORK,IWORK,ERR)
      IF (ERR.GT.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** evaluate the proposal function pieces at V:                   ***
C**   ------------------------------------------                    ***
C**                                                                 ***
      CALL VEMXXX(CLASS,FORM,ERRTYP,NV,V,RWORK(N1),
     &            RWORK(DN1DV),LRW,RWORK(RW),LIWORK,IWORK,ERR)
      IF (ERR.GT.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** this is the interpolation:                                    ***
C**   -------------------------                                     ***
C**                                                                 ***
      CALL VERPR2(CLASS,NP,RWORK(ROT),NV,NELTYP,
     &            N,DNDV,ERRTYP,RWORK(N2),RWORK(N1),RWORK(DN1DV))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   --------------------                                          ***
C**                                                                 ***
      R E T U R N
C-----End of VERPRF ---------------------------------------------------
      E    N    D
