C**:::      ,,,,,VERSHZ.....                                        ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VERSHZ(ERRTYP,GEOTYP,CLASS,FORM,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VERSHZ  sets the number of nodes for the function pieces      ***
C**           for the piecewise shape functions                     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                    >                                            ***
      INTEGER           CLASS,FORM,GEOTYP,ERRTYP,ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I form of the element
C--------I------I-----I------------------------------------------------
C ERRTYP I  I   I out I number nodes for function pieces
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number shape functions
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number
C        I      I     I 10000   illegal CLASS
C        I      I     I 10001   illegal FORM
C        I      I     I 10002   illegal GEOTYP
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      ERR=10000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 0 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 0 ) THEN
        ERR=10002
        IF (GEOTYP.EQ.1) THEN
          ERR=0
          ERRTYP=1
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 1 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 1 ) THEN
        ERR=10002
        IF (GEOTYP.EQ.2) THEN
          ERR=0
          ERRTYP=1
        ENDIF
        IF (GEOTYP.EQ.3) THEN
          ERR=0
          ERRTYP=2
        ENDIF
        IF (GEOTYP.EQ.4) THEN
          ERR=0
          ERRTYP=3
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 2 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 2 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** triangle :                                                  ***
C**     --------                                                    ***
C**                                                                 ***
        IF( FORM .EQ. 3 ) THEN
          ERR=10002
          IF( GEOTYP .EQ. 3 ) THEN
            ERR=0
            ERRTYP=1
          ENDIF
          IF( GEOTYP .EQ. 6 ) THEN
            ERR=0
            ERRTYP=3
          ENDIF
          IF( GEOTYP .EQ. 9 ) THEN
            ERR=0
            ERRTYP=6
          ENDIF
          IF( GEOTYP .EQ. 10) THEN
            ERR=0
            ERRTYP=6
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** quadrilateral :                                             ***
C**     ---------------                                             ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          IF( GEOTYP .EQ. 4 ) THEN
            ERR=0
            ERRTYP=1
          ENDIF
          IF( GEOTYP .EQ. 8 ) THEN
            ERR=0
            ERRTYP=4
          ENDIF
          IF( GEOTYP .EQ. 9 ) THEN
            ERR=0
            ERRTYP=4
          ENDIF
          IF( GEOTYP .EQ. 12 ) THEN
            ERR=0
            ERRTYP=9
          ENDIF
          IF( GEOTYP .EQ. 16 ) THEN
            ERR=0
            ERRTYP=9
          ENDIF
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS = 3 :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      IF( CLASS .EQ. 3 ) THEN

        ERR=10001
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** tetrahedron :                                               ***
C**     -------------                                               ***
C**                                                                 ***
        IF( FORM .EQ. 4 ) THEN
          ERR=10002
          IF( GEOTYP .EQ. 4 ) THEN
            ERR=0
            ERRTYP=1
          ENDIF
          IF( GEOTYP .EQ. 10) THEN
            ERR=0
            ERRTYP=4
          ENDIF
          IF( GEOTYP .EQ. 16) THEN
            ERR=0
            ERRTYP=10
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** prism:                                                      ***
C**     ------                                                      ***
C**                                                                 ***
        IF( FORM .EQ. 6 ) THEN
          ERR=10002
          IF( GEOTYP .EQ. 6 ) THEN
            ERR=0
            ERRTYP=1
          ENDIF
          IF( GEOTYP .EQ. 15 ) THEN
            ERR=0
            ERRTYP=6
          ENDIF
          IF( GEOTYP .EQ. 24 ) THEN
            ERR=0
            ERRTYP=15
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** hexahedron :                                                ***
C**     ------------                                                ***
C**                                                                 ***
        IF( FORM .EQ. 8 ) THEN
          ERR=10002
          IF( GEOTYP .EQ. 8 ) THEN
            ERR=0
            ERRTYP=1
          ENDIF
          IF( GEOTYP .EQ. 20 ) THEN
            ERR=0
            ERRTYP=8
          ENDIF
          IF( GEOTYP .EQ. 32 ) THEN
            ERR=0
            ERRTYP=20
          ENDIF
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VERSHZ ---------------------------------------------------
      E    N    D
