/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.jdbc.jdbcBlob;
import org.hsqldb.jdbc.jdbcClob;
import org.hsqldb.jdbc.jdbcResultSetMetaData;
import org.hsqldb.jdbc.jdbcStatement;
import org.hsqldb.jdbc.jdbcUtil;
import org.hsqldb.lib.AsciiStringInputStream;
import org.hsqldb.lib.StringInputStream;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class jdbcResultSet
implements ResultSet {
    boolean autoClose;
    public Result rResult;
    private Record nCurrent;
    private int iCurrentRow;
    private int iUpdateCount;
    private boolean bInit;
    int iColumnCount;
    private boolean bWasNull;
    private ResultSetMetaData rsmd;
    private HsqlProperties connProperties;
    private boolean isNetConn;
    jdbcStatement sqlStatement;
    int rsType = 1003;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;

    public boolean next() throws SQLException {
        this.bWasNull = false;
        if (this.rResult == null || this.rResult.isEmpty()) {
            return false;
        }
        if (!this.bInit) {
            this.nCurrent = this.rResult.rRoot;
            this.bInit = true;
            this.iCurrentRow = 1;
        } else {
            if (this.nCurrent == null) {
                return false;
            }
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        if (this.nCurrent == null) {
            this.iCurrentRow = this.rResult.getSize() + 1;
            return false;
        }
        return true;
    }

    public void close() throws SQLException {
        this.iUpdateCount = -1;
        this.rResult = null;
        if (this.autoClose) {
            this.sqlStatement.close();
        }
    }

    public boolean wasNull() throws SQLException {
        return this.bWasNull;
    }

    public String getString(int n) throws SQLException {
        return (String)this.getColumnInType(n, 1);
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getColumnInType(n, 16);
        return object == null ? false : (Boolean)object;
    }

    public byte getByte(int n) throws SQLException {
        Object object = this.getColumnInType(n, -6);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    public short getShort(int n) throws SQLException {
        Object object = this.getColumnInType(n, 5);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    public int getInt(int n) throws SQLException {
        Object object = this.getColumnInType(n, 4);
        return object == null ? 0 : ((Number)object).intValue();
    }

    public long getLong(int n) throws SQLException {
        Object object = this.getColumnInType(n, -5);
        return object == null ? 0L : ((Number)object).longValue();
    }

    public float getFloat(int n) throws SQLException {
        Object object = this.getColumnInType(n, 7);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    public double getDouble(int n) throws SQLException {
        Object object = this.getColumnInType(n, 8);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.getColumnInType(n, 3);
        if (n2 < 0) {
            throw jdbcUtil.sqlException(62);
        }
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2, 5);
        }
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        object = this.getColumnInType(n, -2);
        return (byte[])object;
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.getColumnInType(n, 91);
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.getColumnInType(n, 92);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getColumnInType(n, 93);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new AsciiStringInputStream(string);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringInputStream(string);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return this.wasNull() ? null : new ByteArrayInputStream(byArray);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.rsmd == null) {
            this.rsmd = new jdbcResultSetMetaData(this, this.connProperties);
        }
        return this.rsmd;
    }

    public Object getObject(int n) throws SQLException {
        Object object;
        this.checkAvailable();
        try {
            object = this.nCurrent.data[--n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw jdbcUtil.sqlException(28, String.valueOf(++n));
        }
        if (this.checkNull(object)) {
            return null;
        }
        if (object instanceof JavaObject) {
            try {
                return ((JavaObject)object).getObject();
            }
            catch (HsqlException hsqlException) {
                throw jdbcUtil.sqlException(Trace.error(18));
            }
        }
        if (object instanceof Binary) {
            return ((Binary)object).getClonedBytes();
        }
        if (object instanceof Date) {
            return ((Date)object).clone();
        }
        if (object instanceof Time) {
            return ((Time)object).clone();
        }
        if (object instanceof Timestamp) {
            return ((Timestamp)object).clone();
        }
        return object;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        for (int i = 0; i < this.iColumnCount; ++i) {
            String string2 = this.rResult.metaData.colLabels[i];
            if (!string.equalsIgnoreCase(string2)) continue;
            return i + 1;
        }
        throw jdbcUtil.sqlException(28, string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)this.getColumnInType(n, 3);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.rResult.rRoot != null && !this.bInit;
    }

    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.rResult.rRoot != null && this.bInit && this.nCurrent == null;
    }

    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.iCurrentRow == 1;
    }

    public boolean isLast() throws SQLException {
        this.checkClosed();
        return this.rResult.rRoot != null && this.bInit && this.nCurrent != null && this.nCurrent.next == null;
    }

    public void beforeFirst() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw jdbcUtil.sqlException(51);
        }
        this.bInit = false;
        this.nCurrent = null;
        this.iCurrentRow = 0;
    }

    public void afterLast() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw jdbcUtil.sqlException(51);
        }
        if (this.rResult != null && this.rResult.rRoot != null) {
            this.bInit = true;
            this.iCurrentRow = this.rResult.getSize() + 1;
            this.nCurrent = null;
        }
    }

    public boolean first() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw jdbcUtil.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        this.bInit = false;
        if (this.rResult.rRoot != null) {
            this.bInit = true;
            this.nCurrent = this.rResult.rRoot;
            this.iCurrentRow = 1;
        }
        return this.bInit;
    }

    public boolean last() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw jdbcUtil.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null) {
            return false;
        }
        if (!this.bInit || this.nCurrent == null) {
            this.first();
        }
        while (this.nCurrent.next != null) {
            ++this.iCurrentRow;
            this.nCurrent = this.nCurrent.next;
        }
        return true;
    }

    public int getRow() throws SQLException {
        this.checkClosed();
        return this.iCurrentRow;
    }

    public boolean absolute(int n) throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw jdbcUtil.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null || n == 0) {
            return false;
        }
        switch (n) {
            case 1: {
                return this.first();
            }
            case -1: {
                return this.last();
            }
        }
        if (n < 0) {
            this.last();
            n = this.iCurrentRow + n + 1;
            if (n <= 0) {
                this.beforeFirst();
                return false;
            }
        }
        if (n < this.iCurrentRow || this.iCurrentRow == 0) {
            this.beforeFirst();
        }
        while (n > this.iCurrentRow) {
            this.next();
            if (this.nCurrent != null) continue;
        }
        return this.nCurrent != null;
    }

    public boolean relative(int n) throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw jdbcUtil.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null) {
            return false;
        }
        if (n < 0) {
            n = this.iCurrentRow + n;
            this.beforeFirst();
            if (n <= 0) {
                return false;
            }
        }
        while (n-- > 0) {
            this.next();
            if (this.nCurrent != null) continue;
        }
        return this.nCurrent != null;
    }

    public boolean previous() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw jdbcUtil.sqlException(51);
        }
        if (this.rResult == null || this.rResult.rRoot == null || this.iCurrentRow == 0) {
            return false;
        }
        if (this.bInit && this.nCurrent == null) {
            return this.last();
        }
        int n = this.iCurrentRow - 1;
        if (n == 0) {
            this.beforeFirst();
            return false;
        }
        this.first();
        while (n != this.iCurrentRow) {
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        return this.nCurrent != null;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        if (this.rsType == 1003 && n != 1000) {
            throw jdbcUtil.notSupported;
        }
    }

    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw jdbcUtil.sqlException(62);
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 1;
    }

    public int getType() throws SQLException {
        this.checkClosed();
        return this.rsType;
    }

    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public void updateNull(int n) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateShort(int n, short s) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateLong(int n, long l) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateString(int n, String string) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateTime(int n, Time time2) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time2) throws SQLException {
        this.updateTime(this.findColumn(string), time2);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateRow() throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void deleteRow() throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void refreshRow() throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void cancelRowUpdates() throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void moveToInsertRow() throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public Statement getStatement() throws SQLException {
        return this.sqlStatement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public Ref getRef(int n) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public Blob getBlob(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return byArray == null ? null : new jdbcBlob(byArray);
    }

    public Clob getClob(int n) throws SQLException {
        String string = this.getString(n);
        return string == null ? null : new jdbcClob(string);
    }

    public Array getArray(int n) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        if (calendar == null) {
            return date;
        }
        calendar.setTime(date);
        HsqlDateTime.resetToDate(calendar);
        return new Date(calendar.getTime().getTime());
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time2 = this.getTime(n);
        if (time2 == null) {
            return null;
        }
        if (calendar == null) {
            return time2;
        }
        calendar.setTime(time2);
        HsqlDateTime.resetToTime(calendar);
        return new Time(calendar.getTime().getTime());
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public URL getURL(int n) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public URL getURL(String string) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    private void checkAvailable() throws SQLException {
        if (this.rResult == null || !this.bInit || this.nCurrent == null) {
            throw jdbcUtil.sqlException(35);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.rResult == null || this.sqlStatement != null && this.sqlStatement.isClosed) {
            throw jdbcUtil.sqlException(158);
        }
    }

    void checkColumn(int n) throws SQLException {
        if (n < 1 || n > this.iColumnCount) {
            throw jdbcUtil.sqlException(28, String.valueOf(n));
        }
    }

    private boolean checkNull(Object object) {
        if (object == null) {
            this.bWasNull = true;
            return true;
        }
        this.bWasNull = false;
        return false;
    }

    private Object getColumnInType(int n, int n2) throws SQLException {
        Object object;
        int n3;
        this.checkAvailable();
        try {
            n3 = this.rResult.metaData.colTypes[--n];
            object = this.nCurrent.data[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw jdbcUtil.sqlException(28, String.valueOf(++n));
        }
        if (this.checkNull(object)) {
            return null;
        }
        if (n2 == n3) {
            if (n2 == 91) {
                object = ((Date)object).clone();
            } else if (n2 == 92) {
                object = ((Time)object).clone();
            } else if (n2 == 93) {
                object = ((Timestamp)object).clone();
            }
            return object;
        }
        if (object instanceof Binary) {
            throw jdbcUtil.sqlException(16);
        }
        try {
            return Column.convertObject(object, n2);
        }
        catch (Exception exception) {
            String string = "type: " + Types.getTypeString(n3) + " (" + n3 + ") expected: " + Types.getTypeString(n2) + " value: " + object.toString();
            throw jdbcUtil.sqlException(16, string);
        }
    }

    jdbcResultSet(jdbcStatement jdbcStatement2, Result result, HsqlProperties hsqlProperties, boolean bl) throws SQLException {
        this.sqlStatement = jdbcStatement2;
        this.connProperties = hsqlProperties;
        this.isNetConn = bl;
        if (result.mode == 1) {
            this.iUpdateCount = result.getUpdateCount();
        } else if (result.mode == 2) {
            jdbcUtil.throwError(result);
        } else {
            if (jdbcStatement2 != null) {
                this.rsType = jdbcStatement2.rsType;
            }
            this.iUpdateCount = -1;
            this.rResult = result;
            this.iColumnCount = result.getColumnCount();
        }
        this.bWasNull = false;
    }

    int getUpdateCount() {
        return this.iUpdateCount;
    }

    boolean isResult() {
        return this.rResult != null;
    }
}

