/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.mov.analyser.GAPage;
import org.mov.analyser.GAResult;
import org.mov.analyser.GAResultModule;
import org.mov.analyser.GARulesPage;
import org.mov.analyser.OrderCache;
import org.mov.analyser.OrderComparator;
import org.mov.analyser.PortfolioPage;
import org.mov.analyser.QuoteRangePage;
import org.mov.analyser.TradeValuePage;
import org.mov.analyser.ga.GAIndividual;
import org.mov.analyser.ga.GeneticAlgorithm;
import org.mov.main.CommandManager;
import org.mov.main.Module;
import org.mov.main.ModuleFrame;
import org.mov.parser.Expression;
import org.mov.parser.Variables;
import org.mov.quote.QuoteBundle;
import org.mov.quote.ScriptQuoteBundle;
import org.mov.ui.ProgressDialog;
import org.mov.ui.ProgressDialogManager;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class GAModule
extends JPanel
implements Module {
    private PropertyChangeSupport propertySupport;
    private JDesktopPane desktop;
    private ScriptQuoteBundle quoteBundle;
    private static ModuleFrame resultsFrame = null;
    private JTabbedPane tabbedPane;
    private QuoteRangePage quoteRangePage;
    private GARulesPage GARulesPage;
    private PortfolioPage portfolioPage;
    private TradeValuePage tradeValuePage;
    private GAPage GAPage;

    public GAModule(JDesktopPane desktop) {
        this.desktop = desktop;
        this.propertySupport = new PropertyChangeSupport(this);
        this.layoutGeneticAlgorithm();
        this.load();
    }

    private void layoutGeneticAlgorithm() {
        this.tabbedPane = new JTabbedPane();
        this.quoteRangePage = new QuoteRangePage(this.desktop);
        this.tabbedPane.addTab(this.quoteRangePage.getTitle(), this.quoteRangePage.getComponent());
        double maxHeight = this.quoteRangePage.getPreferredSize().getHeight();
        this.GARulesPage = new GARulesPage(this.desktop, maxHeight);
        this.tabbedPane.addTab(this.GARulesPage.getTitle(), this.GARulesPage.getComponent());
        this.portfolioPage = new PortfolioPage(this.desktop);
        this.tabbedPane.addTab(this.portfolioPage.getTitle(), this.portfolioPage.getComponent());
        this.tradeValuePage = new TradeValuePage(this.desktop);
        this.tabbedPane.addTab(this.tradeValuePage.getTitle(), this.tradeValuePage.getComponent());
        this.GAPage = new GAPage(this.desktop);
        this.tabbedPane.addTab(this.GAPage.getTitle(), this.GAPage.getComponent());
        JPanel buttonPanel = new JPanel();
        JButton runButton = new JButton(Locale.getString("RUN"));
        runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAModule.this.run();
            }
        });
        buttonPanel.add(runButton);
        JButton closeButton = new JButton(Locale.getString("CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GAModule.this.propertySupport.firePropertyChange("window close", 0, 1);
            }
        });
        buttonPanel.add(closeButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)buttonPanel, "South");
    }

    private void load() {
        this.quoteRangePage.load(this.getClass().getName());
        this.GARulesPage.load(this.getClass().getName());
        this.portfolioPage.load(this.getClass().getName());
        this.tradeValuePage.load(this.getClass().getName());
        this.GAPage.load(this.getClass().getName());
    }

    public void save() {
        this.quoteRangePage.save(this.getClass().getName());
        this.GARulesPage.save(this.getClass().getName());
        this.portfolioPage.save(this.getClass().getName());
        this.tradeValuePage.save(this.getClass().getName());
        this.GAPage.save(this.getClass().getName());
    }

    public String getTitle() {
        return Locale.getString("GENETIC_ALGORITHM_TITLE");
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return null;
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    private void run() {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                Thread thread2 = Thread.currentThread();
                GAModule.this.save();
                if (GAModule.this.parse()) {
                    GAModule.this.geneticAlgorithm();
                }
            }
        });
        thread2.start();
    }

    private boolean parse() {
        if (!this.quoteRangePage.parse()) {
            this.tabbedPane.setSelectedComponent(this.quoteRangePage.getComponent());
            return false;
        }
        if (!this.GARulesPage.parse()) {
            this.tabbedPane.setSelectedComponent(this.GARulesPage.getComponent());
            return false;
        }
        if (!this.portfolioPage.parse()) {
            this.tabbedPane.setSelectedComponent(this.portfolioPage.getComponent());
            return false;
        }
        if (!this.tradeValuePage.parse()) {
            this.tabbedPane.setSelectedComponent(this.tradeValuePage.getComponent());
            return false;
        }
        if (!this.GAPage.parse()) {
            this.tabbedPane.setSelectedComponent(this.GAPage.getComponent());
            return false;
        }
        return true;
    }

    private void geneticAlgorithm() {
        ProgressDialog progress = ProgressDialogManager.getProgressDialog();
        Thread thread2 = Thread.currentThread();
        progress.setIndeterminate(true);
        progress.show(Locale.getString("GENETIC_ALGORITHM_TITLE"));
        TradingDate startDate = this.quoteRangePage.getStartDate();
        TradingDate endDate = this.quoteRangePage.getEndDate();
        Money initialCapital = this.portfolioPage.getInitialCapital();
        Money tradeCost = this.portfolioPage.getTradeCost();
        int breedingPopulation = this.GAPage.getBreedingPopulation();
        int displayPopulation = this.GAPage.getDisplayPopulation();
        Money stockValue = this.portfolioPage.getStockValue();
        int numberStocks = this.portfolioPage.getNumberStocks();
        String tradeValueBuy = this.tradeValuePage.getTradeValueBuy();
        String tradeValueSell = this.tradeValuePage.getTradeValueSell();
        GAIndividual lowestGAIndividual = this.GARulesPage.getLowestIndividual();
        GAIndividual highestGAIndividual = this.GARulesPage.getHighestIndividual();
        Variables variables = new Variables();
        variables.add("held", 2, true);
        variables.add("order", 2, true);
        for (int ii = 0; ii < lowestGAIndividual.size(); ++ii) {
            variables.add(lowestGAIndividual.parameter(ii), lowestGAIndividual.type(ii), true);
        }
        Expression buyRule = this.GARulesPage.getBuyRule();
        Expression sellRule = this.GARulesPage.getSellRule();
        this.quoteBundle = new ScriptQuoteBundle(this.quoteRangePage.getQuoteRange());
        OrderComparator orderComparator = this.quoteRangePage.getOrderComparator(this.quoteBundle);
        OrderCache orderCache = new OrderCache(this.quoteBundle, orderComparator);
        if (!thread2.isInterrupted()) {
            int numberGenerations = this.GAPage.getGenerations();
            int population = this.GAPage.getPopulation();
            progress.setIndeterminate(false);
            progress.setMaximum(numberGenerations * population);
            progress.setProgress(0);
            progress.setMaster(true);
            GeneticAlgorithm geneticAlgorithm = new GeneticAlgorithm(this.quoteBundle, orderCache, buyRule, sellRule, startDate, endDate, initialCapital, stockValue, numberStocks, tradeCost, breedingPopulation, tradeValueBuy, tradeValueSell, lowestGAIndividual, highestGAIndividual, variables);
            for (int generation = 1; generation <= numberGenerations && !thread2.isInterrupted(); ++generation) {
                int actualBreedingPopulation = geneticAlgorithm.getNextBreedingPopulationSize();
                for (int individual = 1; !(individual >= population && actualBreedingPopulation >= breedingPopulation || thread2.isInterrupted()); ++individual) {
                    progress.setNote(Locale.getString("GENERATION_OF", new Double(100.0 * (double)actualBreedingPopulation / (double)breedingPopulation).intValue(), generation, numberGenerations));
                    if (individual < population) {
                        progress.increment();
                    }
                    geneticAlgorithm.nextIndividual();
                    actualBreedingPopulation = geneticAlgorithm.getNextBreedingPopulationSize();
                }
                geneticAlgorithm.nextGeneration();
                if (geneticAlgorithm.getBreedingPopulationSize() <= 0) continue;
                this.display(this.getResults(geneticAlgorithm, geneticAlgorithm.getBreedingPopulationSize(), displayPopulation, this.quoteBundle, startDate, endDate, initialCapital, tradeCost, generation));
            }
        }
        ProgressDialogManager.closeProgressDialog(progress);
    }

    private List getResults(GeneticAlgorithm geneticAlgorithm, int breedingPopulation, int displayPopulation, QuoteBundle quoteBundle, TradingDate startDate, TradingDate endDate, Money initialCapital, Money tradeCost, int generation) {
        ArrayList<GAResult> results = new ArrayList<GAResult>();
        int displayCount = Math.min(breedingPopulation, displayPopulation);
        for (int i = 0; i < displayCount; ++i) {
            int offset = breedingPopulation - i - 1;
            GAIndividual individual = geneticAlgorithm.getBreedingIndividual(offset);
            results.add(new GAResult(individual, geneticAlgorithm.getBuyRule(), geneticAlgorithm.getSellRule(), quoteBundle, initialCapital, tradeCost, generation, startDate, endDate));
        }
        return results;
    }

    private void display(final List GAResults) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (resultsFrame == null || resultsFrame.isClosed()) {
                    resultsFrame = CommandManager.getInstance().newGAResultTable();
                }
                GAResultModule resultsModule = (GAResultModule)resultsFrame.getModule();
                resultsModule.addResults(GAResults);
            }
        });
    }
}

