/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mov.analyser.AnalyserPage;
import org.mov.prefs.PreferencesManager;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class GAPage
extends JPanel
implements AnalyserPage {
    private JDesktopPane desktop;
    private JTextField generationsTextField;
    private JTextField populationTextField;
    private JTextField breedingPopulationTextField;
    private JTextField displayPopulationTextField;
    private int generations;
    private int population;
    private int breedingPopulation;
    private int displayPopulation;
    private static final int MINIMUM_WINDOW_SIZE = 3;

    public GAPage(JDesktopPane desktop) {
        this.desktop = desktop;
        this.layoutPage();
    }

    public void load(String key) {
        HashMap settings = PreferencesManager.loadAnalyserPageSettings(key + this.getClass().getName());
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting = (String)iterator.next();
            String value = (String)settings.get(setting);
            if (setting.equals("generations")) {
                this.generationsTextField.setText(value);
                continue;
            }
            if (setting.equals("population")) {
                this.populationTextField.setText(value);
                continue;
            }
            if (setting.equals("breeding_population")) {
                this.breedingPopulationTextField.setText(value);
                continue;
            }
            if (!setting.equals("display_population")) continue;
            this.displayPopulationTextField.setText(value);
        }
    }

    public void save(String key) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("generations", this.generationsTextField.getText());
        settings.put("population", this.populationTextField.getText());
        settings.put("breeding_population", this.breedingPopulationTextField.getText());
        settings.put("display_population", this.displayPopulationTextField.getText());
        PreferencesManager.saveAnalyserPageSettings(key + this.getClass().getName(), settings);
    }

    public boolean parse() {
        this.generations = 0;
        this.population = 0;
        this.breedingPopulation = 0;
        this.displayPopulation = 0;
        try {
            if (!this.generationsTextField.getText().equals("")) {
                this.generations = Integer.parseInt(this.generationsTextField.getText());
            }
            if (!this.populationTextField.getText().equals("")) {
                this.population = Integer.parseInt(this.populationTextField.getText());
            }
            if (!this.breedingPopulationTextField.getText().equals("")) {
                this.breedingPopulation = Integer.parseInt(this.breedingPopulationTextField.getText());
            }
            if (!this.displayPopulationTextField.getText().equals("")) {
                this.displayPopulation = Integer.parseInt(this.displayPopulationTextField.getText());
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_NUMBER", e.getMessage()), Locale.getString("INVALID_GP_ERROR"), 0);
            return false;
        }
        if (this.displayPopulation > this.breedingPopulation) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("DISPLAY_POPULATION_ERROR"), Locale.getString("INVALID_GP_ERROR"), 0);
            return false;
        }
        if (this.generations <= 0) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_GENERATION_ERROR"), Locale.getString("INVALID_GP_ERROR"), 0);
            return false;
        }
        if (this.population <= 0) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_INDIVIDUAL_ERROR"), Locale.getString("INVALID_GP_ERROR"), 0);
            return false;
        }
        if (this.breedingPopulation <= 0) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_BREEDING_INDIVIDUAL_ERROR"), Locale.getString("INVALID_GP_ERROR"), 0);
            return false;
        }
        if (this.displayPopulation <= 0) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_DISPLAY_INDIVIDUAL_ERROR"), Locale.getString("INVALID_GP_ERROR"), 0);
            return false;
        }
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return Locale.getString("GA_PAGE_PARAMETERS_SHORT");
    }

    public int getGenerations() {
        return this.generations;
    }

    public int getPopulation() {
        return this.population;
    }

    public int getBreedingPopulation() {
        return this.breedingPopulation;
    }

    public int getDisplayPopulation() {
        return this.displayPopulation;
    }

    private void layoutPage() {
        this.setLayout(new BoxLayout(this, 1));
        TitledBorder titledBorder = new TitledBorder(Locale.getString("GA_PAGE_PARAMETERS_LONG"));
        JPanel panel = new JPanel();
        panel.setBorder(titledBorder);
        panel.setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        innerPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.generationsTextField = GridBagHelper.addTextRow(innerPanel, Locale.getString("GENERATIONS"), "", gridbag, c, 5);
        this.populationTextField = GridBagHelper.addTextRow(innerPanel, Locale.getString("POPULATION"), "", gridbag, c, 10);
        this.breedingPopulationTextField = GridBagHelper.addTextRow(innerPanel, Locale.getString("BREEDING_POPULATION"), "", gridbag, c, 7);
        this.displayPopulationTextField = GridBagHelper.addTextRow(innerPanel, Locale.getString("DISPLAY_POPULATION"), "", gridbag, c, 7);
        panel.add((Component)innerPanel, "North");
        this.add(panel);
    }
}

