/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.util.Iterator;
import java.util.List;
import org.mov.analyser.ga.GAIndividual;
import org.mov.parser.Expression;
import org.mov.portfolio.Portfolio;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class GAResult {
    private GAIndividual individual;
    private Expression buyRule;
    private Expression sellRule;
    private QuoteBundle quoteBundle;
    private Money initialCapital;
    private Money tradeCost;
    private int generation;
    private TradingDate startDate;
    private TradingDate endDate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GAResult(GAIndividual individual, Expression buyRule, Expression sellRule, QuoteBundle quoteBundle, Money initialCapital, Money tradeCost, int generation, TradingDate startDate, TradingDate endDate) {
        this.individual = individual;
        this.buyRule = buyRule;
        this.sellRule = sellRule;
        this.quoteBundle = quoteBundle;
        this.initialCapital = initialCapital;
        this.tradeCost = tradeCost;
        this.generation = generation;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public TradingDate getStartDate() {
        return this.startDate;
    }

    public TradingDate getEndDate() {
        return this.endDate;
    }

    public String getSymbols() {
        List symbolsTraded = this.getPortfolio().getSymbolsTraded();
        String string = new String();
        Iterator iterator = symbolsTraded.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (string.length() > 0) {
                string = string.concat(", " + symbol.toString());
                continue;
            }
            string = symbol.toString();
        }
        return string;
    }

    public String getBuyRule() {
        String temp = ((Object)this.buyRule).toString();
        String retValue = null;
        for (int ii = 0; ii < this.individual.size(); ++ii) {
            retValue = this.individual.type(ii) == 1 ? temp.replaceAll(this.individual.parameter(ii), Double.toString(this.individual.value(ii))) : temp.replaceAll(this.individual.parameter(ii), Integer.toString(new Double(this.individual.value(ii)).intValue()));
            temp = retValue;
        }
        return retValue;
    }

    public String getSellRule() {
        String temp = ((Object)this.sellRule).toString();
        String retValue = null;
        for (int ii = 0; ii < this.individual.size(); ++ii) {
            temp = retValue = temp.replaceAll(this.individual.parameter(ii), Double.toString(this.individual.value(ii)));
        }
        return retValue;
    }

    public int getGeneration() {
        return this.generation;
    }

    public Money getTradeCost() {
        return this.tradeCost;
    }

    public int getNumberTrades() {
        int accumulateTrades = this.getPortfolio().countTransactions(4);
        int reduceTrades = this.getPortfolio().countTransactions(5);
        return accumulateTrades + reduceTrades;
    }

    public Money getInitialCapital() {
        return this.initialCapital;
    }

    public Money getFinalCapital() {
        Money finalCapital;
        block2: {
            finalCapital = Money.ZERO;
            try {
                finalCapital = this.getPortfolio().getValue(this.getQuoteBundle(), this.getEndDate());
            }
            catch (MissingQuoteException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return finalCapital;
    }

    public Portfolio getPortfolio() {
        return this.individual.getPortfolio();
    }

    public QuoteBundle getQuoteBundle() {
        return this.quoteBundle;
    }

    static {
        $assertionsDisabled = !GAResult.class.desiredAssertionStatus();
    }
}

