/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.TitledBorder;
import org.mov.analyser.AnalyserPage;
import org.mov.analyser.GARulesPageModule;
import org.mov.analyser.ga.GAIndividual;
import org.mov.parser.Expression;
import org.mov.parser.ExpressionException;
import org.mov.parser.Parser;
import org.mov.parser.Variables;
import org.mov.prefs.PreferencesManager;
import org.mov.ui.EquationComboBox;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class GARulesPage
extends JPanel
implements AnalyserPage {
    private JDesktopPane desktop;
    private JCheckBox ruleFamilyEnabledCheckBox;
    private EquationComboBox buyRuleEquationComboBox;
    private EquationComboBox sellRuleEquationComboBox;
    private JTextField parameterTextField;
    private JTextField minValueTextField;
    private JTextField maxValueTextField;
    private JButton addParameterButton;
    private Expression buyRule;
    private Expression sellRule;
    private GARulesPageModule GARulesPageModule;

    public GARulesPage(JDesktopPane desktop, double maxHeight) {
        Dimension preferredSize = new Dimension();
        preferredSize.setSize(this.getPreferredSize().getWidth(), maxHeight / 2.0);
        this.desktop = desktop;
        this.GARulesPageModule = new GARulesPageModule(desktop);
        this.layoutPage(preferredSize);
    }

    public void load(String key) {
        String idStr = "Parameters";
        HashMap settings = PreferencesManager.loadAnalyserPageSettings(key + this.getClass().getName());
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting = (String)iterator.next();
            String value = (String)settings.get(setting);
            if (setting.equals("buy_rule")) {
                this.buyRuleEquationComboBox.setEquationText(value);
                continue;
            }
            if (setting.equals("sell_rule")) {
                this.sellRuleEquationComboBox.setEquationText(value);
                continue;
            }
            if (setting.equals("parameter")) {
                this.parameterTextField.setText(value);
                continue;
            }
            if (setting.equals("min_value")) {
                this.minValueTextField.setText(value);
                continue;
            }
            if (!setting.equals("max_value")) continue;
            this.maxValueTextField.setText(value);
        }
        HashMap settingsParam = PreferencesManager.loadAnalyserPageSettings(key + idStr);
        Iterator iteratorParam = settingsParam.keySet().iterator();
        while (iteratorParam.hasNext()) {
            String settingParam = (String)iteratorParam.next();
            String valueParam = (String)settingsParam.get(settingParam);
            this.GARulesPageModule.load(valueParam);
        }
    }

    public void save(String key) {
        String idStr = "Parameters";
        HashMap settingsParam = PreferencesManager.loadAnalyserPageSettings(key + idStr);
        HashMap<String, String> settings = new HashMap<String, String>();
        this.GARulesPageModule.save(settingsParam, idStr);
        settings.put("buy_rule", this.buyRuleEquationComboBox.getEquationText());
        settings.put("sell_rule", this.sellRuleEquationComboBox.getEquationText());
        settings.put("parameter", this.parameterTextField.getText());
        settings.put("min_value", this.minValueTextField.getText());
        settings.put("max_value", this.maxValueTextField.getText());
        PreferencesManager.saveAnalyserPageSettings(key + idStr, settingsParam);
        PreferencesManager.saveAnalyserPageSettings(key + this.getClass().getName(), settings);
    }

    public boolean parse() {
        Variables tmpVar;
        Variables variables = new Variables();
        String buyRuleString = this.buyRuleEquationComboBox.getEquationText();
        String sellRuleString = this.sellRuleEquationComboBox.getEquationText();
        variables.add("held", 2, true);
        variables.add("order", 2, true);
        GAIndividual lowestGAIndividual = this.getLowestIndividual();
        for (int ii = 0; ii < lowestGAIndividual.size(); ++ii) {
            variables.add(lowestGAIndividual.parameter(ii), lowestGAIndividual.type(ii), true);
        }
        if (buyRuleString.length() == 0) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("MISSING_BUY_RULE"), Locale.getString("ERROR_PARSING_RULES"), 0);
            return false;
        }
        if (sellRuleString.length() == 0) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("MISSING_SELL_RULE"), Locale.getString("ERROR_PARSING_RULES"), 0);
            return false;
        }
        try {
            tmpVar = null;
            try {
                tmpVar = (Variables)variables.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            this.buyRule = Parser.parse(tmpVar, buyRuleString);
        }
        catch (ExpressionException e) {
            this.buyRule = null;
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_BUY_RULE", e.getReason()), Locale.getString("ERROR_PARSING_RULES"), 0);
            return false;
        }
        try {
            tmpVar = null;
            try {
                tmpVar = (Variables)variables.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            this.sellRule = Parser.parse(tmpVar, sellRuleString);
        }
        catch (ExpressionException e) {
            this.sellRule = null;
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_SELL_RULE", e.getReason()), Locale.getString("ERROR_PARSING_RULES"), 0);
            return false;
        }
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return Locale.getString("RULES_PAGE_TITLE");
    }

    public Expression getBuyRule() {
        return this.buyRule;
    }

    public Expression getSellRule() {
        return this.sellRule;
    }

    public GAIndividual getLowestIndividual() {
        int sizeOfIndividual = this.GARulesPageModule.getRowCount();
        String[] parameters = new String[sizeOfIndividual];
        double[] values = new double[sizeOfIndividual];
        int[] types2 = new int[sizeOfIndividual];
        for (int ii = 0; ii < sizeOfIndividual; ++ii) {
            parameters[ii] = (String)this.GARulesPageModule.getValueAt(ii, org.mov.analyser.GARulesPageModule.PARAMETER_COLUMN);
            String value = (String)this.GARulesPageModule.getValueAt(ii, 1);
            try {
                values[ii] = Double.valueOf(value.trim());
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            types2[ii] = value.indexOf(46) == -1 ? 2 : 1;
        }
        GAIndividual retValue = new GAIndividual(parameters, values, types2);
        return retValue;
    }

    public GAIndividual getHighestIndividual() {
        int sizeOfIndividual = this.GARulesPageModule.getRowCount();
        String[] parameters = new String[sizeOfIndividual];
        double[] values = new double[sizeOfIndividual];
        int[] types2 = new int[sizeOfIndividual];
        for (int ii = 0; ii < sizeOfIndividual; ++ii) {
            parameters[ii] = (String)this.GARulesPageModule.getValueAt(ii, org.mov.analyser.GARulesPageModule.PARAMETER_COLUMN);
            String value = (String)this.GARulesPageModule.getValueAt(ii, 2);
            try {
                values[ii] = Double.valueOf(value.trim());
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            types2[ii] = value.indexOf(46) == -1 ? 2 : 1;
        }
        GAIndividual retValue = new GAIndividual(parameters, values, types2);
        return retValue;
    }

    private void addRow() {
        double dbl = 0.0;
        String str = null;
        try {
            str = this.minValueTextField.getText().trim();
            dbl = Double.valueOf(str);
            str = this.maxValueTextField.getText().trim();
            dbl = Double.valueOf(str);
            this.GARulesPageModule.addRow(this.parameterTextField.getText(), this.minValueTextField.getText(), this.maxValueTextField.getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_NUMBER", str), Locale.getString("ERROR_PARSING_RULES"), 0);
        }
    }

    private void layoutPage(Dimension preferredSize) {
        this.setLayout(new BoxLayout(this, 1));
        TitledBorder equationTitled = new TitledBorder(Locale.getString("RULES_PAGE_TITLE"));
        JPanel panel = new JPanel();
        panel.setBorder(equationTitled);
        panel.setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        innerPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        c.fill = 2;
        this.buyRuleEquationComboBox = GridBagHelper.addEquationRow(innerPanel, Locale.getString("BUY_RULE"), "", gridbag, c);
        this.sellRuleEquationComboBox = GridBagHelper.addEquationRow(innerPanel, Locale.getString("SELL_RULE"), "", gridbag, c);
        panel.add((Component)innerPanel, "North");
        this.add(panel);
        this.setLayout(new BoxLayout(this, 1));
        this.GARulesPageModule.setLayout(new BoxLayout(this.GARulesPageModule, 1));
        JScrollPane upDownScrollPane = new JScrollPane(this.GARulesPageModule);
        upDownScrollPane.setLayout(new ScrollPaneLayout());
        upDownScrollPane.setPreferredSize(preferredSize);
        this.add(upDownScrollPane);
        JPanel innerPanelParam = new JPanel();
        innerPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.parameterTextField = GridBagHelper.addTextRow(innerPanelParam, Locale.getString("PARAMETER"), "", gridbag, c, 7);
        this.minValueTextField = GridBagHelper.addTextRow(innerPanelParam, Locale.getString("MIN_PARAMETER"), "", gridbag, c, 7);
        this.maxValueTextField = GridBagHelper.addTextRow(innerPanelParam, Locale.getString("MAX_PARAMETER"), "", gridbag, c, 7);
        this.add(innerPanelParam);
        JPanel buttonPanel = new JPanel();
        JButton addParameterButton = new JButton(Locale.getString("ADD_PARAMETER"));
        addParameterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GARulesPage.this.addRow();
            }
        });
        this.add(addParameterButton);
    }
}

