/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mov.main.Module;
import org.mov.ui.AbstractTable;
import org.mov.ui.AbstractTableModel;
import org.mov.ui.Column;
import org.mov.ui.MenuHelper;
import org.mov.util.Locale;

public class GARulesPageModule
extends AbstractTable
implements Module {
    public static int PARAMETER_COLUMN = 0;
    public static final int MIN_PARAMETER_COLUMN = 1;
    public static final int MAX_PARAMETER_COLUMN = 2;
    public static final int NUMBER_COLUMN = 3;
    private PropertyChangeSupport propertySupport;
    private static final String separatorString = "@";
    private static final String nullString = " ";
    private static final String emptyString = " @ @ ";
    private static final String format = "0.00#";
    private JDesktopPane desktop;
    private Model model;
    private JMenuBar menuBar;
    private JMenuItem removeMenuItem;
    private JMenuItem removeAllMenuItem;
    static /* synthetic */ Class class$org$mov$analyser$GARulesPageModule;

    public GARulesPageModule(JDesktopPane desktop) {
        this.desktop = desktop;
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(PARAMETER_COLUMN, Locale.getString("PARAMETER"), Locale.getString("PARAMETER_COLUMN_HEADER"), String.class, 1));
        columns.add(new Column(1, Locale.getString("MIN_PARAMETER"), Locale.getString("MIN_PARAMETER_COLUMN_HEADER"), String.class, 1));
        columns.add(new Column(2, Locale.getString("MAX_PARAMETER"), Locale.getString("MAX_PARAMETER_COLUMN_HEADER"), String.class, 1));
        this.model = new Model(columns);
        this.setModel(this.model);
        this.model.addTableModelListener(this);
        this.propertySupport = new PropertyChangeSupport(this);
        this.addMenu();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GARulesPageModule.this.handleMouseClicked(evt);
            }
        });
        this.showColumns(this.model);
    }

    private void handleMouseClicked(MouseEvent event) {
        Point point = event.getPoint();
        if (event.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem popupRemoveMenuItem = new JMenuItem(Locale.getString("REMOVE"));
            popupRemoveMenuItem.setEnabled(this.getSelectedRowCount() >= 1);
            popupRemoveMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GARulesPageModule.this.removeSelectedResults();
                    GARulesPageModule.this.checkMenuDisabledStatus();
                }
            });
            menu.add(popupRemoveMenuItem);
            menu.show(this, point.x, point.y);
        }
    }

    private void removeSelectedResults() {
        int[] rows = this.getSelectedRows();
        ArrayList<Integer> rowIntegers = new ArrayList<Integer>();
        for (int i = 0; i < rows.length; ++i) {
            rowIntegers.add(new Integer(rows[i]));
        }
        ArrayList sortedRows = new ArrayList(rowIntegers);
        Collections.sort(sortedRows);
        Collections.reverse(sortedRows);
        List results = this.model.getResults();
        Iterator iterator = sortedRows.iterator();
        while (iterator.hasNext()) {
            Integer rowToRemove = (Integer)iterator.next();
            results.remove(rowToRemove);
        }
        this.model.setResults(results);
    }

    private void checkMenuDisabledStatus() {
        int numberOfSelectedRows = this.getSelectedRowCount();
        this.removeMenuItem.setEnabled(numberOfSelectedRows >= 1);
        this.removeAllMenuItem.setEnabled(this.model.getRowCount() > 0);
    }

    private void addMenu() {
        this.menuBar = new JMenuBar();
        JMenu resultMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("RESULT"));
        this.removeMenuItem = new JMenuItem(Locale.getString("REMOVE"));
        this.removeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GARulesPageModule.this.removeSelectedResults();
                GARulesPageModule.this.checkMenuDisabledStatus();
            }
        });
        resultMenu.add(this.removeMenuItem);
        this.removeAllMenuItem = new JMenuItem(Locale.getString("REMOVE_ALL"));
        this.removeAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GARulesPageModule.this.model.removeAllResults();
                GARulesPageModule.this.checkMenuDisabledStatus();
            }
        });
        resultMenu.add(this.removeAllMenuItem);
        resultMenu.addSeparator();
        JMenu columnMenu = this.createShowColumnMenu(this.model);
        resultMenu.add(columnMenu);
        resultMenu.addSeparator();
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GARulesPageModule.this.checkMenuDisabledStatus();
            }
        });
        this.checkMenuDisabledStatus();
    }

    public void addRow(String parameter, String minValue, String maxValue) {
        this.model.addRow(parameter, minValue, maxValue);
    }

    public String getTitle() {
        return Locale.getString("GA_PAGE_PARAMETERS_LONG");
    }

    public void save() {
        this.model.removeAllResults();
    }

    public void save(HashMap settings, String idStr) {
        List results = this.model.getResults();
        for (int i = 0; i < settings.size(); ++i) {
            settings.put(idStr + new Integer(i).toString(), emptyString);
        }
        int counterNew = 0;
        for (int i = 0; i < results.size(); ++i) {
            String[] values = new String[3];
            values = (String[])results.get(i);
            for (int j = 0; j < values.length; ++j) {
                if (!values[j].equals("")) continue;
                values[j] = new String(nullString);
            }
            if (values[PARAMETER_COLUMN].compareTo(nullString) != 0 || values[1].compareTo(nullString) != 0) {
                String value = values[PARAMETER_COLUMN] + separatorString + values[1] + separatorString + values[2];
                settings.put(idStr + new Integer(counterNew).toString(), value);
                ++counterNew;
            }
            values = null;
        }
    }

    public void load(String value) {
        String[] values = value.split(separatorString);
        if (values.length == 3) {
            for (int j = 0; j < values.length; ++j) {
                if (!values[j].equals(nullString)) continue;
                values[j] = new String("");
            }
            if (values[PARAMETER_COLUMN].compareTo("") != 0 || values[1].compareTo("") != 0) {
                ArrayList<String[]> newModel = new ArrayList<String[]>();
                newModel.add(values);
                this.model.addResults(newModel);
            }
        }
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    private class Model
    extends AbstractTableModel {
        private List results;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Model(List columns) {
            super(columns);
            this.results = new ArrayList();
        }

        public String[] getResult(int row) {
            return (String[])this.results.get(row);
        }

        public void removeAllResults() {
            this.results.clear();
            this.fireTableDataChanged();
        }

        public List getResults() {
            return this.results;
        }

        public void setResults(List results) {
            this.results = results;
            this.fireTableDataChanged();
        }

        public void addResults(List results) {
            this.results.addAll(results);
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.results.size();
        }

        public Object getValueAt(int row, int column) {
            if (row >= this.getRowCount()) {
                return "";
            }
            String[] result = (String[])this.results.get(row);
            if (column == PARAMETER_COLUMN) {
                return result[PARAMETER_COLUMN];
            }
            if (column == 1) {
                return result[1];
            }
            if (column == 2) {
                return result[2];
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return "";
        }

        public void addRow(String parameter, String minValue, String maxValue) {
            String[] result = new String[3];
            result[GARulesPageModule.PARAMETER_COLUMN] = new String(parameter);
            result[1] = new String(minValue);
            result[2] = new String(maxValue);
            this.results.add(result);
            this.fireTableDataChanged();
        }

        static {
            $assertionsDisabled = !(class$org$mov$analyser$GARulesPageModule == null ? (class$org$mov$analyser$GARulesPageModule = GARulesPageModule.class$("org.mov.analyser.GARulesPageModule")) : class$org$mov$analyser$GARulesPageModule).desiredAssertionStatus();
        }
    }
}

