/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.TitledBorder;
import org.mov.analyser.AnalyserPage;
import org.mov.analyser.GPGondolaSelectionPanel;
import org.mov.prefs.PreferencesManager;
import org.mov.ui.ConfirmDialog;
import org.mov.util.Locale;

public class GPGondolaSelection
extends JPanel
implements AnalyserPage {
    private final int maxPanels = 5;
    private JDesktopPane desktop;
    private Random random;
    GPGondolaSelectionPanel[] GPGondolaSelectionPanel = new GPGondolaSelectionPanel[5];

    public GPGondolaSelection(JDesktopPane desktop, double maxHeight) {
        this.desktop = desktop;
        this.random = new Random(System.currentTimeMillis());
        Dimension preferredSize = new Dimension();
        preferredSize.setSize(this.getPreferredSize().getWidth(), maxHeight / 20.0);
        int[] defaultValuesIntegers = new int[]{5000, 0, 0, 1250, 1250, 1250, 1250};
        String[] defaultTextFieldValuesIntegers = new String[]{Locale.getString("PERCENTAGE_ORDINARY_NUMBER"), Locale.getString("PERCENTAGE_FUNCTIONS", "dayofyear()"), Locale.getString("PERCENTAGE_FUNCTIONS", "month()"), Locale.getString("PERCENTAGE_FUNCTIONS", "day()"), Locale.getString("PERCENTAGE_FUNCTIONS", "dayofweek()"), Locale.getString("PERCENTAGE_FUNCTIONS", "held"), Locale.getString("PERCENTAGE_FUNCTIONS", "order")};
        this.GPGondolaSelectionPanel[0] = new GPGondolaSelectionPanel(7, desktop, defaultValuesIntegers, defaultTextFieldValuesIntegers, Locale.getString("GP_GONDOLA_SELECTION_TITLE_INTEGER_LONG"));
        this.GPGondolaSelectionPanel[0].setHeldAndOrder();
        int[] defaultValuesFloatInteger = new int[]{5000, 5000};
        String[] defaultTextFieldValuesFloatInteger = new String[]{Locale.getString("PERCENTAGE_FUNCTIONS", "open, low, high, close"), Locale.getString("PERCENTAGE_FUNCTIONS", "volume")};
        this.GPGondolaSelectionPanel[1] = new GPGondolaSelectionPanel(2, desktop, defaultValuesFloatInteger, defaultTextFieldValuesFloatInteger, Locale.getString("GP_GONDOLA_SELECTION_TITLE_FLOAT_INTEGER_LONG"));
        int[] defaultValuesFloatQuote = new int[]{2500, 2500, 2500, 2500};
        String[] defaultTextFieldValuesFloatQuote = new String[]{Locale.getString("PERCENTAGE_FUNCTIONS", "open"), Locale.getString("PERCENTAGE_FUNCTIONS", "low"), Locale.getString("PERCENTAGE_FUNCTIONS", "high"), Locale.getString("PERCENTAGE_FUNCTIONS", "close")};
        this.GPGondolaSelectionPanel[2] = new GPGondolaSelectionPanel(4, desktop, defaultValuesFloatQuote, defaultTextFieldValuesFloatQuote, Locale.getString("GP_GONDOLA_SELECTION_TITLE_FLOAT_QUOTE_LONG"));
        int[] defaultValuesBoolean = new int[]{1112, 1111, 1111, 1111, 1111, 1111, 1111, 1111, 1111};
        String[] defaultTextFieldValuesBoolean = new String[]{Locale.getString("PERCENTAGE_FUNCTIONS", "not"), Locale.getString("PERCENTAGE_FUNCTIONS", "="), Locale.getString("PERCENTAGE_FUNCTIONS", ">="), Locale.getString("PERCENTAGE_FUNCTIONS", ">"), Locale.getString("PERCENTAGE_FUNCTIONS", "<="), Locale.getString("PERCENTAGE_FUNCTIONS", "<"), Locale.getString("PERCENTAGE_FUNCTIONS", "!="), Locale.getString("PERCENTAGE_FUNCTIONS", "and"), Locale.getString("PERCENTAGE_FUNCTIONS", "or")};
        this.GPGondolaSelectionPanel[3] = new GPGondolaSelectionPanel(9, desktop, defaultValuesBoolean, defaultTextFieldValuesBoolean, Locale.getString("GP_GONDOLA_SELECTION_TITLE_BOOLEAN_LONG"));
        int[] defaultValuesExpression = new int[]{667, 667, 667, 667, 667, 667, 667, 667, 667, 667, 666, 666, 666, 666, 666};
        String[] defaultTextFieldValuesExpression = new String[]{Locale.getString("PERCENTAGE_TERMINAL"), Locale.getString("PERCENTAGE_FUNCTIONS", "+"), Locale.getString("PERCENTAGE_FUNCTIONS", "-"), Locale.getString("PERCENTAGE_FUNCTIONS", "*"), Locale.getString("PERCENTAGE_FUNCTIONS", "/"), Locale.getString("PERCENTAGE_FUNCTIONS", "percent()"), Locale.getString("PERCENTAGE_FUNCTIONS", "if(){}else{}"), Locale.getString("PERCENTAGE_FUNCTIONS", "lag()"), Locale.getString("PERCENTAGE_FUNCTIONS", "min()"), Locale.getString("PERCENTAGE_FUNCTIONS", "max()"), Locale.getString("PERCENTAGE_FUNCTIONS", "sum()"), Locale.getString("PERCENTAGE_FUNCTIONS", "sqrt()"), Locale.getString("PERCENTAGE_FUNCTIONS", "abs()"), Locale.getString("PERCENTAGE_FUNCTIONS", "rsi()"), Locale.getString("PERCENTAGE_FUNCTIONS", "avg()")};
        this.GPGondolaSelectionPanel[4] = new GPGondolaSelectionPanel(15, desktop, defaultValuesExpression, defaultTextFieldValuesExpression, Locale.getString("GP_GONDOLA_SELECTION_TITLE_EXPRESSION_LONG"));
        this.setGraphic(preferredSize);
        this.setDefaults();
    }

    public int getRandomToGenerateInteger(boolean allowHeld, boolean allowOrder) {
        return this.GPGondolaSelectionPanel[0].getRandom(allowHeld, allowOrder);
    }

    public int getRandomToGenerateFloatInteger() {
        return this.GPGondolaSelectionPanel[1].getRandom();
    }

    public int getRandomToGenerateFloatQuote() {
        return this.GPGondolaSelectionPanel[2].getRandom();
    }

    public int getRandomToGenerateBoolean() {
        return this.GPGondolaSelectionPanel[3].getRandom();
    }

    public int getRandomToGenerateExpression() {
        return this.GPGondolaSelectionPanel[4].getRandom();
    }

    public void load(String key) {
        HashMap settings = PreferencesManager.loadAnalyserPageSettings(key + this.getClass().getName());
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting = (String)iterator.next();
            String value = (String)settings.get(setting);
            this.GPGondolaSelectionPanel[0].load(setting, "gp_integer", value);
            this.GPGondolaSelectionPanel[1].load(setting, "gp_float_integer", value);
            this.GPGondolaSelectionPanel[2].load(setting, "gp_float_quote", value);
            this.GPGondolaSelectionPanel[3].load(setting, "gp_boolean", value);
            this.GPGondolaSelectionPanel[4].load(setting, "gp_expression", value);
        }
    }

    public void save(String key) {
        HashMap settings = new HashMap();
        this.GPGondolaSelectionPanel[0].save(settings, "gp_integer");
        this.GPGondolaSelectionPanel[1].save(settings, "gp_float_integer");
        this.GPGondolaSelectionPanel[2].save(settings, "gp_float_quote");
        this.GPGondolaSelectionPanel[3].save(settings, "gp_boolean");
        this.GPGondolaSelectionPanel[4].save(settings, "gp_expression");
        PreferencesManager.saveAnalyserPageSettings(key + this.getClass().getName(), settings);
    }

    public boolean parse() {
        boolean retValue = true;
        if (!this.isAllValuesAcceptable()) {
            retValue = false;
        } else if (!this.isFitAll()) {
            ConfirmDialog dialog = new ConfirmDialog(this.desktop, Locale.getString("GP_FIT"), Locale.getString("GP_FIT_TITLE"));
            boolean returnConfirm = dialog.showDialog();
            if (returnConfirm) {
                this.fitAll();
                retValue = true;
            } else {
                retValue = false;
            }
        }
        return retValue;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return Locale.getString("GP_GONDOLA_SELECTION_SHORT_TITLE");
    }

    private void setDefaults() {
        for (int i = 0; i < 5; ++i) {
            this.GPGondolaSelectionPanel[i].setDefaults();
        }
    }

    private void fitAll() {
        for (int i = 0; i < 5; ++i) {
            this.GPGondolaSelectionPanel[i].fit();
        }
    }

    private boolean isFitAll() {
        boolean retValue = true;
        for (int i = 0; retValue && i < 5; ++i) {
            retValue = this.GPGondolaSelectionPanel[i].isFit();
        }
        return retValue;
    }

    private boolean isAllValuesAcceptable() {
        boolean retValue = true;
        for (int i = 0; retValue && i < 5; ++i) {
            retValue = this.GPGondolaSelectionPanel[i].isAllValuesAcceptable();
        }
        return retValue;
    }

    private void setGraphic(Dimension preferredSize) {
        TitledBorder titledBorder = new TitledBorder(Locale.getString("GP_GONDOLA_SELECTION_TITLE"));
        this.setBorder(titledBorder);
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(preferredSize);
        JPanel upDownPanel = new JPanel();
        upDownPanel.setLayout(new BoxLayout(upDownPanel, 1));
        JScrollPane upDownScrollPane = new JScrollPane(upDownPanel);
        upDownScrollPane.setLayout(new ScrollPaneLayout());
        TitledBorder[] titledBorderSections = new TitledBorder[]{new TitledBorder(Locale.getString("GP_GONDOLA_SELECTION_TITLE_INTEGER_SHORT")), new TitledBorder(Locale.getString("GP_GONDOLA_SELECTION_TITLE_FLOAT_INTEGER_SHORT")), new TitledBorder(Locale.getString("GP_GONDOLA_SELECTION_TITLE_FLOAT_QUOTE_SHORT")), new TitledBorder(Locale.getString("GP_GONDOLA_SELECTION_TITLE_BOOLEAN_SHORT")), new TitledBorder(Locale.getString("GP_GONDOLA_SELECTION_TITLE_EXPRESSION_SHORT"))};
        for (int i = 0; i < 5; ++i) {
            this.GPGondolaSelectionPanel[i].setBorder(titledBorderSections[i]);
            upDownPanel.add(this.GPGondolaSelectionPanel[i]);
        }
        this.add(upDownScrollPane);
    }
}

