/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Random;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.TitledBorder;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class GPGondolaSelectionPanel
extends JPanel {
    private static final String format = "0.00#";
    private static final double PERCENT_DOUBLE = 100.0;
    private static final int PERCENT_INT = 10000;
    private static final int MAX_CHARS_IN_TEXTBOXES = 6;
    private JTextField[] percTextField;
    private int[] perc;
    private int[] defValues;
    private String[] defTextFieldValues;
    private boolean heldAndOrder = false;
    private JDesktopPane desktop;
    private Random random = new Random(System.currentTimeMillis());

    public GPGondolaSelectionPanel(int elements, JDesktopPane desktop, int[] defaultValues, String[] defaultTextFieldValues, String titledBorderText) {
        this.desktop = desktop;
        this.percTextField = new JTextField[elements];
        this.perc = new int[elements];
        this.defValues = defaultValues;
        this.defTextFieldValues = defaultTextFieldValues;
        this.setGraphic(titledBorderText);
    }

    public void setHeldAndOrder() {
        this.heldAndOrder = true;
    }

    public int getRandom() {
        return this.getRandom(true, true);
    }

    public int getRandom(boolean allowHeld, boolean allowOrder) {
        int retValue = 0;
        int total = 0;
        int totalLength = this.perc.length;
        if (!allowHeld) {
            --totalLength;
        }
        if (!allowOrder) {
            --totalLength;
        }
        for (int i = 0; i < totalLength; ++i) {
            total += this.perc[i];
        }
        int randomValue = this.random.nextInt(total);
        int totalMin = 0;
        int totalMax = 0;
        for (int i = 0; i < totalLength; ++i) {
            totalMax = totalMin + this.perc[i];
            if (randomValue >= totalMin && randomValue < totalMax) {
                retValue = i;
            }
            totalMin += this.perc[i];
        }
        return retValue;
    }

    public void save(HashMap settings, String idStr) {
        for (int i = 0; i < this.percTextField.length; ++i) {
            settings.put(idStr + new Integer(i).toString(), this.percTextField[i].getText());
        }
    }

    public void load(String setting, String idStr, String value) {
        for (int i = 0; i < this.percTextField.length; ++i) {
            if (!setting.equals(idStr + new Integer(i).toString())) continue;
            this.percTextField[i].setText(value);
        }
    }

    public void fit() {
        if (this.isAllValuesAcceptable()) {
            int total = 0;
            for (int i = 0; i < this.perc.length; ++i) {
                total += this.perc[i];
            }
            int[] dummyPerc = new int[this.perc.length];
            for (int i = 0; i < this.perc.length; ++i) {
                dummyPerc[i] = Math.round(this.perc[i] * 10000 / total);
            }
            int dummyTotal = 0;
            for (int i = 0; i < this.perc.length; ++i) {
                dummyTotal += dummyPerc[i];
            }
            int count = 0;
            while (dummyTotal != 10000) {
                if (dummyTotal > 10000) {
                    int n = count;
                    dummyPerc[n] = dummyPerc[n] - 1;
                    --dummyTotal;
                } else {
                    int n = count;
                    dummyPerc[n] = dummyPerc[n] + 1;
                    ++dummyTotal;
                }
                ++count;
            }
            for (int i = 0; i < this.perc.length; ++i) {
                this.perc[i] = dummyPerc[i];
            }
            this.setTexts();
        }
    }

    public boolean isFit() {
        boolean retValue = false;
        if (this.isAllValuesAcceptable()) {
            int total = 0;
            for (int i = 0; i < this.perc.length; ++i) {
                total += this.perc[i];
            }
            if (total == 10000) {
                retValue = true;
            }
        }
        return retValue;
    }

    public boolean isAllValuesAcceptable() {
        boolean retValue = true;
        try {
            this.setNumericalValues();
        }
        catch (ParseException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_NUMBER", e.getMessage()), Locale.getString("INVALID_GP_ERROR"), 0);
            retValue = false;
        }
        if (!this.isAllValuesPositive()) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_POSITIVE_VALUES_ERROR"), Locale.getString("INVALID_GP_ERROR"), 0);
            retValue = false;
        }
        if (!this.isTotalOK()) {
            retValue = false;
        }
        return retValue;
    }

    private void setNumericalValues() throws ParseException {
        this.setDefaultsValuesOnly();
        DecimalFormat decimalFormat = new DecimalFormat(format);
        for (int i = 0; i < this.perc.length; ++i) {
            if (this.percTextField[i].getText().equals("")) continue;
            this.perc[i] = (int)Math.round(100.0 * decimalFormat.parse(this.percTextField[i].getText()).doubleValue());
        }
    }

    private boolean isAllValuesPositive() {
        boolean returnValue = true;
        for (int i = 0; i < this.perc.length; ++i) {
            returnValue = returnValue && this.perc[i] >= 0;
        }
        return returnValue;
    }

    private boolean isTotalOK() {
        boolean retValue = true;
        long total = 0L;
        int totalLength = this.perc.length;
        if (this.heldAndOrder) {
            totalLength -= 2;
        }
        for (int i = 0; i < totalLength; ++i) {
            total += (long)this.perc[i];
        }
        if (total == 0L) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_TOTAL_GREATER_THAN_ZERO_ERROR"), Locale.getString("INVALID_GP_ERROR"), 0);
            retValue = false;
        }
        return retValue;
    }

    public void setDefaultsValuesOnly() {
        for (int i = 0; i < this.perc.length; ++i) {
            this.perc[i] = this.defValues[i];
        }
    }

    public void setDefaults() {
        for (int i = 0; i < this.perc.length; ++i) {
            this.perc[i] = this.defValues[i];
        }
        this.setTexts();
    }

    public void setTexts() {
        DecimalFormat decimalFormat = new DecimalFormat(format);
        for (int i = 0; i < this.percTextField.length; ++i) {
            this.percTextField[i].setText(decimalFormat.format((double)this.perc[i] / 100.0));
        }
    }

    private void setGraphic(String titledBorderText) {
        GridBagLayout gridbag = new GridBagLayout();
        TitledBorder titledBorder = new TitledBorder(titledBorderText);
        this.setBorder(titledBorder);
        this.setLayout(new BoxLayout(this, 1));
        JPanel upDownPanel = new JPanel();
        upDownPanel.setLayout(new BoxLayout(upDownPanel, 1));
        JScrollPane upDownScrollPane = new JScrollPane(upDownPanel);
        upDownScrollPane.setLayout(new ScrollPaneLayout());
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(gridbag);
        JButton fitButton = new JButton(Locale.getString("FIT"));
        JButton defaultButton = new JButton(Locale.getString("DEFAULT"));
        fitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPGondolaSelectionPanel.this.fit();
            }
        });
        defaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPGondolaSelectionPanel.this.setDefaults();
            }
        });
        fitButton.setAlignmentX(0.5f);
        defaultButton.setAlignmentX(0.5f);
        innerPanel.setAlignmentX(0.5f);
        upDownPanel.add(fitButton);
        upDownPanel.add(defaultButton);
        upDownPanel.add(innerPanel);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        for (int i = 0; i < this.percTextField.length; ++i) {
            this.percTextField[i] = GridBagHelper.addTextRow(innerPanel, this.defTextFieldValues[i], "", gridbag, c, 6);
        }
        this.add(upDownScrollPane);
    }
}

