/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.mov.analyser.GPGondolaSelection;
import org.mov.analyser.GPPage;
import org.mov.analyser.GPPageInitialPopulation;
import org.mov.analyser.GPResult;
import org.mov.analyser.GPResultModule;
import org.mov.analyser.OrderCache;
import org.mov.analyser.OrderComparator;
import org.mov.analyser.PortfolioPage;
import org.mov.analyser.QuoteRangePage;
import org.mov.analyser.TradeValuePage;
import org.mov.analyser.gp.GPQuoteBundle;
import org.mov.analyser.gp.GeneticProgramme;
import org.mov.analyser.gp.Individual;
import org.mov.main.CommandManager;
import org.mov.main.Module;
import org.mov.main.ModuleFrame;
import org.mov.parser.ExpressionFactory;
import org.mov.quote.QuoteBundle;
import org.mov.quote.ScriptQuoteBundle;
import org.mov.ui.ProgressDialog;
import org.mov.ui.ProgressDialogManager;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class GPModule
extends JPanel
implements Module {
    private PropertyChangeSupport propertySupport;
    private JDesktopPane desktop;
    private JTabbedPane tabbedPane;
    private static ModuleFrame resultsFrame = null;
    private QuoteRangePage quoteRangePage;
    private PortfolioPage portfolioPage;
    private GPPage GPPage;
    private GPPageInitialPopulation GPPageInitialPopulation;
    private GPGondolaSelection GPGondolaSelection;
    private TradeValuePage tradeValuePage;

    public GPModule(JDesktopPane desktop) {
        this.desktop = desktop;
        this.propertySupport = new PropertyChangeSupport(this);
        this.layoutGeneticProgramme();
        this.load();
    }

    private void layoutGeneticProgramme() {
        this.tabbedPane = new JTabbedPane();
        this.quoteRangePage = new QuoteRangePage(this.desktop);
        this.tabbedPane.addTab(this.quoteRangePage.getTitle(), this.quoteRangePage.getComponent());
        this.portfolioPage = new PortfolioPage(this.desktop);
        this.tabbedPane.addTab(this.portfolioPage.getTitle(), this.portfolioPage.getComponent());
        this.tradeValuePage = new TradeValuePage(this.desktop);
        this.tabbedPane.addTab(this.tradeValuePage.getTitle(), this.tradeValuePage.getComponent());
        double maxHeight = this.quoteRangePage.getPreferredSize().getHeight();
        if (this.portfolioPage.getPreferredSize().getHeight() > maxHeight) {
            maxHeight = this.portfolioPage.getPreferredSize().getHeight();
        }
        if (this.tradeValuePage.getPreferredSize().getHeight() > maxHeight) {
            maxHeight = this.tradeValuePage.getPreferredSize().getHeight();
        }
        this.GPPage = new GPPage(this.desktop);
        this.tabbedPane.addTab(this.GPPage.getTitle(), this.GPPage.getComponent());
        if (this.GPPage.getPreferredSize().getHeight() > maxHeight) {
            maxHeight = this.GPPage.getPreferredSize().getHeight();
        }
        this.GPPageInitialPopulation = new GPPageInitialPopulation(this.desktop, maxHeight);
        this.tabbedPane.addTab(this.GPPageInitialPopulation.getTitle(), this.GPPageInitialPopulation.getComponent());
        if (this.GPPageInitialPopulation.getPreferredSize().getHeight() > maxHeight) {
            maxHeight = this.GPPageInitialPopulation.getPreferredSize().getHeight();
        }
        this.GPGondolaSelection = new GPGondolaSelection(this.desktop, maxHeight);
        this.tabbedPane.addTab(this.GPGondolaSelection.getTitle(), this.GPGondolaSelection.getComponent());
        JPanel buttonPanel = new JPanel();
        JButton runButton = new JButton(Locale.getString("RUN"));
        runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPModule.this.run();
            }
        });
        buttonPanel.add(runButton);
        JButton closeButton = new JButton(Locale.getString("CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPModule.this.propertySupport.firePropertyChange("window close", 0, 1);
            }
        });
        buttonPanel.add(closeButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)buttonPanel, "South");
    }

    public void load() {
        this.quoteRangePage.load(this.getClass().getName());
        this.portfolioPage.load(this.getClass().getName());
        this.tradeValuePage.load(this.getClass().getName());
        this.GPPage.load(this.getClass().getName());
        this.GPPageInitialPopulation.load(this.getClass().getName());
        this.GPGondolaSelection.load(this.getClass().getName());
    }

    public void save() {
        this.quoteRangePage.save(this.getClass().getName());
        this.portfolioPage.save(this.getClass().getName());
        this.tradeValuePage.save(this.getClass().getName());
        this.GPPage.save(this.getClass().getName());
        this.GPPageInitialPopulation.save(this.getClass().getName());
        this.GPGondolaSelection.save(this.getClass().getName());
    }

    public String getTitle() {
        return Locale.getString("GENETIC_PROGRAMMING_TITLE");
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return null;
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    private void run() {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                Thread thread2 = Thread.currentThread();
                GPModule.this.save();
                if (GPModule.this.parse()) {
                    GPModule.this.geneticProgramme();
                }
            }
        });
        thread2.start();
    }

    private boolean parse() {
        if (!this.quoteRangePage.parse()) {
            this.tabbedPane.setSelectedComponent(this.quoteRangePage.getComponent());
            return false;
        }
        if (!this.portfolioPage.parse()) {
            this.tabbedPane.setSelectedComponent(this.portfolioPage.getComponent());
            return false;
        }
        if (!this.tradeValuePage.parse()) {
            this.tabbedPane.setSelectedComponent(this.tradeValuePage.getComponent());
            return false;
        }
        if (!this.GPPage.parse()) {
            this.tabbedPane.setSelectedComponent(this.GPPage.getComponent());
            return false;
        }
        if (!this.GPPageInitialPopulation.parse()) {
            this.tabbedPane.setSelectedComponent(this.GPPageInitialPopulation.getComponent());
            return false;
        }
        if (!this.GPGondolaSelection.parse()) {
            this.tabbedPane.setSelectedComponent(this.GPGondolaSelection.getComponent());
            return false;
        }
        return true;
    }

    private void geneticProgramme() {
        ProgressDialog progress = ProgressDialogManager.getProgressDialog();
        Thread thread2 = Thread.currentThread();
        progress.setIndeterminate(true);
        progress.show(Locale.getString("GENETIC_PROGRAMME"));
        TradingDate startDate = this.quoteRangePage.getStartDate();
        TradingDate endDate = this.quoteRangePage.getEndDate();
        Money initialCapital = this.portfolioPage.getInitialCapital();
        Money tradeCost = this.portfolioPage.getTradeCost();
        int breedingPopulation = this.GPPage.getBreedingPopulation();
        int displayPopulation = this.GPPage.getDisplayPopulation();
        int window = this.GPPage.getWindow();
        Money stockValue = this.portfolioPage.getStockValue();
        int numberStocks = this.portfolioPage.getNumberStocks();
        int mutations = this.GPPageInitialPopulation.getMutations();
        String tradeValueBuy = this.tradeValuePage.getTradeValueBuy();
        String tradeValueSell = this.tradeValuePage.getTradeValueSell();
        GPQuoteBundle quoteBundle = new GPQuoteBundle(new ScriptQuoteBundle(this.quoteRangePage.getQuoteRange()), window);
        OrderComparator orderComparator = this.quoteRangePage.getOrderComparator(quoteBundle);
        OrderCache orderCache = new OrderCache(quoteBundle, orderComparator);
        if (!thread2.isInterrupted()) {
            int numberGenerations = this.GPPage.getGenerations();
            int population = this.GPPage.getPopulation();
            progress.setIndeterminate(false);
            progress.setMaximum(numberGenerations * population);
            progress.setProgress(0);
            progress.setMaster(true);
            GeneticProgramme geneticProgramme = new GeneticProgramme(quoteBundle, this.GPGondolaSelection, orderCache, startDate, endDate, initialCapital, stockValue, numberStocks, tradeCost, breedingPopulation, tradeValueBuy, tradeValueSell);
            for (int generation = 1; generation <= numberGenerations && !thread2.isInterrupted(); ++generation) {
                int actualBreedingPopulation = geneticProgramme.getNextBreedingPopulationSize();
                for (int individual = 1; !(individual >= population && actualBreedingPopulation >= breedingPopulation || thread2.isInterrupted()); ++individual) {
                    progress.setNote(Locale.getString("GENERATION_OF", new Double(100.0 * (double)actualBreedingPopulation / (double)breedingPopulation).intValue(), generation, numberGenerations));
                    if (individual < population) {
                        progress.increment();
                    }
                    if (this.GPPageInitialPopulation.getIfRandom() == 0 || generation != 1) {
                        geneticProgramme.nextIndividual(null, null, mutations);
                    } else {
                        int randomRow = this.GPPageInitialPopulation.getIfRandom();
                        String buyRuleString = this.GPPageInitialPopulation.getBuyRule(randomRow);
                        String sellRuleString = this.GPPageInitialPopulation.getSellRule(randomRow);
                        geneticProgramme.nextIndividual(ExpressionFactory.newExpression(buyRuleString), ExpressionFactory.newExpression(sellRuleString), mutations);
                    }
                    actualBreedingPopulation = geneticProgramme.getNextBreedingPopulationSize();
                }
                geneticProgramme.nextGeneration();
                if (geneticProgramme.getBreedingPopulationSize() <= 0) continue;
                this.display(this.getResults(geneticProgramme, geneticProgramme.getBreedingPopulationSize(), displayPopulation, quoteBundle, startDate, endDate, initialCapital, tradeCost, generation));
            }
        }
        ProgressDialogManager.closeProgressDialog(progress);
    }

    private List getResults(GeneticProgramme geneticProgramme, int breedingPopulation, int displayPopulation, QuoteBundle quoteBundle, TradingDate startDate, TradingDate endDate, Money initialCapital, Money tradeCost, int generation) {
        ArrayList<GPResult> results = new ArrayList<GPResult>();
        int displayCount = Math.min(breedingPopulation, displayPopulation);
        for (int i = 0; i < displayCount; ++i) {
            int offset = breedingPopulation - i - 1;
            Individual individual = geneticProgramme.getBreedingIndividual(offset);
            results.add(new GPResult(individual, quoteBundle, initialCapital, tradeCost, generation, startDate, endDate));
        }
        return results;
    }

    private void display(final List GPResults) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (resultsFrame == null || resultsFrame.isClosed()) {
                    resultsFrame = CommandManager.getInstance().newGPResultTable(GPModule.this.GPPageInitialPopulation);
                }
                GPResultModule resultsModule = (GPResultModule)resultsFrame.getModule();
                resultsModule.addResults(GPResults);
            }
        });
    }
}

