/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ScrollPaneLayout;
import org.mov.analyser.AnalyserPage;
import org.mov.analyser.GPPageInitialPopulationModule;
import org.mov.prefs.PreferencesManager;
import org.mov.ui.ConfirmDialog;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class GPPageInitialPopulation
extends JPanel
implements AnalyserPage {
    private static final String format = "0.00#";
    private static final double PERCENT_DOUBLE = 100.0;
    private static final int PERCENT_INT = 10000;
    private static final int PERCENT_RANDOM = 0;
    private static final int PERCENT_INIT_POP = 1;
    private static final int PERCENT_MAX = 2;
    private JDesktopPane desktop;
    private int[] perc = new int[2];
    private JTextField numberMutationTextRow;
    private JTextField generateInitPopTextRow;
    private JTextField generateRandomPopTextRow;
    private Random random = new Random(System.currentTimeMillis());
    private GPPageInitialPopulationModule GPPageInitialPopulationModule;
    private int mutations;

    public GPPageInitialPopulation(JDesktopPane desktop, double maxHeight) {
        Dimension preferredSize = new Dimension();
        preferredSize.setSize(this.getPreferredSize().getWidth(), maxHeight / 2.0);
        this.desktop = desktop;
        this.GPPageInitialPopulationModule = new GPPageInitialPopulationModule(desktop);
        this.setGraphic(preferredSize);
    }

    public void save(String key) {
        String idStr = "GPInitialPopulation";
        HashMap settingsInitPop = PreferencesManager.loadAnalyserPageSettings(key + idStr);
        HashMap<String, String> settingsInitPopCommon = new HashMap<String, String>();
        this.GPPageInitialPopulationModule.save(settingsInitPop, idStr);
        settingsInitPopCommon.put("generations_changing_seeds", this.numberMutationTextRow.getText());
        settingsInitPopCommon.put("generations_random", this.generateRandomPopTextRow.getText());
        settingsInitPopCommon.put("generations_init_pop", this.generateInitPopTextRow.getText());
        PreferencesManager.saveAnalyserPageSettings(key + idStr, settingsInitPop);
        PreferencesManager.saveAnalyserPageSettings(key + this.getClass().getName(), settingsInitPopCommon);
    }

    public void load(String key) {
        String idStr = "GPInitialPopulation";
        HashMap settings = PreferencesManager.loadAnalyserPageSettings(key + this.getClass().getName());
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting = (String)iterator.next();
            String value = (String)settings.get(setting);
            this.loadCommon(setting, value);
        }
        HashMap settingsInitPop = PreferencesManager.loadAnalyserPageSettings(key + idStr);
        Iterator iteratorInitPop = settingsInitPop.keySet().iterator();
        while (iteratorInitPop.hasNext()) {
            String settingInitPop = (String)iteratorInitPop.next();
            String valueInitPop = (String)settingsInitPop.get(settingInitPop);
            this.GPPageInitialPopulationModule.load(valueInitPop);
        }
        this.loadEmpty();
    }

    private void loadCommon(String setting, String value) {
        if (setting.equals("generations_changing_seeds")) {
            this.numberMutationTextRow.setText(value);
        }
        if (setting.equals("generations_random")) {
            this.generateRandomPopTextRow.setText(value);
        }
        if (setting.equals("generations_init_pop")) {
            this.generateInitPopTextRow.setText(value);
        }
    }

    private void loadEmpty() {
        this.GPPageInitialPopulationModule.loadEmpty();
    }

    public void addRowTable(String buyRule, String sellRule, String perc) {
        this.GPPageInitialPopulationModule.addRowTable(buyRule, sellRule, perc);
    }

    public boolean parse() {
        boolean returnValue = true;
        this.mutations = 0;
        if (!this.isAllValuesAcceptable()) {
            returnValue = false;
        } else if (!this.isFitAll()) {
            ConfirmDialog dialog = new ConfirmDialog(this.desktop, Locale.getString("GP_FIT_PAGE"), Locale.getString("GP_FIT_TITLE"));
            boolean returnConfirm = dialog.showDialog();
            if (returnConfirm) {
                this.fitAll();
            } else {
                returnValue = false;
            }
        }
        try {
            if (!this.numberMutationTextRow.getText().equals("")) {
                this.mutations = Integer.parseInt(this.numberMutationTextRow.getText());
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_NUMBER", e.getMessage()), Locale.getString("INVALID_GP_ERROR"), 0);
            returnValue = false;
        }
        if (this.perc[0] != 10000 && !this.GPPageInitialPopulationModule.parse()) {
            returnValue = false;
        }
        return returnValue;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return Locale.getString("GP_PAGE_INITIAL_POPULATION_SHORT");
    }

    public int getMutations() {
        return this.mutations;
    }

    public int getIfRandom() {
        int retValue = 0;
        if (this.isAllValuesAcceptable()) {
            int total = 0;
            int totalLength = this.perc.length;
            for (int i = 0; i < totalLength; ++i) {
                total += this.perc[i];
            }
            int randomValue = this.random.nextInt(total);
            int totalMin = 0;
            int totalMax = 0;
            for (int i = 0; i < totalLength; ++i) {
                totalMax = totalMin + this.perc[i];
                if (randomValue >= totalMin && randomValue < totalMax) {
                    retValue = i;
                }
                totalMin += this.perc[i];
            }
        }
        return retValue;
    }

    public int getRandom() {
        return this.GPPageInitialPopulationModule.getRandom();
    }

    public String getBuyRule(int row) {
        return this.GPPageInitialPopulationModule.getBuyRule(row);
    }

    public String getSellRule(int row) {
        return this.GPPageInitialPopulationModule.getSellRule(row);
    }

    public void fitAll() {
        if (this.isAllValuesAcceptable()) {
            int total = 0;
            for (int i = 0; i < this.perc.length; ++i) {
                total += this.perc[i];
            }
            int[] dummyPerc = new int[this.perc.length];
            for (int i = 0; i < this.perc.length; ++i) {
                dummyPerc[i] = Math.round(this.perc[i] * 10000 / total);
            }
            int dummyTotal = 0;
            for (int i = 0; i < this.perc.length; ++i) {
                dummyTotal += dummyPerc[i];
            }
            int count = 0;
            while (dummyTotal != 10000) {
                if (dummyTotal > 10000) {
                    int n = count;
                    dummyPerc[n] = dummyPerc[n] - 1;
                    --dummyTotal;
                } else {
                    int n = count;
                    dummyPerc[n] = dummyPerc[n] + 1;
                    ++dummyTotal;
                }
                ++count;
            }
            for (int i = 0; i < this.perc.length; ++i) {
                this.perc[i] = dummyPerc[i];
            }
            this.setTexts();
        }
        this.validate();
        this.repaint();
    }

    private boolean isFitAll() {
        boolean retValue = false;
        if (this.isAllValuesAcceptable()) {
            int total = 0;
            for (int i = 0; i < this.perc.length; ++i) {
                total += this.perc[i];
            }
            if (total == 10000) {
                retValue = true;
            }
        }
        return retValue;
    }

    private boolean isAllValuesAcceptable() {
        boolean retValue = true;
        try {
            this.setNumericalValues();
        }
        catch (ParseException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_NUMBER", e.getMessage()), Locale.getString("INVALID_GP_ERROR"), 0);
            retValue = false;
        }
        if (!this.isAllValuesPositive()) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_POSITIVE_VALUES_ERROR"), Locale.getString("INVALID_GP_ERROR"), 0);
            retValue = false;
        }
        if (!this.isTotalOK()) {
            retValue = false;
        }
        return retValue;
    }

    private void setNumericalValues() throws ParseException {
        this.perc = new int[2];
        DecimalFormat decimalFormat = new DecimalFormat(format);
        this.perc[0] = !this.generateRandomPopTextRow.getText().equals("") ? (int)Math.round(100.0 * decimalFormat.parse(this.generateRandomPopTextRow.getText()).doubleValue()) : 0;
        this.perc[1] = !this.generateInitPopTextRow.getText().equals("") ? (int)Math.round(100.0 * decimalFormat.parse(this.generateInitPopTextRow.getText()).doubleValue()) : 0;
    }

    private void setTexts() {
        DecimalFormat decimalFormat = new DecimalFormat(format);
        this.generateRandomPopTextRow.setText(decimalFormat.format((double)this.perc[0] / 100.0));
        this.generateInitPopTextRow.setText(decimalFormat.format((double)this.perc[1] / 100.0));
    }

    private boolean isAllValuesPositive() {
        boolean returnValue = true;
        for (int i = 0; i < this.perc.length; ++i) {
            returnValue = returnValue && this.perc[i] >= 0;
        }
        return returnValue;
    }

    private boolean isTotalOK() {
        boolean retValue = true;
        long total = 0L;
        int totalLength = this.perc.length;
        for (int i = 0; i < totalLength; ++i) {
            total += (long)this.perc[i];
        }
        if (total == 0L) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_TOTAL_GREATER_THAN_ZERO_PAGE_ERROR"), Locale.getString("INVALID_GP_ERROR"), 0);
            retValue = false;
        }
        return retValue;
    }

    private void setDefaultValues() {
        this.perc[0] = 10000;
        this.perc[1] = 0;
        this.setTexts();
        this.validate();
        this.repaint();
    }

    private void setGraphic(Dimension preferredSize) {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(new BoxLayout(this, 1));
        this.GPPageInitialPopulationModule.setLayout(new BoxLayout(this.GPPageInitialPopulationModule, 1));
        JScrollPane upDownScrollPane = new JScrollPane(this.GPPageInitialPopulationModule);
        upDownScrollPane.setLayout(new ScrollPaneLayout());
        upDownScrollPane.setPreferredSize(preferredSize);
        JButton fitAllButton = new JButton(Locale.getString("FIT"));
        fitAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPPageInitialPopulation.this.GPPageInitialPopulationModule.fitAll();
                GPPageInitialPopulation.this.fitAll();
            }
        });
        JButton defaultButton = new JButton(Locale.getString("DEFAULT"));
        defaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPPageInitialPopulation.this.setDefaultValues();
            }
        });
        JPanel innerPanel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        innerPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.generateRandomPopTextRow = GridBagHelper.addTextRow(innerPanel, Locale.getString("GP_PAGE_GENERATE_RANDOM_PERC_TEXT_ROW"), "", gridbag, c, 12);
        this.generateInitPopTextRow = GridBagHelper.addTextRow(innerPanel, Locale.getString("GP_PAGE_GENERATE_PERC_TEXT_ROW"), "", gridbag, c, 12);
        this.numberMutationTextRow = GridBagHelper.addTextRow(innerPanel, Locale.getString("GP_PAGE_GENERATE_NUMBER_MUTATION_TEXT_ROW"), "", gridbag, c, 6);
        this.add(upDownScrollPane);
        this.add(innerPanel);
        fitAllButton.setAlignmentX(0.5f);
        defaultButton.setAlignmentX(0.5f);
        this.add(fitAllButton);
        this.add(defaultButton);
        this.setDefaultValues();
    }
}

