/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mov.main.Module;
import org.mov.ui.AbstractTable;
import org.mov.ui.AbstractTableModel;
import org.mov.ui.Column;
import org.mov.ui.ConfirmDialog;
import org.mov.ui.ExpressionEditorDialog;
import org.mov.ui.MenuHelper;
import org.mov.util.Locale;

public class GPPageInitialPopulationModule
extends AbstractTable
implements Module {
    private PropertyChangeSupport propertySupport;
    public static final int BUY_RULE_COLUMN = 0;
    public static final int SELL_RULE_COLUMN = 1;
    public static final int PERCENT_COLUMN = 2;
    public static final int NUMBER_COLUMN = 3;
    private static final String separatorString = "@";
    private static final String nullString = " ";
    private static final String emptyString = " @ @ ";
    private static final String format = "0.00#";
    private static final double PERCENT_DOUBLE = 100.0;
    private static final int PERCENT_INT = 10000;
    private JDesktopPane desktop;
    private Model model;
    private int[] perc = new int[0];
    private Random random = new Random(System.currentTimeMillis());
    private JMenuBar menuBar;
    private JMenuItem editBuyRuleMenuItem;
    private JMenuItem editSellRuleMenuItem;
    private JMenuItem editPercMenuItem;
    private JMenuItem viewBuyRuleMenuItem;
    private JMenuItem viewSellRuleMenuItem;
    private JMenuItem storeBuyRuleMenuItem;
    private JMenuItem storeSellRuleMenuItem;
    private JMenuItem removeMenuItem;
    private JMenuItem removeAllMenuItem;
    static /* synthetic */ Class class$org$mov$analyser$GPPageInitialPopulationModule;

    public GPPageInitialPopulationModule(JDesktopPane desktop) {
        this.desktop = desktop;
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(0, Locale.getString("BUY_RULE"), Locale.getString("BUY_RULE_COLUMN_HEADER"), String.class, 1));
        columns.add(new Column(1, Locale.getString("SELL_RULE"), Locale.getString("SELL_RULE_COLUMN_HEADER"), String.class, 1));
        columns.add(new Column(2, Locale.getString("PERCENT_MUTATION"), Locale.getString("PERCENT_MUTATION_COLUMN_HEADER"), String.class, 1));
        this.model = new Model(columns);
        this.setModel(this.model);
        this.model.addTableModelListener(this);
        this.propertySupport = new PropertyChangeSupport(this);
        this.addMenu();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GPPageInitialPopulationModule.this.handleMouseClicked(evt);
            }
        });
        this.showColumns(this.model);
    }

    private void handleMouseClicked(MouseEvent event) {
        Point point = event.getPoint();
        if (event.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem popupEditBuyRuleMenuItem = new JMenuItem(Locale.getString("EDIT_BUY_RULE"));
            popupEditBuyRuleMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupEditBuyRuleMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPPageInitialPopulationModule.this.editBuyRule();
                }
            });
            menu.add(popupEditBuyRuleMenuItem);
            JMenuItem popupEditSellRuleMenuItem = new JMenuItem(Locale.getString("EDIT_SELL_RULE"));
            popupEditSellRuleMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupEditSellRuleMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPPageInitialPopulationModule.this.editSellRule();
                }
            });
            menu.add(popupEditSellRuleMenuItem);
            JMenuItem popupEditPercMenuItem = new JMenuItem(Locale.getString("EDIT_PERC"));
            popupEditPercMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupEditPercMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPPageInitialPopulationModule.this.editPerc();
                }
            });
            menu.add(popupEditPercMenuItem);
            menu.addSeparator();
            JMenuItem popupViewBuyRuleMenuItem = new JMenuItem(Locale.getString("VIEW_BUY_RULE"));
            popupViewBuyRuleMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupViewBuyRuleMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPPageInitialPopulationModule.this.viewBuyRule();
                }
            });
            menu.add(popupViewBuyRuleMenuItem);
            JMenuItem popupViewSellRuleMenuItem = new JMenuItem(Locale.getString("VIEW_SELL_RULE"));
            popupViewSellRuleMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupViewSellRuleMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPPageInitialPopulationModule.this.viewSellRule();
                }
            });
            menu.add(popupViewSellRuleMenuItem);
            JMenuItem popupStoreBuyRuleMenuItem = new JMenuItem(Locale.getString("STORE_BUY_RULE"));
            popupStoreBuyRuleMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupStoreBuyRuleMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPPageInitialPopulationModule.this.storeBuyRule();
                }
            });
            menu.add(popupStoreBuyRuleMenuItem);
            JMenuItem popupStoreSellRuleMenuItem = new JMenuItem(Locale.getString("STORE_SELL_RULE"));
            popupStoreSellRuleMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupStoreSellRuleMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPPageInitialPopulationModule.this.storeSellRule();
                }
            });
            menu.add(popupStoreSellRuleMenuItem);
            menu.addSeparator();
            JMenuItem popupRemoveMenuItem = new JMenuItem(Locale.getString("REMOVE"));
            popupRemoveMenuItem.setEnabled(this.getSelectedRowCount() >= 1);
            popupRemoveMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPPageInitialPopulationModule.this.removeSelectedResults();
                    GPPageInitialPopulationModule.this.checkMenuDisabledStatus();
                }
            });
            menu.add(popupRemoveMenuItem);
            menu.show(this, point.x, point.y);
        }
    }

    private void editBuyRule() {
        final int row = this.getSelectedRow();
        if (row != -1) {
            final String[] result = this.model.getResult(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    String newBuyRule = ExpressionEditorDialog.showEditDialog(Locale.getString("EDIT_EQUATION"), result[0]);
                    GPPageInitialPopulationModule.this.model.setValueAt(row, 0, newBuyRule);
                    GPPageInitialPopulationModule.this.model.addEmptyIfNot();
                    GPPageInitialPopulationModule.this.model.fireTableDataChanged();
                    GPPageInitialPopulationModule.this.repaint();
                }
            });
            thread2.start();
        }
    }

    private void editSellRule() {
        final int row = this.getSelectedRow();
        if (row != -1) {
            final String[] result = this.model.getResult(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    String newSellRule = ExpressionEditorDialog.showEditDialog(Locale.getString("EDIT_EQUATION"), result[1]);
                    GPPageInitialPopulationModule.this.model.setValueAt(row, 1, newSellRule);
                    GPPageInitialPopulationModule.this.model.addEmptyIfNot();
                    GPPageInitialPopulationModule.this.model.fireTableDataChanged();
                    GPPageInitialPopulationModule.this.repaint();
                }
            });
            thread2.start();
        }
    }

    private void editPerc() {
        final int row = this.getSelectedRow();
        if (row != -1) {
            final String[] result = this.model.getResult(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    String newPerc = ExpressionEditorDialog.showEditDialog(Locale.getString("EDIT_PERC"), result[2]);
                    GPPageInitialPopulationModule.this.model.setValueAt(row, 2, newPerc);
                    GPPageInitialPopulationModule.this.model.fireTableDataChanged();
                    GPPageInitialPopulationModule.this.repaint();
                }
            });
            thread2.start();
        }
    }

    private void viewBuyRule() {
        int row = this.getSelectedRow();
        if (row != -1) {
            final String[] result = this.model.getResult(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    ExpressionEditorDialog.showViewDialog(Locale.getString("VIEW_BUY_RULE"), result[0]);
                }
            });
            thread2.start();
        }
    }

    private void viewSellRule() {
        int row = this.getSelectedRow();
        if (row != -1) {
            final String[] result = this.model.getResult(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    ExpressionEditorDialog.showViewDialog(Locale.getString("VIEW_SELL_RULE"), result[1]);
                }
            });
            thread2.start();
        }
    }

    private void storeBuyRule() {
        int row = this.getSelectedRow();
        if (row != -1) {
            final String[] result = this.model.getResult(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    ExpressionEditorDialog.showAddDialog(Locale.getString("STORE_BUY_RULE"), result[0]);
                }
            });
            thread2.start();
        }
    }

    private void storeSellRule() {
        int row = this.getSelectedRow();
        if (row != -1) {
            final String[] result = this.model.getResult(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    ExpressionEditorDialog.showAddDialog(Locale.getString("STORE_SELL_RULE"), result[1]);
                }
            });
            thread2.start();
        }
    }

    private void removeSelectedResults() {
        int[] rows = this.getSelectedRows();
        ArrayList<Integer> rowIntegers = new ArrayList<Integer>();
        for (int i = 0; i < rows.length; ++i) {
            rowIntegers.add(new Integer(rows[i]));
        }
        ArrayList sortedRows = new ArrayList(rowIntegers);
        Collections.sort(sortedRows);
        Collections.reverse(sortedRows);
        List results = this.model.getResults();
        Iterator iterator = sortedRows.iterator();
        while (iterator.hasNext()) {
            Integer rowToRemove = (Integer)iterator.next();
            results.remove(rowToRemove);
        }
        this.model.setResults(results);
        this.model.addEmptyIfNot();
    }

    private void checkMenuDisabledStatus() {
        int numberOfSelectedRows = this.getSelectedRowCount();
        this.editBuyRuleMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.editSellRuleMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.editPercMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.viewBuyRuleMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.viewSellRuleMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.storeBuyRuleMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.storeSellRuleMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.removeMenuItem.setEnabled(numberOfSelectedRows >= 1);
        this.removeAllMenuItem.setEnabled(this.model.getRowCount() > 0);
    }

    private void addMenu() {
        this.menuBar = new JMenuBar();
        JMenu resultMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("RESULT"));
        this.editBuyRuleMenuItem = new JMenuItem(Locale.getString("EDIT_BUY_RULE"));
        this.editBuyRuleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPPageInitialPopulationModule.this.editBuyRule();
            }
        });
        resultMenu.add(this.editBuyRuleMenuItem);
        this.editSellRuleMenuItem = new JMenuItem(Locale.getString("EDIT_SELL_RULE"));
        this.editSellRuleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPPageInitialPopulationModule.this.editSellRule();
            }
        });
        resultMenu.add(this.editSellRuleMenuItem);
        this.editPercMenuItem = new JMenuItem(Locale.getString("EDIT_PERC"));
        this.editPercMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPPageInitialPopulationModule.this.editSellRule();
            }
        });
        resultMenu.add(this.editPercMenuItem);
        resultMenu.addSeparator();
        this.viewBuyRuleMenuItem = new JMenuItem(Locale.getString("VIEW_BUY_RULE"));
        this.viewBuyRuleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPPageInitialPopulationModule.this.viewBuyRule();
            }
        });
        resultMenu.add(this.viewBuyRuleMenuItem);
        this.viewSellRuleMenuItem = new JMenuItem(Locale.getString("VIEW_SELL_RULE"));
        this.viewSellRuleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPPageInitialPopulationModule.this.viewSellRule();
            }
        });
        resultMenu.add(this.viewSellRuleMenuItem);
        this.storeBuyRuleMenuItem = new JMenuItem(Locale.getString("STORE_BUY_RULE"));
        this.storeBuyRuleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPPageInitialPopulationModule.this.storeBuyRule();
            }
        });
        resultMenu.add(this.storeBuyRuleMenuItem);
        this.storeSellRuleMenuItem = new JMenuItem(Locale.getString("STORE_SELL_RULE"));
        this.storeSellRuleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPPageInitialPopulationModule.this.storeSellRule();
            }
        });
        resultMenu.add(this.storeSellRuleMenuItem);
        resultMenu.addSeparator();
        this.removeMenuItem = new JMenuItem(Locale.getString("REMOVE"));
        this.removeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPPageInitialPopulationModule.this.removeSelectedResults();
                GPPageInitialPopulationModule.this.checkMenuDisabledStatus();
            }
        });
        resultMenu.add(this.removeMenuItem);
        this.removeAllMenuItem = new JMenuItem(Locale.getString("REMOVE_ALL"));
        this.removeAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPPageInitialPopulationModule.this.model.removeAllResults();
                GPPageInitialPopulationModule.this.checkMenuDisabledStatus();
            }
        });
        resultMenu.add(this.removeAllMenuItem);
        resultMenu.addSeparator();
        JMenu columnMenu = this.createShowColumnMenu(this.model);
        resultMenu.add(columnMenu);
        resultMenu.addSeparator();
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GPPageInitialPopulationModule.this.checkMenuDisabledStatus();
            }
        });
        this.checkMenuDisabledStatus();
    }

    public void addResults(List results) {
        this.model.addResults(results);
        this.checkMenuDisabledStatus();
        this.validate();
        this.repaint();
    }

    public void addRowTable(String buyRule, String sellRule, String perc) {
        ArrayList<String[]> results = new ArrayList<String[]>();
        String[] object = new String[]{new String(buyRule), new String(sellRule), new String(perc)};
        results.add(object);
        this.model.addResults(results);
        this.checkMenuDisabledStatus();
        this.validate();
        this.repaint();
    }

    public void fitAll() {
        if (this.isAllValuesAcceptable()) {
            int total = 0;
            for (int i = 0; i < this.perc.length; ++i) {
                total += this.perc[i];
            }
            int[] dummyPerc = new int[this.perc.length];
            for (int i = 0; i < this.perc.length; ++i) {
                dummyPerc[i] = Math.round(this.perc[i] * 10000 / total);
            }
            int dummyTotal = 0;
            for (int i = 0; i < this.perc.length; ++i) {
                dummyTotal += dummyPerc[i];
            }
            int count = 0;
            while (dummyTotal != 10000) {
                if (dummyTotal > 10000) {
                    int n = count;
                    dummyPerc[n] = dummyPerc[n] - 1;
                    --dummyTotal;
                } else {
                    int n = count;
                    dummyPerc[n] = dummyPerc[n] + 1;
                    ++dummyTotal;
                }
                ++count;
            }
            for (int i = 0; i < this.perc.length; ++i) {
                this.perc[i] = dummyPerc[i];
            }
            this.setTexts();
        }
        this.checkMenuDisabledStatus();
        this.validate();
        this.repaint();
    }

    private boolean isFitAll() {
        if (this.isAllValuesAcceptable()) {
            int total = 0;
            for (int i = 0; i < this.perc.length; ++i) {
                total += this.perc[i];
            }
            if (total == 10000) {
                return true;
            }
        }
        return false;
    }

    private boolean isAllValuesAcceptable() {
        try {
            this.setNumericalValues();
        }
        catch (ParseException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_NUMBER", e.getMessage()), Locale.getString("INVALID_GP_ERROR"), 0);
            return false;
        }
        if (!this.isAllValuesPositive()) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_POSITIVE_VALUES_ERROR"), Locale.getString("INVALID_GP_ERROR"), 0);
            return false;
        }
        return this.isTotalOK();
    }

    private void setNumericalValues() throws ParseException {
        this.perc = new int[this.model.getRowCount()];
        DecimalFormat decimalFormat = new DecimalFormat(format);
        for (int i = 0; i < this.perc.length; ++i) {
            String[] result = this.model.getResult(i);
            this.perc[i] = !result[2].equals("") && !result[2].equals(nullString) ? (int)Math.round(100.0 * decimalFormat.parse(result[2]).doubleValue()) : 0;
        }
    }

    private void setTexts() {
        DecimalFormat decimalFormat = new DecimalFormat(format);
        for (int i = 0; i < this.perc.length; ++i) {
            this.model.setValueAt(i, 2, decimalFormat.format((double)this.perc[i] / 100.0));
        }
    }

    private boolean isAllValuesPositive() {
        boolean returnValue = true;
        for (int i = 0; i < this.perc.length; ++i) {
            returnValue = returnValue && this.perc[i] >= 0;
        }
        return returnValue;
    }

    private boolean isTotalOK() {
        int i;
        long total = 0L;
        int totalLength = this.perc.length;
        for (i = 0; i < totalLength; ++i) {
            total += (long)this.perc[i];
        }
        if (total == 0L) {
            for (i = 0; i < totalLength; ++i) {
                this.perc[i] = 1;
            }
        }
        return true;
    }

    public String getTitle() {
        return Locale.getString("GP_PAGE_INITIAL_POPULATION_LONG");
    }

    public void save() {
        this.model.removeAllResults();
    }

    public void save(HashMap settings, String idStr) {
        List results = this.model.getResults();
        for (int i = 0; i < settings.size(); ++i) {
            settings.put(idStr + new Integer(i).toString(), emptyString);
        }
        int counterNew = 0;
        for (int i = 0; i < results.size(); ++i) {
            String[] values = new String[3];
            values = (String[])results.get(i);
            for (int j = 0; j < values.length; ++j) {
                if (!values[j].equals("")) continue;
                values[j] = new String(nullString);
            }
            if (values[0].compareTo(nullString) != 0 || values[1].compareTo(nullString) != 0) {
                String value = values[0] + separatorString + values[1] + separatorString + values[2];
                settings.put(idStr + new Integer(counterNew).toString(), value);
                ++counterNew;
            }
            values = null;
        }
    }

    public void load(String value) {
        String[] values = value.split(separatorString);
        if (values.length == 3) {
            for (int j = 0; j < values.length; ++j) {
                if (!values[j].equals(nullString)) continue;
                values[j] = new String("");
            }
            if (values[0].compareTo("") != 0 || values[1].compareTo("") != 0) {
                ArrayList<String[]> newModel = new ArrayList<String[]>();
                newModel.add(values);
                this.model.addResults(newModel);
            }
        }
    }

    public void loadEmpty() {
        this.model.addEmptyIfNot();
    }

    public int getRandom() {
        if (this.isAllValuesAcceptable()) {
            int total = 0;
            int totalLength = this.perc.length;
            for (int i = 0; i < totalLength; ++i) {
                total += this.perc[i];
            }
            int randomValue = this.random.nextInt(total);
            int totalMin = 0;
            int totalMax = 0;
            for (int i = 0; i < totalLength; ++i) {
                totalMax = totalMin + this.perc[i];
                if (randomValue >= totalMin && randomValue < totalMax) {
                    return i;
                }
                totalMin += this.perc[i];
            }
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_GENERATING_RANDOM_NUMBER"), Locale.getString("INVALID_GP_ERROR"), 0);
        }
        return 0;
    }

    public boolean parse() {
        if (!this.isAllValuesAcceptable()) {
            return false;
        }
        if (!this.isFitAll()) {
            ConfirmDialog dialog = new ConfirmDialog(this.desktop, Locale.getString("GP_FIT_PAGE"), Locale.getString("GP_FIT_TITLE"));
            boolean returnConfirm = dialog.showDialog();
            if (returnConfirm) {
                this.fitAll();
            } else {
                return false;
            }
        }
        return true;
    }

    public String getBuyRule(int row) {
        return (String)this.model.getValueAt(row, 0);
    }

    public String getSellRule(int row) {
        return (String)this.model.getValueAt(row, 1);
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    private class Model
    extends AbstractTableModel {
        private List results;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Model(List columns) {
            super(columns);
            this.results = new ArrayList();
        }

        public String[] getResult(int row) {
            return (String[])this.results.get(row);
        }

        public void removeAllResults() {
            this.results.clear();
            this.fireTableDataChanged();
        }

        public List getResults() {
            return this.results;
        }

        public void setResults(List results) {
            this.results = results;
            this.fireTableDataChanged();
        }

        public void addResults(List results) {
            this.results.addAll(results);
            this.fireTableDataChanged();
        }

        public void addEmptyIfNot() {
            boolean isAlreadyEmpty = false;
            for (int i = 0; i < this.getRowCount(); ++i) {
                String[] result = (String[])this.results.get(i);
                if (result[0].equals("") && result[1].equals("")) {
                    isAlreadyEmpty = true;
                }
                Object var3_3 = null;
            }
            if (!isAlreadyEmpty) {
                this.addEmpty();
            }
        }

        private void addEmpty() {
            String[] values = new String[3];
            for (int i = 0; i < values.length; ++i) {
                values[i] = new String("");
            }
            this.results.add(values);
        }

        public int getRowCount() {
            return this.results.size();
        }

        public Object getValueAt(int row, int column) {
            if (row >= this.getRowCount()) {
                return "";
            }
            String[] result = (String[])this.results.get(row);
            if (column == 0) {
                return result[0];
            }
            if (column == 1) {
                return result[1];
            }
            if (column == 2) {
                return result[2];
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return "";
        }

        public boolean setValueAt(int row, int column, String value) {
            if (row >= this.getRowCount()) {
                return false;
            }
            String[] result = (String[])this.results.get(row);
            String[] object = new String[]{new String(result[0]), new String(result[1]), new String(result[2])};
            object[column] = new String(value);
            result = this.results.set(row, object);
            result = null;
            return true;
        }

        static {
            $assertionsDisabled = !(class$org$mov$analyser$GPPageInitialPopulationModule == null ? (class$org$mov$analyser$GPPageInitialPopulationModule = GPPageInitialPopulationModule.class$("org.mov.analyser.GPPageInitialPopulationModule")) : class$org$mov$analyser$GPPageInitialPopulationModule).desiredAssertionStatus();
        }
    }
}

