/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mov.analyser.GPPageInitialPopulation;
import org.mov.analyser.GPResult;
import org.mov.main.CommandManager;
import org.mov.main.Module;
import org.mov.ui.AbstractTable;
import org.mov.ui.AbstractTableModel;
import org.mov.ui.ChangeFormat;
import org.mov.ui.Column;
import org.mov.ui.ExpressionEditorDialog;
import org.mov.ui.MenuHelper;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class GPResultModule
extends AbstractTable
implements Module {
    private PropertyChangeSupport propertySupport;
    private static final int START_DATE_COLUMN = 0;
    private static final int END_DATE_COLUMN = 1;
    private static final int SYMBOLS_COLUMN = 2;
    private static final int BUY_RULE_COLUMN = 3;
    private static final int SELL_RULE_COLUMN = 4;
    private static final int TRADE_COST_COLUMN = 5;
    private static final int NUMBER_OF_TRADES_COLUMN = 6;
    private static final int GENERATION_COLUMN = 7;
    private static final int INITIAL_CAPITAL_COLUMN = 8;
    private static final int FINAL_CAPITAL_COLUMN = 9;
    private static final int PERCENT_RETURN_COLUMN = 10;
    private Model model;
    private GPPageInitialPopulation GPPageInitialPopulation;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenuItem graphMenuItem;
    private JMenuItem transactionsMenuItem;
    private JMenuItem viewBuyRuleMenuItem;
    private JMenuItem viewSellRuleMenuItem;
    private JMenuItem storeBuyRuleMenuItem;
    private JMenuItem storeSellRuleMenuItem;
    private JMenuItem storeRulesInitialPopulation;
    private JMenuItem removeMenuItem;
    private JMenuItem removeAllMenuItem;
    static /* synthetic */ Class class$org$mov$analyser$GPResultModule;

    public GPResultModule(GPPageInitialPopulation GPPageInitialPopulation2) {
        this.GPPageInitialPopulation = GPPageInitialPopulation2;
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(0, Locale.getString("START_DATE"), Locale.getString("START_DATE_COLUMN_HEADER"), TradingDate.class, 0));
        columns.add(new Column(1, Locale.getString("END_DATE"), Locale.getString("END_DATE_COLUMN_HEADER"), TradingDate.class, 0));
        columns.add(new Column(2, Locale.getString("SYMBOLS"), Locale.getString("SYMBOLS_COLUMN_HEADER"), String.class, 1));
        columns.add(new Column(3, Locale.getString("BUY_RULE"), Locale.getString("BUY_RULE_COLUMN_HEADER"), String.class, 1));
        columns.add(new Column(4, Locale.getString("SELL_RULE"), Locale.getString("SELL_RULE_COLUMN_HEADER"), String.class, 1));
        columns.add(new Column(5, Locale.getString("TRADE_COST"), Locale.getString("TRADE_COST_COLUMN_HEADER"), Money.class, 0));
        columns.add(new Column(6, Locale.getString("NUMBER_TRADES"), Locale.getString("NUMBER_TRADES_COLUMN_HEADER"), Integer.class, 0));
        columns.add(new Column(7, Locale.getString("GENERATION_NUMBER"), Locale.getString("GENERATION_NUMBER_COLUMN_HEADER"), Integer.class, 1));
        columns.add(new Column(8, Locale.getString("INITIAL_CAPITAL"), Locale.getString("INITIAL_CAPITAL_COLUMN_HEADER"), Money.class, 0));
        columns.add(new Column(9, Locale.getString("FINAL_CAPITAL"), Locale.getString("FINAL_CAPITAL_COLUMN_HEADER"), Money.class, 0));
        columns.add(new Column(10, Locale.getString("PERCENT_RETURN"), Locale.getString("PERCENT_RETURN_COLUMN_HEADER"), ChangeFormat.class, 1));
        this.model = new Model(columns);
        this.setModel(this.model);
        this.model.addTableModelListener(this);
        this.propertySupport = new PropertyChangeSupport(this);
        this.addMenu();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GPResultModule.this.handleMouseClicked(evt);
            }
        });
        this.showColumns(this.model);
    }

    private void handleMouseClicked(MouseEvent event) {
        Point point = event.getPoint();
        if (event.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem popupOpenMenuItem = new JMenuItem(Locale.getString("OPEN"));
            popupOpenMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupOpenMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPResultModule.this.openSelectedResult();
                }
            });
            menu.add(popupOpenMenuItem);
            JMenuItem popupGraphMenuItem = new JMenuItem(Locale.getString("GRAPH"));
            popupGraphMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupGraphMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPResultModule.this.graphSelectedResult();
                }
            });
            menu.add(popupGraphMenuItem);
            JMenuItem popupTransactionsMenuItem = new JMenuItem(Locale.getString("TRANSACTIONS"));
            popupTransactionsMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupTransactionsMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPResultModule.this.transactionsSelectedResult();
                }
            });
            menu.add(popupTransactionsMenuItem);
            menu.addSeparator();
            JMenuItem popupViewBuyRuleMenuItem = new JMenuItem(Locale.getString("VIEW_BUY_RULE"));
            popupViewBuyRuleMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupViewBuyRuleMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPResultModule.this.viewBuyRule();
                }
            });
            menu.add(popupViewBuyRuleMenuItem);
            JMenuItem popupViewSellRuleMenuItem = new JMenuItem(Locale.getString("VIEW_SELL_RULE"));
            popupViewSellRuleMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupViewSellRuleMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPResultModule.this.viewSellRule();
                }
            });
            menu.add(popupViewSellRuleMenuItem);
            JMenuItem popupStoreBuyRuleMenuItem = new JMenuItem(Locale.getString("STORE_BUY_RULE"));
            popupStoreBuyRuleMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupStoreBuyRuleMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPResultModule.this.storeBuyRule();
                }
            });
            menu.add(popupStoreBuyRuleMenuItem);
            JMenuItem popupStoreSellRuleMenuItem = new JMenuItem(Locale.getString("STORE_SELL_RULE"));
            popupStoreSellRuleMenuItem.setEnabled(this.getSelectedRowCount() == 1);
            popupStoreSellRuleMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPResultModule.this.storeSellRule();
                }
            });
            menu.add(popupStoreSellRuleMenuItem);
            menu.addSeparator();
            JMenuItem popupStoreRulesInitialPopulation = new JMenuItem(Locale.getString("STORE_RULES_INIT_POP"));
            popupStoreRulesInitialPopulation.setEnabled(this.getSelectedRowCount() >= 1);
            popupStoreRulesInitialPopulation.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPResultModule.this.storeRulesInitialPopulation();
                }
            });
            menu.add(popupStoreRulesInitialPopulation);
            menu.addSeparator();
            JMenuItem popupRemoveMenuItem = new JMenuItem(Locale.getString("REMOVE"));
            popupRemoveMenuItem.setEnabled(this.getSelectedRowCount() >= 1);
            popupRemoveMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPResultModule.this.removeSelectedResults();
                    GPResultModule.this.checkMenuDisabledStatus();
                }
            });
            menu.add(popupRemoveMenuItem);
            JMenuItem popupRemoveAllMenuItem = new JMenuItem(Locale.getString("REMOVE_ALL"));
            popupRemoveAllMenuItem.setEnabled(this.model.getRowCount() > 0);
            popupRemoveAllMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GPResultModule.this.model.removeAllResults();
                    GPResultModule.this.checkMenuDisabledStatus();
                }
            });
            menu.add(popupRemoveAllMenuItem);
            menu.show(this, point.x, point.y);
        } else if (event.getButton() == 1 && event.getClickCount() == 2) {
            this.graphSelectedResult();
        }
    }

    private void graphSelectedResult() {
        int row = this.getSelectedRow();
        if (row != -1) {
            GPResult result = this.model.getResult(row);
            CommandManager.getInstance().graphPortfolio(result.getPortfolio(), result.getQuoteBundle(), result.getStartDate(), result.getEndDate());
        }
    }

    private void openSelectedResult() {
        int row = this.getSelectedRow();
        if (row != -1) {
            GPResult result = this.model.getResult(row);
            CommandManager.getInstance().openPortfolio(result.getPortfolio(), result.getQuoteBundle());
        }
    }

    private void transactionsSelectedResult() {
        int row = this.getSelectedRow();
        if (row != -1) {
            GPResult result = this.model.getResult(row);
            CommandManager.getInstance().tableTransactions(result.getPortfolio(), result.getQuoteBundle());
        }
    }

    private void viewBuyRule() {
        int row = this.getSelectedRow();
        if (row != -1) {
            final GPResult result = this.model.getResult(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    ExpressionEditorDialog.showViewDialog(Locale.getString("VIEW_BUY_RULE"), result.getBuyRule());
                }
            });
            thread2.start();
        }
    }

    private void viewSellRule() {
        int row = this.getSelectedRow();
        if (row != -1) {
            final GPResult result = this.model.getResult(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    ExpressionEditorDialog.showViewDialog(Locale.getString("VIEW_SELL_RULE"), result.getSellRule());
                }
            });
            thread2.start();
        }
    }

    private void storeBuyRule() {
        int row = this.getSelectedRow();
        if (row != -1) {
            final GPResult result = this.model.getResult(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    ExpressionEditorDialog.showAddDialog(Locale.getString("STORE_BUY_RULE"), result.getBuyRule());
                }
            });
            thread2.start();
        }
    }

    private void storeSellRule() {
        int row = this.getSelectedRow();
        if (row != -1) {
            final GPResult result = this.model.getResult(row);
            Thread thread2 = new Thread(new Runnable(){

                public void run() {
                    ExpressionEditorDialog.showAddDialog(Locale.getString("STORE_SELL_RULE"), result.getSellRule());
                }
            });
            thread2.start();
        }
    }

    private void storeRulesInitialPopulation() {
        int[] rows = this.getSelectedRows();
        if (rows.length >= 1) {
            for (int i = 0; i < rows.length; ++i) {
                GPResult result = this.model.getResult(rows[i]);
                this.GPPageInitialPopulation.addRowTable(result.getBuyRule(), result.getSellRule(), "");
            }
        }
    }

    private void removeSelectedResults() {
        int[] rows = this.getSelectedRows();
        ArrayList<Integer> rowIntegers = new ArrayList<Integer>();
        for (int i = 0; i < rows.length; ++i) {
            rowIntegers.add(new Integer(rows[i]));
        }
        ArrayList sortedRows = new ArrayList(rowIntegers);
        Collections.sort(sortedRows);
        Collections.reverse(sortedRows);
        List results = this.model.getResults();
        Iterator iterator = sortedRows.iterator();
        while (iterator.hasNext()) {
            Integer rowToRemove = (Integer)iterator.next();
            results.remove(rowToRemove);
        }
        this.model.setResults(results);
    }

    private void checkMenuDisabledStatus() {
        int numberOfSelectedRows = this.getSelectedRowCount();
        this.openMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.graphMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.viewBuyRuleMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.viewSellRuleMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.storeBuyRuleMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.storeSellRuleMenuItem.setEnabled(numberOfSelectedRows == 1);
        this.storeRulesInitialPopulation.setEnabled(numberOfSelectedRows >= 1);
        this.removeMenuItem.setEnabled(numberOfSelectedRows >= 1);
        this.removeAllMenuItem.setEnabled(this.model.getRowCount() > 0);
    }

    private void addMenu() {
        this.menuBar = new JMenuBar();
        JMenu resultMenu = MenuHelper.addMenu(this.menuBar, Locale.getString("RESULT"));
        this.openMenuItem = new JMenuItem(Locale.getString("OPEN"));
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPResultModule.this.openSelectedResult();
            }
        });
        resultMenu.add(this.openMenuItem);
        this.graphMenuItem = new JMenuItem(Locale.getString("GRAPH"));
        this.graphMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPResultModule.this.graphSelectedResult();
            }
        });
        resultMenu.add(this.graphMenuItem);
        this.transactionsMenuItem = new JMenuItem(Locale.getString("TRANSACTIONS"));
        this.transactionsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPResultModule.this.transactionsSelectedResult();
            }
        });
        resultMenu.add(this.transactionsMenuItem);
        resultMenu.addSeparator();
        this.viewBuyRuleMenuItem = new JMenuItem(Locale.getString("VIEW_BUY_RULE"));
        this.viewBuyRuleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPResultModule.this.viewBuyRule();
            }
        });
        resultMenu.add(this.viewBuyRuleMenuItem);
        this.viewSellRuleMenuItem = new JMenuItem(Locale.getString("VIEW_SELL_RULE"));
        this.viewSellRuleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPResultModule.this.viewSellRule();
            }
        });
        resultMenu.add(this.viewSellRuleMenuItem);
        this.storeBuyRuleMenuItem = new JMenuItem(Locale.getString("STORE_BUY_RULE"));
        this.storeBuyRuleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPResultModule.this.storeBuyRule();
            }
        });
        resultMenu.add(this.storeBuyRuleMenuItem);
        this.storeSellRuleMenuItem = new JMenuItem(Locale.getString("STORE_SELL_RULE"));
        this.storeSellRuleMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPResultModule.this.storeSellRule();
            }
        });
        resultMenu.add(this.storeSellRuleMenuItem);
        resultMenu.addSeparator();
        this.storeRulesInitialPopulation = new JMenuItem(Locale.getString("STORE_RULES_INIT_POP"));
        this.storeRulesInitialPopulation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPResultModule.this.storeRulesInitialPopulation();
            }
        });
        resultMenu.add(this.storeRulesInitialPopulation);
        resultMenu.addSeparator();
        this.removeMenuItem = new JMenuItem(Locale.getString("REMOVE"));
        this.removeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPResultModule.this.removeSelectedResults();
                GPResultModule.this.checkMenuDisabledStatus();
            }
        });
        resultMenu.add(this.removeMenuItem);
        this.removeAllMenuItem = new JMenuItem(Locale.getString("REMOVE_ALL"));
        this.removeAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPResultModule.this.model.removeAllResults();
                GPResultModule.this.checkMenuDisabledStatus();
            }
        });
        resultMenu.add(this.removeAllMenuItem);
        resultMenu.addSeparator();
        JMenu columnMenu = this.createShowColumnMenu(this.model);
        resultMenu.add(columnMenu);
        resultMenu.addSeparator();
        JMenuItem resultCloseMenuItem = new JMenuItem(Locale.getString("CLOSE"));
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GPResultModule.this.model.removeAllResults();
                GPResultModule.this.propertySupport.firePropertyChange("window close", 0, 1);
            }
        });
        resultMenu.add(resultCloseMenuItem);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GPResultModule.this.checkMenuDisabledStatus();
            }
        });
        this.checkMenuDisabledStatus();
    }

    public void addResults(List results) {
        this.model.addResults(results);
        this.checkMenuDisabledStatus();
        this.validate();
        this.repaint();
    }

    public void save() {
        this.model.removeAllResults();
    }

    public String getTitle() {
        return Locale.getString("GENETIC_PROGRAMME_RESULTS_TITLE");
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    private class Model
    extends AbstractTableModel {
        private List results;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Model(List columns) {
            super(columns);
            this.results = new ArrayList();
        }

        public GPResult getResult(int row) {
            return (GPResult)this.results.get(row);
        }

        public void removeAllResults() {
            this.results.clear();
            this.fireTableDataChanged();
        }

        public List getResults() {
            return this.results;
        }

        public void setResults(List results) {
            this.results = results;
            this.fireTableDataChanged();
        }

        public void addResults(List results) {
            this.results.addAll(results);
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.results.size();
        }

        public Object getValueAt(int row, int column) {
            if (row >= this.getRowCount()) {
                return "";
            }
            GPResult result = (GPResult)this.results.get(row);
            if (column == 0) {
                return result.getStartDate();
            }
            if (column == 1) {
                return result.getEndDate();
            }
            if (column == 2) {
                return result.getSymbols();
            }
            if (column == 3) {
                return result.getBuyRule();
            }
            if (column == 4) {
                return result.getSellRule();
            }
            if (column == 7) {
                return new Integer(result.getGeneration());
            }
            if (column == 5) {
                return result.getTradeCost();
            }
            if (column == 6) {
                return new Integer(result.getNumberTrades());
            }
            if (column == 9) {
                return result.getFinalCapital();
            }
            if (column == 8) {
                return result.getInitialCapital();
            }
            if (column == 10) {
                return new ChangeFormat(result.getInitialCapital(), result.getFinalCapital());
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return "";
        }

        static {
            $assertionsDisabled = !(class$org$mov$analyser$GPResultModule == null ? (class$org$mov$analyser$GPResultModule = GPResultModule.class$("org.mov.analyser.GPResultModule")) : class$org$mov$analyser$GPResultModule).desiredAssertionStatus();
        }
    }
}

