/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.mov.analyser.OrderComparator;
import org.mov.quote.QuoteBundle;

public class OrderCache {
    private QuoteBundle quoteBundle;
    private OrderComparator orderComparator;
    private HashMap dayOrders;

    public OrderCache(QuoteBundle quoteBundle, OrderComparator orderComparator) {
        this.quoteBundle = quoteBundle;
        this.orderComparator = orderComparator;
        this.dayOrders = new HashMap();
    }

    public List getTodaySymbols(int dateOffset) {
        Integer date = new Integer(dateOffset);
        List symbols = (List)this.dayOrders.get(date);
        if (symbols == null) {
            symbols = this.quoteBundle.getSymbols(dateOffset);
            this.orderComparator.setDateOffset(dateOffset);
            Collections.sort(symbols, this.orderComparator);
            this.dayOrders.put(date, symbols);
        }
        return symbols;
    }

    public boolean isOrdered() {
        return this.orderComparator.isOrdered();
    }
}

