/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.util.Comparator;
import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.Variables;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.Symbol;

public class OrderComparator
implements Comparator {
    public static final int NO_ORDER = 0;
    public static final int STOCK_SYMBOL = 1;
    public static final int DAY_VOLUME_DECREASING = 2;
    public static final int DAY_VOLUME_INCREASING = 3;
    public static final int DAY_LOW_DECREASING = 4;
    public static final int DAY_LOW_INCREASING = 5;
    public static final int DAY_HIGH_DECREASING = 6;
    public static final int DAY_HIGH_INCREASING = 7;
    public static final int DAY_OPEN_DECREASING = 8;
    public static final int DAY_OPEN_INCREASING = 9;
    public static final int DAY_CLOSE_DECREASING = 10;
    public static final int DAY_CLOSE_INCREASING = 11;
    public static final int CHANGE_DECREASING = 12;
    public static final int CHANGE_INCREASING = 13;
    public static final int EQUATION = 14;
    private QuoteBundle quoteBundle;
    private Expression orderByEquation;
    private int orderByKey;
    private int dateOffset = 0;
    private boolean isDateSet;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OrderComparator(QuoteBundle quoteBundle, int orderByKey) {
        this.quoteBundle = quoteBundle;
        this.orderByKey = orderByKey;
        if (!$assertionsDisabled && orderByKey >= 14) {
            throw new AssertionError();
        }
        this.isDateSet = false;
    }

    public OrderComparator(QuoteBundle quoteBundle, Expression orderByEquation) {
        this.quoteBundle = quoteBundle;
        this.orderByEquation = orderByEquation;
        this.orderByKey = 14;
        this.isDateSet = false;
    }

    public int getOrderByKey() {
        return this.orderByKey;
    }

    public boolean isOrdered() {
        return this.orderByKey == 0;
    }

    public void setDateOffset(int dateOffset) {
        this.dateOffset = dateOffset;
        this.isDateSet = true;
    }

    public int compare(Object object1, Object object2) {
        Symbol symbol1 = (Symbol)object1;
        Symbol symbol2 = (Symbol)object2;
        if (!$assertionsDisabled && !this.isDateSet) {
            throw new AssertionError();
        }
        try {
            switch (this.orderByKey) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return symbol1.compareTo(symbol2);
                }
                case 3: {
                    return this.compare(this.quoteBundle.getQuote(symbol1, 4, this.dateOffset), this.quoteBundle.getQuote(symbol2, 4, this.dateOffset));
                }
                case 2: {
                    return this.compare(this.quoteBundle.getQuote(symbol2, 4, this.dateOffset), this.quoteBundle.getQuote(symbol1, 4, this.dateOffset));
                }
                case 5: {
                    return this.compare(this.quoteBundle.getQuote(symbol1, 2, this.dateOffset), this.quoteBundle.getQuote(symbol2, 2, this.dateOffset));
                }
                case 4: {
                    return this.compare(this.quoteBundle.getQuote(symbol2, 2, this.dateOffset), this.quoteBundle.getQuote(symbol1, 2, this.dateOffset));
                }
                case 7: {
                    return this.compare(this.quoteBundle.getQuote(symbol1, 3, this.dateOffset), this.quoteBundle.getQuote(symbol2, 3, this.dateOffset));
                }
                case 6: {
                    return this.compare(this.quoteBundle.getQuote(symbol2, 3, this.dateOffset), this.quoteBundle.getQuote(symbol1, 3, this.dateOffset));
                }
                case 9: {
                    return this.compare(this.quoteBundle.getQuote(symbol1, 1, this.dateOffset), this.quoteBundle.getQuote(symbol2, 1, this.dateOffset));
                }
                case 8: {
                    return this.compare(this.quoteBundle.getQuote(symbol2, 1, this.dateOffset), this.quoteBundle.getQuote(symbol1, 1, this.dateOffset));
                }
                case 11: {
                    return this.compare(this.quoteBundle.getQuote(symbol1, 0, this.dateOffset), this.quoteBundle.getQuote(symbol2, 0, this.dateOffset));
                }
                case 10: {
                    return this.compare(this.quoteBundle.getQuote(symbol2, 0, this.dateOffset), this.quoteBundle.getQuote(symbol1, 0, this.dateOffset));
                }
                case 13: {
                    return this.compare(this.quoteBundle.getQuote(symbol1, 0, this.dateOffset) / this.quoteBundle.getQuote(symbol1, 1, this.dateOffset), this.quoteBundle.getQuote(symbol2, 0, this.dateOffset) / this.quoteBundle.getQuote(symbol2, 1, this.dateOffset));
                }
                case 12: {
                    return this.compare(this.quoteBundle.getQuote(symbol2, 0, this.dateOffset) / this.quoteBundle.getQuote(symbol2, 1, this.dateOffset), this.quoteBundle.getQuote(symbol1, 0, this.dateOffset) / this.quoteBundle.getQuote(symbol1, 1, this.dateOffset));
                }
                case 14: {
                    return this.compareByEquation(symbol1, symbol2);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }
        catch (MissingQuoteException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }
    }

    private int compareByEquation(Symbol symbol1, Symbol symbol2) {
        if (!$assertionsDisabled && this.orderByKey != 14) {
            throw new AssertionError();
        }
        try {
            double valueOne = this.orderByEquation.evaluate(new Variables(), this.quoteBundle, symbol1, this.dateOffset);
            double valueTwo = this.orderByEquation.evaluate(new Variables(), this.quoteBundle, symbol2, this.dateOffset);
            return this.compare(valueTwo, valueOne);
        }
        catch (EvaluationException e) {
            return 0;
        }
    }

    private int compare(double one, double two) {
        if (one < two) {
            return -1;
        }
        if (one > two) {
            return 1;
        }
        return 0;
    }

    static {
        $assertionsDisabled = !OrderComparator.class.desiredAssertionStatus();
    }
}

