/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mov.analyser.OrderCache;
import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.ExpressionFactory;
import org.mov.parser.Variables;
import org.mov.portfolio.CashAccount;
import org.mov.portfolio.Portfolio;
import org.mov.portfolio.ShareAccount;
import org.mov.portfolio.StockHolding;
import org.mov.portfolio.Transaction;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteCache;
import org.mov.quote.Symbol;
import org.mov.quote.WeekendDateException;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class PaperTrade {
    private static final String CASH_ACCOUNT_NAME;
    private static final String SHARE_ACCOUNT_NAME;
    public static final String format = "0.00000#";
    public static final DecimalFormat decimalFormat;
    public static final int STOCKS_PER_LINES = 1;
    private static String[] symbolStock;
    private static boolean[] buyRule;
    private static boolean[] sellRule;
    private static double[] buyValue;
    private static double[] sellValue;
    static final /* synthetic */ boolean $assertionsDisabled;

    private PaperTrade() {
    }

    private static void sell(Environment environment, Variables variables, StockHolding stockHolding, Money tradeCost, double sellPrice, int day) throws EvaluationException, MissingQuoteException {
        if (environment.cashAccount.getValue().isGreaterThanEqual(tradeCost)) {
            int shares = stockHolding.getShares();
            Symbol symbol = stockHolding.getSymbol();
            if (sellPrice == 0.0) {
                sellPrice = environment.quoteBundle.getQuote(symbol, 1, day);
            }
            if (sellPrice <= environment.quoteBundle.getQuote(symbol, 3, day)) {
                Money amount = new Money((double)shares * sellPrice);
                TradingDate date = environment.quoteBundle.offsetToDate(day);
                Transaction sell = Transaction.newReduce(date, amount, symbol, shares, tradeCost, environment.cashAccount, environment.shareAccount);
                environment.portfolio.addTransaction(sell);
            }
        }
    }

    private static boolean buy(Environment environment, Variables variables, Symbol symbol, Money amount, Money tradeCost, double buyPrice, int day) throws EvaluationException, MissingQuoteException {
        if (buyPrice == 0.0) {
            buyPrice = environment.quoteBundle.getQuote(symbol, 1, day);
        }
        if (buyPrice >= environment.quoteBundle.getQuote(symbol, 2, day)) {
            double sharePrice = buyPrice;
            int shares = (int)Math.floor(amount.doubleValue() / sharePrice);
            if (shares > 0) {
                amount = new Money(sharePrice * (double)shares);
                TradingDate date = environment.quoteBundle.offsetToDate(day);
                Transaction buy = Transaction.newAccumulate(date, amount, symbol, shares, tradeCost, environment.cashAccount, environment.shareAccount);
                environment.portfolio.addTransaction(buy);
                return true;
            }
        }
        return false;
    }

    private static void sellTrades(Environment environment, QuoteBundle quoteBundle, Variables variables, Expression sell, Expression buy, int dateOffset, Money tradeCost, List symbols, OrderCache orderCache) throws EvaluationException {
        ArrayList stockHoldings = new ArrayList(environment.shareAccount.getStockHoldings().values());
        Iterator iterator = stockHoldings.iterator();
        while (iterator.hasNext()) {
            StockHolding stockHolding = (StockHolding)iterator.next();
            Symbol symbol = stockHolding.getSymbol();
            if (orderCache.isOrdered()) {
                int order = symbols.indexOf(symbol);
                if (order == -1) continue;
                variables.setValue("order", order);
            }
            variables.setValue("held", PaperTrade.getHoldingTime(environment, stockHolding, dateOffset));
            try {
                if (buy.evaluate(variables, quoteBundle, symbol, dateOffset) >= 1.0 || !(sell.evaluate(variables, quoteBundle, symbol, dateOffset) >= 1.0)) continue;
                double tradeValueWanted = 0.0;
                if (environment.tradeValueSell.compareTo("open") != 0) {
                    Expression tradeValueSellExpression = ExpressionFactory.newExpression(environment.tradeValueSell);
                    tradeValueWanted = tradeValueSellExpression.evaluate(variables, environment.quoteBundle, symbol, dateOffset);
                }
                PaperTrade.sell(environment, variables, stockHolding, tradeCost, tradeValueWanted, dateOffset + 1);
            }
            catch (MissingQuoteException e) {}
        }
    }

    private static void buyTrades(Environment environment, QuoteBundle quoteBundle, Variables variables, Expression buy, int dateOffset, Money tradeCost, List symbols, OrderCache orderCache, Money stockValue) throws EvaluationException {
        variables.setValue("held", 0);
        Money cash = environment.cashAccount.getValue();
        if (stockValue.add(tradeCost.multiply(2)).isLessThanEqual(cash)) {
            int order = 0;
            Iterator iterator = symbols.iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                if (!environment.shareAccount.isHolding(symbol)) {
                    if (orderCache.isOrdered()) {
                        variables.setValue("order", order);
                    }
                    try {
                        if (buy.evaluate(variables, quoteBundle, symbol, dateOffset) >= 1.0) {
                            double tradeValueWanted = 0.0;
                            if (environment.tradeValueBuy.compareTo("open") != 0) {
                                Expression tradeValueBuyExpression = ExpressionFactory.newExpression(environment.tradeValueBuy);
                                tradeValueWanted = tradeValueBuyExpression.evaluate(variables, environment.quoteBundle, symbol, dateOffset);
                            }
                            if (PaperTrade.buy(environment, variables, symbol, stockValue, tradeCost, tradeValueWanted, dateOffset + 1)) {
                                cash = environment.cashAccount.getValue();
                                if (stockValue.add(tradeCost.multiply(2)).isGreaterThan(cash)) {
                                    break;
                                }
                            }
                        }
                    }
                    catch (MissingQuoteException e) {
                        // empty catch block
                    }
                }
                ++order;
            }
        }
    }

    private static int getHoldingTime(Environment environment, StockHolding stockHolding, int dateOffset) {
        try {
            return 1 - (QuoteCache.getInstance().dateToOffset(stockHolding.getDate()) - dateOffset);
        }
        catch (WeekendDateException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }
    }

    public static Portfolio paperTrade(String portfolioName, QuoteBundle quoteBundle, Variables variables, OrderCache orderCache, TradingDate startDate, TradingDate endDate, Expression buy, Expression sell, Money capital, Money stockValue, Money tradeCost, String tradeValueBuy, String tradeValueSell) throws EvaluationException {
        PaperTrade paperTrade;
        PaperTrade paperTrade2 = paperTrade = new PaperTrade();
        paperTrade2.getClass();
        Environment environment = paperTrade2.new Environment(quoteBundle, portfolioName, startDate, endDate, capital, tradeValueBuy, tradeValueSell);
        int dateOffset = environment.startDateOffset;
        if (orderCache.isOrdered() && !variables.contains("order")) {
            variables.add("order", 2, true);
        }
        if (!variables.contains("held")) {
            variables.add("held", 2, true);
        }
        while (dateOffset < environment.endDateOffset) {
            List symbols = orderCache.getTodaySymbols(dateOffset);
            PaperTrade.sellTrades(environment, quoteBundle, variables, sell, buy, dateOffset, tradeCost, symbols, orderCache);
            PaperTrade.buyTrades(environment, quoteBundle, variables, buy, dateOffset, tradeCost, symbols, orderCache, stockValue);
            ++dateOffset;
        }
        PaperTrade.setTip(environment, quoteBundle, variables, buy, sell, dateOffset, tradeCost, orderCache.getTodaySymbols(dateOffset), orderCache);
        return environment.portfolio;
    }

    public static Portfolio paperTrade(String portfolioName, QuoteBundle quoteBundle, Variables variables, OrderCache orderCache, TradingDate startDate, TradingDate endDate, Expression buy, Expression sell, Money capital, int numberStocks, Money tradeCost, String tradeValueBuy, String tradeValueSell) throws EvaluationException {
        PaperTrade paperTrade;
        PaperTrade paperTrade2 = paperTrade = new PaperTrade();
        paperTrade2.getClass();
        Environment environment = paperTrade2.new Environment(quoteBundle, portfolioName, startDate, endDate, capital, tradeValueBuy, tradeValueSell);
        int dateOffset = environment.startDateOffset;
        if (orderCache.isOrdered() && !variables.contains("order")) {
            variables.add("order", 2, true);
        }
        if (!variables.contains("held")) {
            variables.add("held", 2, true);
        }
        while (dateOffset < environment.endDateOffset) {
            List symbols = orderCache.getTodaySymbols(dateOffset);
            PaperTrade.sellTrades(environment, quoteBundle, variables, sell, buy, dateOffset, tradeCost, symbols, orderCache);
            try {
                Money portfolioValue = environment.portfolio.getValue(quoteBundle, dateOffset);
                Money stockValue = portfolioValue.divide(numberStocks).subtract(tradeCost.multiply(2));
                PaperTrade.buyTrades(environment, quoteBundle, variables, buy, dateOffset, tradeCost, symbols, orderCache, stockValue);
            }
            catch (MissingQuoteException e) {
                // empty catch block
            }
            ++dateOffset;
        }
        PaperTrade.setTip(environment, quoteBundle, variables, buy, sell, dateOffset, tradeCost, orderCache.getTodaySymbols(dateOffset), orderCache);
        return environment.portfolio;
    }

    private static void setTip(Environment environment, QuoteBundle quoteBundle, Variables variables, Expression buy, Expression sell, int dateOffset, Money tradeCost, List symbols, OrderCache orderCache) {
        symbolStock = new String[symbols.size()];
        buyRule = new boolean[symbols.size()];
        sellRule = new boolean[symbols.size()];
        buyValue = new double[symbols.size()];
        sellValue = new double[symbols.size()];
        PaperTrade.setSellTip(environment, quoteBundle, variables, sell, dateOffset, tradeCost, symbols, orderCache);
        PaperTrade.setBuyTip(environment, quoteBundle, variables, buy, dateOffset, tradeCost, symbols, orderCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setSellTip(Environment environment, QuoteBundle quoteBundle, Variables variables, Expression sell, int dateOffset, Money tradeCost, List symbols, OrderCache orderCache) {
        int order = 0;
        int index = 0;
        Iterator iterator = symbols.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (orderCache.isOrdered()) {
                order = symbols.indexOf(symbol);
                if (order == -1) continue;
                variables.setValue("order", order);
            }
            ArrayList stockHoldings = new ArrayList(environment.shareAccount.getStockHoldings().values());
            Iterator iteratorHolding = stockHoldings.iterator();
            while (iteratorHolding.hasNext()) {
                StockHolding stockHolding = (StockHolding)iteratorHolding.next();
                Symbol symbolHolding = stockHolding.getSymbol();
                if (symbolHolding.toString().compareTo(symbol.toString()) == 0) {
                    variables.setValue("held", PaperTrade.getHoldingTime(environment, stockHolding, dateOffset));
                    break;
                }
                variables.setValue("held", 0);
            }
            try {
                PaperTrade.sellRule[index] = sell.evaluate(variables, quoteBundle, symbol, dateOffset) >= 1.0;
                PaperTrade.sellValue[index] = 0.0;
                if (environment.tradeValueSell.compareTo("open") == 0) continue;
                Expression tradeValueSellExpression = ExpressionFactory.newExpression(environment.tradeValueSell);
                PaperTrade.sellValue[index] = tradeValueSellExpression.evaluate(variables, environment.quoteBundle, symbol, dateOffset);
            }
            catch (EvaluationException e) {}
            continue;
            finally {
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setBuyTip(Environment environment, QuoteBundle quoteBundle, Variables variables, Expression buy, int dateOffset, Money tradeCost, List symbols, OrderCache orderCache) {
        variables.setValue("held", 0);
        int order = 0;
        int index = 0;
        Iterator iterator = symbols.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            PaperTrade.symbolStock[index] = new String(symbol.get());
            if (orderCache.isOrdered()) {
                variables.setValue("order", order);
            }
            try {
                PaperTrade.buyRule[index] = buy.evaluate(variables, quoteBundle, symbol, dateOffset) >= 1.0;
                PaperTrade.buyValue[index] = 0.0;
                if (environment.tradeValueBuy.compareTo("open") != 0) {
                    Expression tradeValueBuyExpression = ExpressionFactory.newExpression(environment.tradeValueBuy);
                    PaperTrade.buyValue[index] = tradeValueBuyExpression.evaluate(variables, environment.quoteBundle, symbol, dateOffset);
                }
            }
            catch (EvaluationException e) {
            }
            finally {
                ++index;
            }
            ++order;
        }
    }

    public static String getTip() {
        int i;
        StringBuffer retValue = new StringBuffer();
        int found = 0;
        retValue.append(Locale.getString("BUY_STOCKS"));
        for (i = 0; i < symbolStock.length; ++i) {
            if (!buyRule[i]) continue;
            if (found % 1 == 0) {
                retValue.append("\n");
            } else {
                retValue.append(", ");
            }
            retValue.append(symbolStock[i]);
            if (buyValue[i] != 0.0) {
                retValue.append(" (@ " + decimalFormat.format(buyValue[i]) + ")");
            }
            ++found;
        }
        retValue.append("\n\n");
        found = 0;
        retValue.append(Locale.getString("SELL_STOCKS"));
        for (i = 0; i < symbolStock.length; ++i) {
            if (!sellRule[i]) continue;
            if (found % 1 == 0) {
                retValue.append("\n");
            } else {
                retValue.append(", ");
            }
            retValue.append(symbolStock[i]);
            if (sellValue[i] != 0.0) {
                retValue.append(" (@ " + decimalFormat.format(sellValue[i]) + ")");
            }
            ++found;
        }
        retValue.append("\n");
        return retValue.toString();
    }

    static {
        $assertionsDisabled = !PaperTrade.class.desiredAssertionStatus();
        CASH_ACCOUNT_NAME = Locale.getString("CASH_ACCOUNT");
        SHARE_ACCOUNT_NAME = Locale.getString("SHARE_ACCOUNT");
        decimalFormat = new DecimalFormat(format);
    }

    private class Environment {
        public QuoteCache quoteCache;
        public QuoteBundle quoteBundle;
        public Portfolio portfolio;
        public CashAccount cashAccount;
        public ShareAccount shareAccount;
        public int startDateOffset;
        public int endDateOffset;
        private String tradeValueBuy;
        private String tradeValueSell;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Environment(QuoteBundle quoteBundle, String portfolioName, TradingDate startDate, TradingDate endDate, Money capital, String tradeValueBuy, String tradeValueSell) {
            this.quoteBundle = quoteBundle;
            this.quoteCache = QuoteCache.getInstance();
            this.tradeValueBuy = tradeValueBuy;
            this.tradeValueSell = tradeValueSell;
            this.portfolio = new Portfolio(portfolioName, true);
            this.cashAccount = new CashAccount(CASH_ACCOUNT_NAME);
            this.shareAccount = new ShareAccount(SHARE_ACCOUNT_NAME);
            this.portfolio.addAccount(this.cashAccount);
            this.portfolio.addAccount(this.shareAccount);
            Transaction transaction = Transaction.newDeposit(startDate, capital, this.cashAccount);
            this.portfolio.addTransaction(transaction);
            try {
                this.startDateOffset = quoteBundle.dateToOffset(startDate);
                this.endDateOffset = quoteBundle.dateToOffset(endDate);
            }
            catch (WeekendDateException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                this.endDateOffset = 0;
                this.startDateOffset = 0;
            }
        }

        static {
            $assertionsDisabled = !(class$org$mov$analyser$PaperTrade == null ? (class$org$mov$analyser$PaperTrade = PaperTrade.class$("org.mov.analyser.PaperTrade")) : class$org$mov$analyser$PaperTrade).desiredAssertionStatus();
        }
    }
}

