/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.mov.analyser.OrderCache;
import org.mov.analyser.OrderComparator;
import org.mov.analyser.PaperTrade;
import org.mov.analyser.PaperTradeResult;
import org.mov.analyser.PaperTradeResultModule;
import org.mov.analyser.PortfolioPage;
import org.mov.analyser.QuoteRangePage;
import org.mov.analyser.RulesPage;
import org.mov.analyser.TradeValuePage;
import org.mov.main.CommandManager;
import org.mov.main.Module;
import org.mov.main.ModuleFrame;
import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.Variables;
import org.mov.portfolio.Portfolio;
import org.mov.quote.QuoteBundle;
import org.mov.quote.ScriptQuoteBundle;
import org.mov.ui.ProgressDialog;
import org.mov.ui.ProgressDialogManager;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class PaperTradeModule
extends JPanel
implements Module {
    private PropertyChangeSupport propertySupport;
    private JDesktopPane desktop;
    private ScriptQuoteBundle quoteBundle;
    private static ModuleFrame resultsFrame;
    private JTabbedPane tabbedPane;
    private QuoteRangePage quoteRangePage;
    private RulesPage rulesPage;
    private PortfolioPage portfolioPage;
    private TradeValuePage tradeValuePage;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PaperTradeModule(JDesktopPane desktop) {
        this.desktop = desktop;
        this.propertySupport = new PropertyChangeSupport(this);
        this.layoutPaperTrade();
        this.load();
    }

    private void layoutPaperTrade() {
        this.tabbedPane = new JTabbedPane();
        this.quoteRangePage = new QuoteRangePage(this.desktop);
        this.tabbedPane.addTab(this.quoteRangePage.getTitle(), this.quoteRangePage.getComponent());
        this.rulesPage = new RulesPage(this.desktop);
        this.tabbedPane.addTab(this.rulesPage.getTitle(), this.rulesPage.getComponent());
        this.portfolioPage = new PortfolioPage(this.desktop);
        this.tabbedPane.addTab(this.portfolioPage.getTitle(), this.portfolioPage.getComponent());
        this.tradeValuePage = new TradeValuePage(this.desktop);
        this.tabbedPane.addTab(this.tradeValuePage.getTitle(), this.tradeValuePage.getComponent());
        JPanel buttonPanel = new JPanel();
        JButton runButton = new JButton(Locale.getString("RUN"));
        runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PaperTradeModule.this.run();
            }
        });
        buttonPanel.add(runButton);
        JButton closeButton = new JButton(Locale.getString("CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PaperTradeModule.this.propertySupport.firePropertyChange("window close", 0, 1);
            }
        });
        buttonPanel.add(closeButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)buttonPanel, "South");
    }

    private void load() {
        this.quoteRangePage.load(this.getClass().getName());
        this.rulesPage.load(this.getClass().getName());
        this.portfolioPage.load(this.getClass().getName());
        this.tradeValuePage.load(this.getClass().getName());
    }

    public void save() {
        this.quoteRangePage.save(this.getClass().getName());
        this.rulesPage.save(this.getClass().getName());
        this.portfolioPage.save(this.getClass().getName());
        this.tradeValuePage.save(this.getClass().getName());
    }

    public String getTitle() {
        return Locale.getString("PAPER_TRADE");
    }

    public void addModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removeModuleChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImageIcon getFrameIcon() {
        return null;
    }

    public JComponent getComponent() {
        return this;
    }

    public JMenuBar getJMenuBar() {
        return null;
    }

    public boolean encloseInScrollPane() {
        return true;
    }

    private void run() {
        Thread thread2 = new Thread(new Runnable(){

            public void run() {
                List paperTradeResults;
                Thread thread2 = Thread.currentThread();
                PaperTradeModule.this.save();
                if (PaperTradeModule.this.parse() && (paperTradeResults = PaperTradeModule.this.getPaperTradeResults()) != null && !thread2.isInterrupted()) {
                    PaperTradeModule.this.display(paperTradeResults);
                }
            }
        });
        thread2.start();
    }

    private boolean parse() {
        if (!this.quoteRangePage.parse()) {
            this.tabbedPane.setSelectedComponent(this.quoteRangePage.getComponent());
            return false;
        }
        if (!this.rulesPage.parse()) {
            this.tabbedPane.setSelectedComponent(this.rulesPage.getComponent());
            return false;
        }
        if (!this.portfolioPage.parse()) {
            this.tabbedPane.setSelectedComponent(this.portfolioPage.getComponent());
            return false;
        }
        if (!this.tradeValuePage.parse()) {
            this.tabbedPane.setSelectedComponent(this.tradeValuePage.getComponent());
            return false;
        }
        return true;
    }

    private PaperTradeResult paperTrade(ProgressDialog progress, ScriptQuoteBundle quoteBundle, String quoteRangeDescription, OrderCache orderCache, TradingDate startDate, TradingDate endDate, Expression buyRule, Expression sellRule, Money initialCapital, int mode, Money stockValue, int numberStocks, Money tradeCost, Variables variables, int a, int b, int c, String tradeValueBuy, String tradeValueSell) throws EvaluationException {
        Portfolio portfolio;
        if (mode == 1) {
            portfolio = PaperTrade.paperTrade(Locale.getString("PAPER_TRADE_OF", quoteRangeDescription), (QuoteBundle)quoteBundle, variables, orderCache, startDate, endDate, buyRule, sellRule, initialCapital, stockValue, tradeCost, tradeValueBuy, tradeValueSell);
        } else {
            if (!$assertionsDisabled && this.portfolioPage.getMode() != 0) {
                throw new AssertionError();
            }
            portfolio = PaperTrade.paperTrade(Locale.getString("PAPER_TRADE_OF", quoteRangeDescription), (QuoteBundle)quoteBundle, variables, orderCache, startDate, endDate, buyRule, sellRule, initialCapital, numberStocks, tradeCost, tradeValueBuy, tradeValueSell);
        }
        progress.setNote(Locale.getString("PAPER_TRADING"));
        progress.increment();
        return new PaperTradeResult(portfolio, quoteBundle, initialCapital, tradeCost, ((Object)buyRule).toString(), ((Object)sellRule).toString(), a, b, c, startDate, endDate, PaperTrade.getTip());
    }

    private List getPaperTradeResults() {
        ProgressDialog progress = ProgressDialogManager.getProgressDialog();
        Thread thread2 = Thread.currentThread();
        progress.setIndeterminate(true);
        progress.show(Locale.getString("PAPER_TRADE"));
        boolean isFamilyEnabled = this.rulesPage.isFamilyEnabled();
        int aRange = this.rulesPage.getARange();
        int bRange = this.rulesPage.getBRange();
        int cRange = this.rulesPage.getCRange();
        TradingDate startDate = this.quoteRangePage.getQuoteRange().getFirstDate();
        TradingDate endDate = this.quoteRangePage.getQuoteRange().getLastDate();
        Expression buyRule = this.rulesPage.getBuyRule();
        Expression sellRule = this.rulesPage.getSellRule();
        Money initialCapital = this.portfolioPage.getInitialCapital();
        int mode = this.portfolioPage.getMode();
        Money stockValue = this.portfolioPage.getStockValue();
        int numberStocks = this.portfolioPage.getNumberStocks();
        Money tradeCost = this.portfolioPage.getTradeCost();
        this.quoteBundle = new ScriptQuoteBundle(this.quoteRangePage.getQuoteRange());
        OrderComparator orderComparator = this.quoteRangePage.getOrderComparator(this.quoteBundle);
        OrderCache orderCache = new OrderCache(this.quoteBundle, orderComparator);
        String quoteRangeDescription = this.quoteBundle.getQuoteRange().getDescription();
        int numberEquations = isFamilyEnabled ? aRange * bRange * cRange : 1;
        String tradeValueBuy = this.tradeValuePage.getTradeValueBuy();
        String tradeValueSell = this.tradeValuePage.getTradeValueSell();
        progress.setIndeterminate(false);
        progress.setMaximum(numberEquations);
        progress.setProgress(0);
        progress.setNote(Locale.getString("PAPER_TRADING"));
        progress.setMaster(true);
        ArrayList<PaperTradeResult> paperTradeResults = new ArrayList<PaperTradeResult>(numberEquations);
        long startTime = System.currentTimeMillis();
        try {
            Variables variables = new Variables();
            if (isFamilyEnabled) {
                variables.add("a", 2, true);
                variables.add("b", 2, true);
                variables.add("c", 2, true);
                for (int a = 1; a <= aRange && !thread2.isInterrupted(); ++a) {
                    variables.setValue("a", a);
                    for (int b = 1; b <= bRange && !thread2.isInterrupted(); ++b) {
                        variables.setValue("b", b);
                        for (int c = 1; c <= cRange && !thread2.isInterrupted(); ++c) {
                            variables.setValue("c", c);
                            paperTradeResults.add(this.paperTrade(progress, this.quoteBundle, quoteRangeDescription, orderCache, startDate, endDate, buyRule, sellRule, initialCapital, mode, stockValue, numberStocks, tradeCost, variables, a, b, c, tradeValueBuy, tradeValueSell));
                        }
                    }
                }
            } else if (!thread2.isInterrupted()) {
                paperTradeResults.add(this.paperTrade(progress, this.quoteBundle, quoteRangeDescription, orderCache, startDate, endDate, buyRule, sellRule, initialCapital, mode, stockValue, numberStocks, tradeCost, variables, 0, 0, 0, tradeValueBuy, tradeValueSell));
            }
        }
        catch (EvaluationException e) {
            ProgressDialogManager.closeProgressDialog(progress);
            progress = null;
            JOptionPane.showInternalMessageDialog(this.desktop, e.getReason(), Locale.getString("ERROR_EVALUATING_EQUATION"), 0);
            return null;
        }
        long endTime = System.currentTimeMillis();
        ProgressDialogManager.closeProgressDialog(progress);
        return paperTradeResults;
    }

    private void display(final List paperTradeResults) {
        SwingUtilities.invokeLater(new Runnable(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void run() {
                block4: {
                    if (resultsFrame == null || resultsFrame.isClosed()) {
                        resultsFrame = CommandManager.getInstance().newPaperTradeResultTable();
                    } else {
                        resultsFrame.toFront();
                        try {
                            resultsFrame.setIcon(false);
                            resultsFrame.setSelected(true);
                        }
                        catch (PropertyVetoException e) {
                            if ($assertionsDisabled) break block4;
                            throw new AssertionError();
                        }
                    }
                }
                PaperTradeResultModule resultsModule = (PaperTradeResultModule)resultsFrame.getModule();
                resultsModule.setDesktop(PaperTradeModule.this.desktop);
                resultsModule.addResults(paperTradeResults);
            }

            static {
                $assertionsDisabled = !(class$org$mov$analyser$PaperTradeModule == null ? (class$org$mov$analyser$PaperTradeModule = PaperTradeModule.class$("org.mov.analyser.PaperTradeModule")) : class$org$mov$analyser$PaperTradeModule).desiredAssertionStatus();
            }
        });
    }

    static {
        $assertionsDisabled = !PaperTradeModule.class.desiredAssertionStatus();
        resultsFrame = null;
    }
}

