/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.util.Iterator;
import java.util.List;
import org.mov.portfolio.Portfolio;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.ScriptQuoteBundle;
import org.mov.quote.Symbol;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class PaperTradeResult {
    private Portfolio portfolio;
    private ScriptQuoteBundle quoteBundle;
    private Money initialCapital;
    private Money tradeCost;
    private String buyRule;
    private String sellRule;
    private int a;
    private int b;
    private int c;
    private TradingDate startDate;
    private TradingDate endDate;
    private String tip;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PaperTradeResult(Portfolio portfolio, ScriptQuoteBundle quoteBundle, Money initialCapital, Money tradeCost, String buyRule, String sellRule, int a, int b, int c, TradingDate startDate, TradingDate endDate, String tip) {
        this.portfolio = portfolio;
        this.quoteBundle = quoteBundle;
        this.initialCapital = initialCapital;
        this.tradeCost = tradeCost;
        this.buyRule = buyRule;
        this.sellRule = sellRule;
        this.a = a;
        this.b = b;
        this.c = c;
        this.startDate = startDate;
        this.endDate = endDate;
        this.tip = tip;
    }

    public TradingDate getStartDate() {
        return this.startDate;
    }

    public TradingDate getEndDate() {
        return this.endDate;
    }

    public String getSymbols() {
        List symbolsTraded = this.getPortfolio().getSymbolsTraded();
        String string = new String();
        Iterator iterator = symbolsTraded.iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (string.length() > 0) {
                string = string.concat(", " + symbol.toString());
                continue;
            }
            string = symbol.toString();
        }
        return string;
    }

    public String getBuyRule() {
        return this.buyRule;
    }

    public String getSellRule() {
        return this.sellRule;
    }

    public int getA() {
        return this.a;
    }

    public int getB() {
        return this.b;
    }

    public int getC() {
        return this.c;
    }

    public Money getTradeCost() {
        return this.tradeCost;
    }

    public int getNumberTrades() {
        int accumulateTrades = this.getPortfolio().countTransactions(4);
        int reduceTrades = this.getPortfolio().countTransactions(5);
        return accumulateTrades + reduceTrades;
    }

    public Money getInitialCapital() {
        return this.initialCapital;
    }

    public Money getFinalCapital() {
        try {
            return this.portfolio.getValue((QuoteBundle)this.getQuoteBundle(), this.getEndDate());
        }
        catch (MissingQuoteException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return Money.ZERO;
        }
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public ScriptQuoteBundle getQuoteBundle() {
        return this.quoteBundle;
    }

    public String getTip() {
        return this.tip;
    }

    static {
        $assertionsDisabled = !PaperTradeResult.class.desiredAssertionStatus();
    }
}

