/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mov.analyser.AnalyserPage;
import org.mov.prefs.PreferencesManager;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;
import org.mov.util.Money;

public class PortfolioPage
extends JPanel
implements AnalyserPage {
    private JDesktopPane desktop;
    private JRadioButton numberStocksButton;
    private JTextField numberStocksTextField;
    private JRadioButton stockValueButton;
    private JTextField stockValueTextField;
    private JTextField initialCapitalTextField;
    private JTextField tradeCostTextField;
    private Money initialCapital;
    private Money tradeCost;
    private int mode;
    private int numberStocks;
    private Money stockValue;
    public static final int NUMBER_STOCKS_MODE = 0;
    public static final int STOCK_VALUE_MODE = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PortfolioPage(JDesktopPane desktop) {
        this.desktop = desktop;
        this.layoutPage();
    }

    public void load(String key) {
        HashMap settings = PreferencesManager.loadAnalyserPageSettings(key + this.getClass().getName());
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting = (String)iterator.next();
            String value = (String)settings.get(setting);
            if (setting.equals("number_stocks")) {
                this.numberStocksTextField.setText(value);
                continue;
            }
            if (setting.equals("stock_value")) {
                this.stockValueTextField.setText(value);
                continue;
            }
            if (setting.equals("mode")) {
                if (value.equals("number_stocks")) {
                    this.numberStocksButton.setSelected(true);
                    continue;
                }
                this.stockValueButton.setSelected(true);
                continue;
            }
            if (setting.equals("initial_capital")) {
                this.initialCapitalTextField.setText(value);
                continue;
            }
            if (!setting.equals("trade_cost")) continue;
            this.tradeCostTextField.setText(value);
        }
        this.checkDisabledStatus();
    }

    public void save(String key) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("mode", this.numberStocksButton.isSelected() ? "number_stocks" : "stock_value");
        settings.put("number_stocks", this.numberStocksTextField.getText());
        settings.put("stock_value", this.stockValueTextField.getText());
        settings.put("initial_capital", this.initialCapitalTextField.getText());
        settings.put("trade_cost", this.tradeCostTextField.getText());
        PreferencesManager.saveAnalyserPageSettings(key + this.getClass().getName(), settings);
    }

    public boolean parse() {
        this.numberStocks = 0;
        this.stockValue = Money.ZERO;
        this.initialCapital = Money.ZERO;
        this.tradeCost = Money.ZERO;
        if (this.numberStocksButton.isSelected()) {
            this.mode = 0;
        } else {
            if (!$assertionsDisabled && !this.stockValueButton.isSelected()) {
                throw new AssertionError();
            }
            this.mode = 1;
        }
        try {
            if (!this.stockValueTextField.getText().equals("")) {
                this.stockValue = new Money(Float.parseFloat(this.stockValueTextField.getText()));
            }
            if (!this.numberStocksTextField.getText().equals("")) {
                this.numberStocks = Integer.parseInt(this.numberStocksTextField.getText());
            }
            if (!this.initialCapitalTextField.getText().equals("")) {
                this.initialCapital = new Money(Float.parseFloat(this.initialCapitalTextField.getText()));
            }
            if (!this.tradeCostTextField.getText().equals("")) {
                this.tradeCost = new Money(Float.parseFloat(this.tradeCostTextField.getText()));
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_NUMBER", e.getMessage()), Locale.getString("INVALID_PORTFOLIO_ERROR"), 0);
            return false;
        }
        if (this.initialCapital.isLessThanEqual(Money.ZERO)) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_CAPITAL_ERROR"), Locale.getString("INVALID_PORTFOLIO_ERROR"), 0);
            return false;
        }
        if (this.mode == 0 && this.numberStocks <= 0) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("EMPTY_PORTFOLIO_ERROR"), Locale.getString("INVALID_PORTFOLIO_ERROR"), 0);
            return false;
        }
        if (this.mode == 1 && this.stockValue.isLessThanEqual(Money.ZERO)) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("STOCK_VALUE_ERROR"), Locale.getString("INVALID_PORTFOLIO_ERROR"), 0);
            return false;
        }
        if (this.tradeCost.isLessThan(Money.ZERO)) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("INVALID_TRADE_COST_ERROR"), Locale.getString("INVALID_PORTFOLIO_ERROR"), 0);
            return false;
        }
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return Locale.getString("PORTFOLIO_PAGE_TITLE");
    }

    public Money getInitialCapital() {
        return this.initialCapital;
    }

    public Money getTradeCost() {
        return this.tradeCost;
    }

    public int getMode() {
        if (!$assertionsDisabled && this.mode != 0 && this.mode != 1) {
            throw new AssertionError();
        }
        return this.mode;
    }

    public Money getStockValue() {
        if (this.mode == 1) {
            return this.stockValue;
        }
        return null;
    }

    public int getNumberStocks() {
        if (this.mode == 0) {
            return this.numberStocks;
        }
        return 0;
    }

    private void layoutPage() {
        this.setLayout(new BoxLayout(this, 1));
        TitledBorder portfolioTitled = new TitledBorder(Locale.getString("PORTFOLIO"));
        JPanel panel = new JPanel();
        panel.setBorder(portfolioTitled);
        panel.setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        innerPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.initialCapitalTextField = GridBagHelper.addTextRow(innerPanel, Locale.getString("INITIAL_CAPITAL"), "", gridbag, c, 10);
        this.tradeCostTextField = GridBagHelper.addTextRow(innerPanel, Locale.getString("TRADE_COST"), "", gridbag, c, 5);
        panel.add((Component)innerPanel, "North");
        this.add(panel);
        portfolioTitled = new TitledBorder(Locale.getString("HOW_MANY_STOCKS"));
        panel = new JPanel();
        panel.setBorder(portfolioTitled);
        panel.setLayout(new BorderLayout());
        innerPanel = new JPanel();
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        innerPanel.setLayout(gridbag);
        ButtonGroup buttonGroup = new ButtonGroup();
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.numberStocksButton = new JRadioButton(Locale.getString("NUMBER_OF_STOCKS"));
        this.numberStocksButton.setSelected(true);
        this.numberStocksButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PortfolioPage.this.checkDisabledStatus();
            }
        });
        buttonGroup.add(this.numberStocksButton);
        c.gridwidth = 1;
        gridbag.setConstraints(this.numberStocksButton, c);
        innerPanel.add(this.numberStocksButton);
        this.numberStocksTextField = new JTextField("", 5);
        c.gridwidth = 0;
        gridbag.setConstraints(this.numberStocksTextField, c);
        innerPanel.add(this.numberStocksTextField);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.stockValueButton = new JRadioButton(Locale.getString("STOCK_VALUE"));
        this.stockValueButton.setSelected(true);
        this.stockValueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PortfolioPage.this.checkDisabledStatus();
            }
        });
        buttonGroup.add(this.stockValueButton);
        c.gridwidth = 1;
        gridbag.setConstraints(this.stockValueButton, c);
        innerPanel.add(this.stockValueButton);
        this.stockValueTextField = new JTextField("", 10);
        c.gridwidth = 0;
        gridbag.setConstraints(this.stockValueTextField, c);
        innerPanel.add(this.stockValueTextField);
        panel.add((Component)innerPanel, "North");
        this.add(panel);
    }

    private void checkDisabledStatus() {
        this.numberStocksTextField.setEnabled(this.numberStocksButton.isSelected());
        this.stockValueTextField.setEnabled(this.stockValueButton.isSelected());
    }

    static {
        $assertionsDisabled = !PortfolioPage.class.desiredAssertionStatus();
    }
}

