/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mov.analyser.AnalyserPage;
import org.mov.analyser.OrderComparator;
import org.mov.parser.Expression;
import org.mov.parser.ExpressionException;
import org.mov.parser.Parser;
import org.mov.prefs.PreferencesManager;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteCache;
import org.mov.quote.QuoteRange;
import org.mov.quote.QuoteSourceManager;
import org.mov.quote.SymbolFormatException;
import org.mov.quote.WeekendDateException;
import org.mov.ui.EquationComboBox;
import org.mov.ui.GridBagHelper;
import org.mov.ui.SymbolListComboBox;
import org.mov.util.Locale;
import org.mov.util.TradingDate;
import org.mov.util.TradingDateFormatException;

public class QuoteRangePage
extends JPanel
implements AnalyserPage {
    public static final int NO_PERIOD = 0;
    public static final int ONE_WEEK = 1;
    public static final int TWO_WEEKS = 2;
    public static final int ONE_MONTH = 3;
    public static final int TWO_MONTHS = 4;
    public static final int THREE_MONTHS = 5;
    public static final int FOUR_MONTHS = 6;
    public static final int SIX_MONTHS = 7;
    public static final int ONE_YEAR = 8;
    public static final int TWO_YEARS = 9;
    public static final int THREE_YEARS = 10;
    public static final int FOUR_YEARS = 11;
    private JDesktopPane desktop;
    private boolean allowMultipleDateRanges;
    private JTextField startDateTextField;
    private JTextField endDateTextField;
    private SymbolListComboBox symbolListComboBox;
    private JRadioButton orderByKeyButton;
    private JRadioButton orderByEquationButton;
    private JComboBox orderByKeyComboBox;
    private EquationComboBox orderByEquationComboBox;
    private JCheckBox multipleDateRangesCheckBox;
    private JComboBox dateRangePeriodComboBox;
    private QuoteRange quoteRange;
    private Expression orderByEquation;
    private TradingDate startDate;
    private TradingDate endDate;
    private int dateRangePeriod;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QuoteRangePage(JDesktopPane desktop) {
        this(desktop, false);
    }

    public QuoteRangePage(JDesktopPane desktop, boolean allowMultipleDateRanges) {
        this.desktop = desktop;
        this.allowMultipleDateRanges = allowMultipleDateRanges;
        this.layoutPage();
    }

    public void load(String key) {
        HashMap settings = PreferencesManager.loadAnalyserPageSettings(key + this.getClass().getName());
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting = (String)iterator.next();
            String value = (String)settings.get(setting);
            if (setting.equals("start_date")) {
                this.startDateTextField.setText(value);
                continue;
            }
            if (setting.equals("end_date")) {
                this.endDateTextField.setText(value);
                continue;
            }
            if (setting.equals("symbols")) {
                this.symbolListComboBox.setText(value);
                continue;
            }
            if (setting.equals("by")) {
                if (value.equals("orderByKey")) {
                    this.orderByKeyButton.setSelected(true);
                    continue;
                }
                this.orderByEquationButton.setSelected(true);
                continue;
            }
            if (setting.equals("by_key")) {
                this.orderByKeyComboBox.setSelectedItem(value);
                continue;
            }
            if (setting.equals("by_equation")) {
                this.orderByEquationComboBox.setEquationText(value);
                continue;
            }
            if (setting.equals("is_multiple_date_ranges")) {
                if (!this.allowMultipleDateRanges) continue;
                this.multipleDateRangesCheckBox.setSelected(value.equals("1"));
                continue;
            }
            if (setting.equals("period")) {
                if (!this.allowMultipleDateRanges) continue;
                this.dateRangePeriodComboBox.setSelectedItem(value);
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        this.checkDisabledStatus();
    }

    public void save(String key) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("start_date", this.startDateTextField.getText());
        settings.put("end_date", this.endDateTextField.getText());
        settings.put("symbols", this.symbolListComboBox.getText());
        settings.put("by", this.orderByKeyButton.isSelected() ? "orderByKey" : "orderByEquation");
        settings.put("by_key", this.orderByKeyComboBox.getSelectedItem());
        settings.put("by_equation", this.orderByEquationComboBox.getEquationText());
        if (this.allowMultipleDateRanges) {
            settings.put("is_multiple_date_ranges", this.multipleDateRangesCheckBox.isSelected() ? "1" : "0");
            settings.put("period", this.dateRangePeriodComboBox.getSelectedItem());
        }
        PreferencesManager.saveAnalyserPageSettings(key + this.getClass().getName(), settings);
    }

    public boolean parse() {
        int offset;
        this.quoteRange = null;
        try {
            this.startDate = new TradingDate(this.startDateTextField.getText(), 1);
            this.endDate = new TradingDate(this.endDateTextField.getText(), 1);
        }
        catch (TradingDateFormatException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_DATE", e.getDate()), Locale.getString("INVALID_QUOTE_RANGE_ERROR"), 0);
            return false;
        }
        this.dateRangePeriod = 0;
        if (this.allowMultipleDateRanges && this.multipleDateRangesCheckBox.isSelected()) {
            this.dateRangePeriod = this.dateRangePeriodComboBox.getSelectedIndex();
        }
        if (this.startDate.after(this.endDate)) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("DATE_RANGE_ERROR"), Locale.getString("INVALID_QUOTE_RANGE_ERROR"), 0);
            return false;
        }
        if (!QuoteSourceManager.getSource().containsDate(this.startDate)) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_QUOTES_DATE", this.startDateTextField.getText()), Locale.getString("INVALID_QUOTE_RANGE_ERROR"), 0);
            return false;
        }
        if (!QuoteSourceManager.getSource().containsDate(this.endDate)) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("NO_QUOTES_DATE", this.endDateTextField.getText()), Locale.getString("INVALID_QUOTE_RANGE_ERROR"), 0);
            return false;
        }
        try {
            offset = QuoteCache.getInstance().dateToOffset(this.startDate);
        }
        catch (WeekendDateException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("DATE_ON_WEEKEND", this.startDateTextField.getText()), Locale.getString("INVALID_QUOTE_RANGE_ERROR"), 0);
            return false;
        }
        try {
            offset = QuoteCache.getInstance().dateToOffset(this.endDate);
        }
        catch (WeekendDateException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("DATE_ON_WEEKEND", this.endDateTextField.getText()), Locale.getString("INVALID_QUOTE_RANGE_ERROR"), 0);
            return false;
        }
        try {
            this.quoteRange = this.symbolListComboBox.getQuoteRange();
        }
        catch (SymbolFormatException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, e.getMessage(), Locale.getString("INVALID_QUOTE_RANGE_ERROR"), 0);
            return false;
        }
        if (this.orderByEquationButton.isSelected()) {
            try {
                this.orderByEquation = Parser.parse(this.orderByEquationComboBox.getEquationText());
            }
            catch (ExpressionException e) {
                JOptionPane.showInternalMessageDialog(this.desktop, e.getReason(), Locale.getString("ERROR_PARSING_EQUATION"), 0);
                return false;
            }
        }
        this.quoteRange.setFirstDate(this.startDate);
        this.quoteRange.setLastDate(this.endDate);
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return Locale.getString("QUOTE_RANGE_PAGE_TITLE");
    }

    public QuoteRange getQuoteRange() {
        return this.quoteRange;
    }

    public TradingDate getStartDate() {
        return this.startDate;
    }

    public TradingDate getEndDate() {
        return this.endDate;
    }

    public int getDateRangePeriod() {
        if (!$assertionsDisabled && !this.allowMultipleDateRanges) {
            throw new AssertionError();
        }
        return this.dateRangePeriod;
    }

    public OrderComparator getOrderComparator(QuoteBundle quoteBundle) {
        if (this.orderByKeyButton.isSelected()) {
            return new OrderComparator(quoteBundle, this.orderByKeyComboBox.getSelectedIndex());
        }
        if (!$assertionsDisabled && !this.orderByEquationButton.isSelected()) {
            throw new AssertionError();
        }
        return new OrderComparator(quoteBundle, this.orderByEquation);
    }

    private void layoutPage() {
        this.setLayout(new BoxLayout(this, 1));
        TitledBorder dateTitled = new TitledBorder(Locale.getString("DATE_RANGE"));
        JPanel panel = new JPanel();
        panel.setBorder(dateTitled);
        panel.setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        innerPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.startDateTextField = GridBagHelper.addTextRow(innerPanel, Locale.getString("START_DATE"), "", gridbag, c, 15);
        this.endDateTextField = GridBagHelper.addTextRow(innerPanel, Locale.getString("END_DATE"), "", gridbag, c, 15);
        panel.add((Component)innerPanel, "North");
        this.add(panel);
        if (this.allowMultipleDateRanges) {
            dateTitled = new TitledBorder(Locale.getString("MULTIPLE_DATE_RANGES"));
            panel = new JPanel();
            panel.setBorder(dateTitled);
            panel.setLayout(new BorderLayout());
            innerPanel = new JPanel();
            gridbag = new GridBagLayout();
            c = new GridBagConstraints();
            innerPanel.setLayout(gridbag);
            c.weightx = 1.0;
            c.ipadx = 5;
            c.anchor = 17;
            c.fill = 2;
            this.multipleDateRangesCheckBox = GridBagHelper.addCheckBoxRow(innerPanel, Locale.getString("ENABLE_MULTIPLE_DATE_RANGES"), false, gridbag, c);
            this.multipleDateRangesCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    QuoteRangePage.this.checkDisabledStatus();
                }
            });
            JLabel label = new JLabel(Locale.getString("PERIOD"));
            c.gridwidth = 1;
            gridbag.setConstraints(label, c);
            innerPanel.add(label);
            this.dateRangePeriodComboBox = new JComboBox();
            this.dateRangePeriodComboBox.addItem(Locale.getString("ONE_WEEK"));
            this.dateRangePeriodComboBox.addItem(Locale.getString("TWO_WEEKS"));
            this.dateRangePeriodComboBox.addItem(Locale.getString("ONE_MONTH"));
            this.dateRangePeriodComboBox.addItem(Locale.getString("TWO_MONTHS"));
            this.dateRangePeriodComboBox.addItem(Locale.getString("THREE_MONTHS"));
            this.dateRangePeriodComboBox.addItem(Locale.getString("FOUR_MONTHS"));
            this.dateRangePeriodComboBox.addItem(Locale.getString("SIX_MONTHS"));
            this.dateRangePeriodComboBox.addItem(Locale.getString("ONE_YEAR"));
            this.dateRangePeriodComboBox.addItem(Locale.getString("TWO_YEARS"));
            this.dateRangePeriodComboBox.addItem(Locale.getString("THREE_YEARS"));
            this.dateRangePeriodComboBox.addItem(Locale.getString("FOUR_YEARS"));
            c.gridwidth = 0;
            gridbag.setConstraints(this.dateRangePeriodComboBox, c);
            innerPanel.add(this.dateRangePeriodComboBox);
            panel.add((Component)innerPanel, "North");
            this.add(panel);
        }
        TitledBorder symbolTitled = new TitledBorder(Locale.getString("SYMBOLS"));
        panel = new JPanel();
        panel.setBorder(symbolTitled);
        panel.setLayout(new BorderLayout());
        innerPanel = new JPanel();
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        innerPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        c.fill = 2;
        this.symbolListComboBox = GridBagHelper.addSymbolListComboBox(innerPanel, Locale.getString("SYMBOLS"), "", gridbag, c);
        panel.add((Component)innerPanel, "North");
        this.add(panel);
        TitledBorder orderTitled = new TitledBorder(Locale.getString("ORDER_SYMBOLS"));
        panel = new JPanel();
        panel.setBorder(orderTitled);
        panel.setLayout(new BorderLayout());
        innerPanel = new JPanel();
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        innerPanel.setLayout(gridbag);
        ButtonGroup buttonGroup = new ButtonGroup();
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        c.fill = 2;
        this.orderByKeyButton = new JRadioButton(Locale.getString("BY"));
        this.orderByKeyButton.setSelected(true);
        this.orderByKeyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuoteRangePage.this.checkDisabledStatus();
            }
        });
        buttonGroup.add(this.orderByKeyButton);
        c.gridwidth = 1;
        gridbag.setConstraints(this.orderByKeyButton, c);
        innerPanel.add(this.orderByKeyButton);
        this.orderByKeyComboBox = new JComboBox();
        this.orderByKeyComboBox.addItem(Locale.getString("UNORDERED"));
        this.orderByKeyComboBox.addItem(Locale.getString("SYMBOL"));
        this.orderByKeyComboBox.addItem(Locale.getString("VOLUME_DECREASING"));
        this.orderByKeyComboBox.addItem(Locale.getString("VOLUME_INCREASING"));
        this.orderByKeyComboBox.addItem(Locale.getString("DAY_LOW_DECREASING"));
        this.orderByKeyComboBox.addItem(Locale.getString("DAY_LOW_INCREASING"));
        this.orderByKeyComboBox.addItem(Locale.getString("DAY_HIGH_DECREASING"));
        this.orderByKeyComboBox.addItem(Locale.getString("DAY_HIGH_INCREASING"));
        this.orderByKeyComboBox.addItem(Locale.getString("DAY_OPEN_DECREASING"));
        this.orderByKeyComboBox.addItem(Locale.getString("DAY_OPEN_INCREASING"));
        this.orderByKeyComboBox.addItem(Locale.getString("DAY_CLOSE_DECREASING"));
        this.orderByKeyComboBox.addItem(Locale.getString("DAY_CLOSE_INCREASING"));
        this.orderByKeyComboBox.addItem(Locale.getString("CHANGE_DECREASING"));
        this.orderByKeyComboBox.addItem(Locale.getString("CHANGE_INCREASING"));
        c.gridwidth = 0;
        gridbag.setConstraints(this.orderByKeyComboBox, c);
        innerPanel.add(this.orderByKeyComboBox);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.orderByEquationButton = new JRadioButton(Locale.getString("BY_EQUATION"));
        this.orderByEquationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuoteRangePage.this.checkDisabledStatus();
            }
        });
        buttonGroup.add(this.orderByEquationButton);
        c.gridwidth = 1;
        gridbag.setConstraints(this.orderByEquationButton, c);
        innerPanel.add(this.orderByEquationButton);
        this.orderByEquationComboBox = new EquationComboBox();
        c.gridwidth = 0;
        gridbag.setConstraints(this.orderByEquationComboBox, c);
        innerPanel.add(this.orderByEquationComboBox);
        panel.add((Component)innerPanel, "North");
        this.add(panel);
    }

    private void checkDisabledStatus() {
        this.orderByKeyComboBox.setEnabled(this.orderByKeyButton.isSelected());
        this.orderByEquationComboBox.setEnabled(this.orderByEquationButton.isSelected());
        if (this.allowMultipleDateRanges) {
            this.dateRangePeriodComboBox.setEnabled(this.multipleDateRangesCheckBox.isSelected());
        }
    }

    static {
        $assertionsDisabled = !QuoteRangePage.class.desiredAssertionStatus();
    }
}

