/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mov.analyser.AnalyserPage;
import org.mov.parser.Expression;
import org.mov.parser.ExpressionException;
import org.mov.parser.Parser;
import org.mov.parser.Variables;
import org.mov.prefs.PreferencesManager;
import org.mov.ui.EquationComboBox;
import org.mov.ui.GridBagHelper;
import org.mov.util.Locale;

public class RulesPage
extends JPanel
implements AnalyserPage {
    private JDesktopPane desktop;
    private JCheckBox ruleFamilyEnabledCheckBox;
    private EquationComboBox buyRuleEquationComboBox;
    private EquationComboBox sellRuleEquationComboBox;
    private JTextField aRangeTextField;
    private JTextField bRangeTextField;
    private JTextField cRangeTextField;
    private Expression buyRule;
    private Expression sellRule;
    private boolean isFamilyEnabled;
    private int aRange;
    private int bRange;
    private int cRange;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RulesPage(JDesktopPane desktop) {
        this.desktop = desktop;
        this.layoutPage();
    }

    public void load(String key) {
        HashMap settings = PreferencesManager.loadAnalyserPageSettings(key + this.getClass().getName());
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting = (String)iterator.next();
            String value = (String)settings.get(setting);
            if (setting.equals("buy_rule")) {
                this.buyRuleEquationComboBox.setEquationText(value);
                continue;
            }
            if (setting.equals("is_rule_family")) {
                this.ruleFamilyEnabledCheckBox.setSelected(value.equals("1"));
                continue;
            }
            if (setting.equals("sell_rule")) {
                this.sellRuleEquationComboBox.setEquationText(value);
                continue;
            }
            if (setting.equals("arange")) {
                this.aRangeTextField.setText(value);
                continue;
            }
            if (setting.equals("brange")) {
                this.bRangeTextField.setText(value);
                continue;
            }
            if (setting.equals("crange")) {
                this.cRangeTextField.setText(value);
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        this.checkDisabledStatus();
    }

    public void save(String key) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("buy_rule", this.buyRuleEquationComboBox.getEquationText());
        settings.put("sell_rule", this.sellRuleEquationComboBox.getEquationText());
        settings.put("is_rule_family", this.ruleFamilyEnabledCheckBox.isSelected() ? "1" : "0");
        settings.put("arange", this.aRangeTextField.getText());
        settings.put("brange", this.bRangeTextField.getText());
        settings.put("crange", this.cRangeTextField.getText());
        PreferencesManager.saveAnalyserPageSettings(key + this.getClass().getName(), settings);
    }

    public boolean parse() {
        Variables tmpVar;
        Variables variables = new Variables();
        this.isFamilyEnabled = this.ruleFamilyEnabledCheckBox.isSelected();
        String buyRuleString = this.buyRuleEquationComboBox.getEquationText();
        String sellRuleString = this.sellRuleEquationComboBox.getEquationText();
        if (this.isFamilyEnabled) {
            variables.add("a", 2, true);
            variables.add("b", 2, true);
            variables.add("c", 2, true);
        }
        variables.add("held", 2, true);
        variables.add("order", 2, true);
        if (buyRuleString.length() == 0) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("MISSING_BUY_RULE"), Locale.getString("ERROR_PARSING_RULES"), 0);
            return false;
        }
        if (sellRuleString.length() == 0) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("MISSING_SELL_RULE"), Locale.getString("ERROR_PARSING_RULES"), 0);
            return false;
        }
        try {
            tmpVar = null;
            try {
                tmpVar = (Variables)variables.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            this.buyRule = Parser.parse(tmpVar, buyRuleString);
        }
        catch (ExpressionException e) {
            this.buyRule = null;
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_BUY_RULE", e.getReason()), Locale.getString("ERROR_PARSING_RULES"), 0);
            return false;
        }
        try {
            tmpVar = null;
            try {
                tmpVar = (Variables)variables.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            this.sellRule = Parser.parse(tmpVar, sellRuleString);
        }
        catch (ExpressionException e) {
            this.sellRule = null;
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_SELL_RULE", e.getReason()), Locale.getString("ERROR_PARSING_RULES"), 0);
            return false;
        }
        this.cRange = 0;
        this.bRange = 0;
        this.aRange = 0;
        try {
            if (!this.aRangeTextField.getText().equals("")) {
                this.aRange = Integer.parseInt(this.aRangeTextField.getText());
            }
            if (!this.bRangeTextField.getText().equals("")) {
                this.bRange = Integer.parseInt(this.bRangeTextField.getText());
            }
            if (!this.cRangeTextField.getText().equals("")) {
                this.cRange = Integer.parseInt(this.cRangeTextField.getText());
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_NUMBER", e.getMessage()), Locale.getString("ERROR_PARSING_RULES"), 0);
            return false;
        }
        if (this.aRange <= 0) {
            this.aRange = 1;
        }
        if (this.bRange <= 0) {
            this.bRange = 1;
        }
        if (this.cRange <= 0) {
            this.cRange = 1;
        }
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return Locale.getString("RULES_PAGE_TITLE");
    }

    public Expression getBuyRule() {
        return this.buyRule;
    }

    public Expression getSellRule() {
        return this.sellRule;
    }

    public int getARange() {
        return this.aRange;
    }

    public int getBRange() {
        return this.bRange;
    }

    public int getCRange() {
        return this.cRange;
    }

    public boolean isFamilyEnabled() {
        return this.isFamilyEnabled;
    }

    private void layoutPage() {
        this.setLayout(new BoxLayout(this, 1));
        TitledBorder equationTitled = new TitledBorder(Locale.getString("RULES_PAGE_TITLE"));
        JPanel panel = new JPanel();
        panel.setBorder(equationTitled);
        panel.setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        innerPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        c.fill = 2;
        this.buyRuleEquationComboBox = GridBagHelper.addEquationRow(innerPanel, Locale.getString("BUY_RULE"), "", gridbag, c);
        this.sellRuleEquationComboBox = GridBagHelper.addEquationRow(innerPanel, Locale.getString("SELL_RULE"), "", gridbag, c);
        panel.add((Component)innerPanel, "North");
        this.add(panel);
        TitledBorder ruleFamilyTitled = new TitledBorder(Locale.getString("RULE_FAMILY"));
        panel = new JPanel();
        panel.setBorder(ruleFamilyTitled);
        panel.setLayout(new BorderLayout());
        innerPanel = new JPanel();
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        innerPanel.setLayout(gridbag);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.ruleFamilyEnabledCheckBox = GridBagHelper.addCheckBoxRow(innerPanel, Locale.getString("ENABLE_MULTIPLE_RULES"), false, gridbag, c);
        this.ruleFamilyEnabledCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RulesPage.this.checkDisabledStatus();
            }
        });
        this.aRangeTextField = GridBagHelper.addTextRow(innerPanel, Locale.getString("RANGE_A_1_TO"), "", gridbag, c, 3);
        this.bRangeTextField = GridBagHelper.addTextRow(innerPanel, Locale.getString("RANGE_B_1_TO"), "", gridbag, c, 3);
        this.cRangeTextField = GridBagHelper.addTextRow(innerPanel, Locale.getString("RANGE_C_1_TO"), "", gridbag, c, 3);
        panel.add((Component)innerPanel, "North");
        this.add(panel);
    }

    private void checkDisabledStatus() {
        boolean isRuleFamilyEnabled = this.ruleFamilyEnabledCheckBox.isSelected();
        this.aRangeTextField.setEnabled(isRuleFamilyEnabled);
        this.bRangeTextField.setEnabled(isRuleFamilyEnabled);
        this.cRangeTextField.setEnabled(isRuleFamilyEnabled);
    }

    static {
        $assertionsDisabled = !RulesPage.class.desiredAssertionStatus();
    }
}

