/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mov.analyser.AnalyserPage;
import org.mov.parser.Expression;
import org.mov.parser.ExpressionException;
import org.mov.parser.Parser;
import org.mov.parser.Variables;
import org.mov.prefs.PreferencesManager;
import org.mov.util.Locale;

public class TradeValuePage
extends JPanel
implements AnalyserPage {
    private static final int MAX_CHARS_IN_TEXTBOXES = 15;
    private JDesktopPane desktop;
    private ButtonGroup tradeValueBuyButtonGroup;
    private JRadioButton tradeValueBuyByKeyButton;
    private JRadioButton tradeValueBuyByEquationButton;
    private JComboBox tradeValueBuyComboBox;
    private JTextField tradeValueBuyTextField;
    private ButtonGroup tradeValueSellButtonGroup;
    private JRadioButton tradeValueSellByKeyButton;
    private JRadioButton tradeValueSellByEquationButton;
    private JComboBox tradeValueSellComboBox;
    private JTextField tradeValueSellTextField;

    public TradeValuePage(JDesktopPane desktop) {
        this.desktop = desktop;
        this.setGraphic();
    }

    public void load(String key) {
        HashMap settings = PreferencesManager.loadAnalyserPageSettings(key + this.getClass().getName());
        Iterator iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String setting = (String)iterator.next();
            String value = (String)settings.get(setting);
            if (setting.equals("trade_value_buy_text_field")) {
                this.tradeValueBuyTextField.setText(value);
            } else if (setting.equals("trade_value_buy_combo")) {
                this.tradeValueBuyComboBox.setSelectedItem(value);
            } else if (setting.equals("trade_value_buy")) {
                if (value.equals("byKey")) {
                    this.tradeValueBuyByKeyButton.setSelected(true);
                } else {
                    this.tradeValueBuyByEquationButton.setSelected(true);
                }
            }
            if (setting.equals("trade_value_sell_text_field")) {
                this.tradeValueSellTextField.setText(value);
                continue;
            }
            if (setting.equals("trade_value_sell_combo")) {
                this.tradeValueSellComboBox.setSelectedItem(value);
                continue;
            }
            if (!setting.equals("trade_value_sell")) continue;
            if (value.equals("byKey")) {
                this.tradeValueSellByKeyButton.setSelected(true);
                continue;
            }
            this.tradeValueSellByEquationButton.setSelected(true);
        }
    }

    public void save(String key) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("trade_value_buy", this.tradeValueBuyByKeyButton.isSelected() ? "byKey" : "byEquation");
        settings.put("trade_value_buy_combo", this.tradeValueBuyComboBox.getSelectedItem());
        settings.put("trade_value_buy_text_field", this.tradeValueBuyTextField.getText());
        settings.put("trade_value_sell", this.tradeValueSellByKeyButton.isSelected() ? "byKey" : "byEquation");
        settings.put("trade_value_sell_combo", this.tradeValueSellComboBox.getSelectedItem());
        settings.put("trade_value_sell_text_field", this.tradeValueSellTextField.getText());
        PreferencesManager.saveAnalyserPageSettings(key + this.getClass().getName(), settings);
    }

    public boolean parse() {
        try {
            Variables variables = new Variables();
            variables.add("held", 2, true);
            variables.add("order", 2, true);
            if (this.tradeValueBuyByEquationButton.isSelected()) {
                Expression tradeValueBuyExpression = Parser.parse(variables, this.tradeValueBuyTextField.getText());
            }
            if (this.tradeValueSellByEquationButton.isSelected()) {
                Expression expression = Parser.parse(variables, this.tradeValueSellTextField.getText());
            }
        }
        catch (ExpressionException e) {
            JOptionPane.showInternalMessageDialog(this.desktop, Locale.getString("ERROR_PARSING_SYSTEM_RULES"), Locale.getString("INVALID_BUY_SELL_SYSTEM_ERROR"), 0);
            return false;
        }
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        return Locale.getString("TRADE_VALUE_PAGE_SHORT_TITLE");
    }

    public String getTradeValueBuy() {
        JRadioButton generalTradeValueByKeyButton = this.tradeValueBuyByKeyButton;
        JComboBox generalTradeValueComboBox = this.tradeValueBuyComboBox;
        JTextField generalTradeValueTextField = this.tradeValueBuyTextField;
        return this.getTradeValue(generalTradeValueByKeyButton, generalTradeValueComboBox, generalTradeValueTextField);
    }

    public String getTradeValueSell() {
        JRadioButton generalTradeValueByKeyButton = this.tradeValueSellByKeyButton;
        JComboBox generalTradeValueComboBox = this.tradeValueSellComboBox;
        JTextField generalTradeValueTextField = this.tradeValueSellTextField;
        return this.getTradeValue(generalTradeValueByKeyButton, generalTradeValueComboBox, generalTradeValueTextField);
    }

    private String getTradeValue(JRadioButton radio, JComboBox combo, JTextField text) {
        String retValue = "open";
        if (radio.isSelected()) {
            if (combo.getSelectedIndex() == 0) {
                retValue = "open";
            } else if (combo.getSelectedIndex() == 1) {
                retValue = "close";
            } else if (combo.getSelectedIndex() == 2) {
                retValue = "(low+high)/2.0";
            } else if (combo.getSelectedIndex() == 3) {
                retValue = "(open+close)/2.0";
            } else if (combo.getSelectedIndex() == 4) {
                retValue = "low";
            } else if (combo.getSelectedIndex() == 5) {
                retValue = "high";
            }
        } else {
            retValue = text.getText();
        }
        return retValue;
    }

    private void setGraphic() {
        this.setLayout(new BoxLayout(this, 1));
        TitledBorder dateTitled = new TitledBorder(Locale.getString("TRADE_VALUE_PAGE_TITLE"));
        JPanel panel = new JPanel();
        panel.setBorder(dateTitled);
        panel.setLayout(new BoxLayout(panel, 1));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        TitledBorder dateTitledBuy = new TitledBorder(Locale.getString("BUY_TRADE_COST"));
        JPanel panelBuy = new JPanel();
        panelBuy.setBorder(dateTitledBuy);
        panelBuy.setLayout(new BorderLayout());
        JPanel innerPanelBuy = new JPanel();
        innerPanelBuy.setLayout(gridbag);
        this.tradeValueBuyButtonGroup = new ButtonGroup();
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        c.fill = 2;
        this.tradeValueBuyByKeyButton = new JRadioButton(Locale.getString("BY"));
        this.tradeValueBuyByKeyButton.setSelected(true);
        this.tradeValueBuyButtonGroup.add(this.tradeValueBuyByKeyButton);
        c.gridwidth = 1;
        gridbag.setConstraints(this.tradeValueBuyByKeyButton, c);
        innerPanelBuy.add(this.tradeValueBuyByKeyButton);
        this.tradeValueBuyComboBox = new JComboBox();
        this.tradeValueBuyComboBox.addItem(Locale.getString("TOMORROW_OPEN"));
        this.tradeValueBuyComboBox.addItem(Locale.getString("TODAY_CLOSE"));
        this.tradeValueBuyComboBox.addItem(Locale.getString("TODAY_MIN_MAX_AVG"));
        this.tradeValueBuyComboBox.addItem(Locale.getString("TODAY_OPEN_CLOSE_AVG"));
        this.tradeValueBuyComboBox.addItem(Locale.getString("TODAY_MIN"));
        this.tradeValueBuyComboBox.addItem(Locale.getString("TODAY_MAX"));
        c.gridwidth = 0;
        gridbag.setConstraints(this.tradeValueBuyComboBox, c);
        innerPanelBuy.add(this.tradeValueBuyComboBox);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.tradeValueBuyByEquationButton = new JRadioButton(Locale.getString("BY_EQUATION"));
        this.tradeValueBuyButtonGroup.add(this.tradeValueBuyByEquationButton);
        c.gridwidth = 1;
        gridbag.setConstraints(this.tradeValueBuyByEquationButton, c);
        innerPanelBuy.add(this.tradeValueBuyByEquationButton);
        this.tradeValueBuyTextField = new JTextField();
        c.gridwidth = 0;
        gridbag.setConstraints(this.tradeValueBuyTextField, c);
        innerPanelBuy.add(this.tradeValueBuyTextField);
        panelBuy.add((Component)innerPanelBuy, "North");
        TitledBorder dateTitledSell = new TitledBorder(Locale.getString("SELL_TRADE_COST"));
        JPanel panelSell = new JPanel();
        panelSell.setBorder(dateTitledSell);
        panelSell.setLayout(new BorderLayout());
        JPanel innerPanelSell = new JPanel();
        innerPanelSell.setLayout(gridbag);
        this.tradeValueSellButtonGroup = new ButtonGroup();
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        c.fill = 2;
        this.tradeValueSellByKeyButton = new JRadioButton(Locale.getString("BY"));
        this.tradeValueSellByKeyButton.setSelected(true);
        this.tradeValueSellButtonGroup.add(this.tradeValueSellByKeyButton);
        c.gridwidth = 1;
        gridbag.setConstraints(this.tradeValueSellByKeyButton, c);
        innerPanelSell.add(this.tradeValueSellByKeyButton);
        this.tradeValueSellComboBox = new JComboBox();
        this.tradeValueSellComboBox.addItem(Locale.getString("TOMORROW_OPEN"));
        this.tradeValueSellComboBox.addItem(Locale.getString("TODAY_CLOSE"));
        this.tradeValueSellComboBox.addItem(Locale.getString("TODAY_MIN_MAX_AVG"));
        this.tradeValueSellComboBox.addItem(Locale.getString("TODAY_OPEN_CLOSE_AVG"));
        this.tradeValueSellComboBox.addItem(Locale.getString("TODAY_MIN"));
        this.tradeValueSellComboBox.addItem(Locale.getString("TODAY_MAX"));
        c.gridwidth = 0;
        gridbag.setConstraints(this.tradeValueSellComboBox, c);
        innerPanelSell.add(this.tradeValueSellComboBox);
        c.weightx = 1.0;
        c.ipadx = 5;
        c.anchor = 17;
        this.tradeValueSellByEquationButton = new JRadioButton(Locale.getString("BY_EQUATION"));
        this.tradeValueSellButtonGroup.add(this.tradeValueSellByEquationButton);
        c.gridwidth = 1;
        gridbag.setConstraints(this.tradeValueSellByEquationButton, c);
        innerPanelSell.add(this.tradeValueSellByEquationButton);
        this.tradeValueSellTextField = new JTextField();
        c.gridwidth = 0;
        gridbag.setConstraints(this.tradeValueSellTextField, c);
        innerPanelSell.add(this.tradeValueSellTextField);
        panelSell.add((Component)innerPanelSell, "North");
        panel.add(panelBuy);
        panel.add(panelSell);
        this.add(panel);
    }
}

