/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser.ga;

import java.util.Random;
import org.mov.portfolio.Portfolio;
import org.mov.util.Money;

public class GAIndividual {
    private String[] parameters = null;
    private double[] values = null;
    private int[] types = null;
    private Portfolio portfolio = null;
    private Money value = null;
    private static final int MOTHER = 47;
    private static final int FATHER = 47;
    private static final int MUTATION = 6;
    private static final int BREED_BY_MOTHER = 0;
    private static final int BREED_BY_FATHER = 1;
    private static final int BREED_BY_MUTATION = 2;

    public GAIndividual(String[] parameters, double[] values, int[] types2) {
        int ii;
        this.parameters = new String[parameters.length];
        for (ii = 0; ii < this.parameters.length; ++ii) {
            this.parameters[ii] = new String(parameters[ii]);
        }
        this.values = new double[values.length];
        for (ii = 0; ii < this.values.length; ++ii) {
            this.values[ii] = values[ii];
        }
        this.types = new int[types2.length];
        for (ii = 0; ii < this.types.length; ++ii) {
            this.types[ii] = types2[ii];
        }
    }

    public GAIndividual(Random random, GAIndividual lowest, GAIndividual highest) {
        this.parameters = new String[lowest.size()];
        this.values = new double[lowest.size()];
        this.types = new int[lowest.size()];
        for (int ii = 0; ii < lowest.size(); ++ii) {
            this.parameters[ii] = lowest.parameter(ii);
            this.values[ii] = this.getRandom(random, lowest.value(ii), highest.value(ii), lowest.type(ii));
            this.types[ii] = lowest.type(ii);
        }
    }

    public GAIndividual(Random random, GAIndividual mother, GAIndividual father, GAIndividual lowest, GAIndividual highest) {
        this.parameters = new String[lowest.size()];
        this.values = new double[lowest.size()];
        this.types = new int[lowest.size()];
        for (int ii = 0; ii < father.size(); ++ii) {
            this.parameters[ii] = father.parameter(ii);
            int breedType = this.getRandomBreedType(random);
            this.values[ii] = breedType == 47 ? father.value(ii) : (breedType == 47 ? mother.value(ii) : this.getRandom(random, lowest.value(ii), highest.value(ii), lowest.type(ii)));
            this.types[ii] = father.type(ii);
        }
    }

    private int getRandomBreedType(Random random) {
        int percent = random.nextInt(100);
        if (47 > percent) {
            return 0;
        }
        if (47 > (percent -= 47)) {
            return 1;
        }
        percent -= 47;
        return 2;
    }

    private double getRandom(Random random, double low, double up, int type) {
        double retValue = 0.0;
        if (up < low) {
            double tmp = up;
            up = low;
            low = tmp;
        }
        if (type == 2) {
            int retValueInt = new Double(low).intValue() + random.nextInt(new Double(up).intValue() + 1 - new Double(low).intValue());
            retValue = retValueInt;
        } else {
            retValue = low + (up - low) * random.nextDouble();
        }
        return retValue;
    }

    public Money getValue() {
        return this.value;
    }

    public void setValue(Money value) {
        this.value = value;
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public void setPortfolio(Portfolio portfolio) {
        this.portfolio = portfolio;
    }

    public int size() {
        return this.parameters.length;
    }

    public String parameter(int index) {
        return this.parameters[index];
    }

    public double value(int index) {
        return this.values[index];
    }

    public int type(int index) {
        return this.types[index];
    }
}

