/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser.ga;

import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import org.mov.analyser.OrderCache;
import org.mov.analyser.PaperTrade;
import org.mov.analyser.ga.GAIndividual;
import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.Variables;
import org.mov.portfolio.Portfolio;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class GeneticAlgorithm {
    private static final String PORTFOLIO_NAME;
    private int breedingPopulationSize;
    private double breedingPopulationSum;
    private TreeMap breedingPopulation;
    private TreeMap nextBreedingPopulation;
    private Random random;
    private QuoteBundle quoteBundle;
    private OrderCache orderCache;
    private Expression buyRule;
    private Expression sellRule;
    private TradingDate startDate;
    private TradingDate endDate;
    private Money initialCapital;
    private Money stockValue;
    private int numberStocks;
    private Money tradeCost;
    private int generation;
    private String tradeValueBuy;
    private String tradeValueSell;
    private GAIndividual lowest;
    private GAIndividual highest;
    private Variables variables;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GeneticAlgorithm(QuoteBundle quoteBundle, OrderCache orderCache, Expression buyRule, Expression sellRule, TradingDate startDate, TradingDate endDate, Money initialCapital, Money stockValue, int numberStocks, Money tradeCost, int breedingPopulationSize, String tradeValueBuy, String tradeValueSell, GAIndividual lowest, GAIndividual highest, Variables variables) {
        this.quoteBundle = quoteBundle;
        this.orderCache = orderCache;
        this.buyRule = buyRule;
        this.sellRule = sellRule;
        this.startDate = startDate;
        this.endDate = endDate;
        this.initialCapital = initialCapital;
        this.stockValue = stockValue;
        this.numberStocks = numberStocks;
        this.tradeCost = tradeCost;
        this.breedingPopulationSize = breedingPopulationSize;
        this.tradeValueBuy = tradeValueBuy;
        this.tradeValueSell = tradeValueSell;
        this.lowest = lowest;
        this.highest = highest;
        this.variables = variables;
        this.nextBreedingPopulation = new TreeMap();
        this.breedingPopulation = new TreeMap();
        this.random = new Random(System.currentTimeMillis());
        this.generation = 1;
    }

    public void nextIndividual() {
        boolean validIndividual = false;
        while (!validIndividual) {
            GAIndividual individual;
            if (this.generation == 1) {
                individual = new GAIndividual(this.random, this.lowest, this.highest);
            } else {
                double motherValue = this.random.nextDouble() * this.breedingPopulationSum;
                double fatherValue = this.random.nextDouble() * this.breedingPopulationSum;
                GAIndividual mother = this.getBreedingIndividual(motherValue);
                GAIndividual father = this.getBreedingIndividual(fatherValue);
                individual = new GAIndividual(this.random, mother, father, this.lowest, this.highest);
            }
            for (int ii = 0; ii < individual.size(); ++ii) {
                this.variables.setValue(individual.parameter(ii), individual.value(ii));
            }
            try {
                Money value = null;
                Portfolio portfolio = this.paperTrade(this.quoteBundle, this.orderCache, this.startDate, this.endDate, this.buyRule, this.sellRule, this.initialCapital, this.stockValue, this.numberStocks, this.tradeCost, this.variables, this.tradeValueBuy, this.tradeValueSell);
                individual.setPortfolio(portfolio);
                try {
                    value = portfolio.getValue(this.quoteBundle, this.endDate);
                    individual.setValue(value);
                }
                catch (MissingQuoteException e) {
                    // empty catch block
                }
                this.competeForBreeding(individual, value);
                validIndividual = true;
            }
            catch (EvaluationException evaluationException) {}
        }
    }

    public int nextGeneration() {
        this.breedingPopulation = new TreeMap(this.nextBreedingPopulation);
        this.breedingPopulationSum = 0.0;
        Iterator iterator = this.breedingPopulation.keySet().iterator();
        while (iterator.hasNext()) {
            Money value = (Money)iterator.next();
            this.breedingPopulationSum += value.doubleValue();
        }
        return ++this.generation;
    }

    public GAIndividual getBreedingIndividual(int index) {
        if (!$assertionsDisabled && index >= this.breedingPopulation.size()) {
            throw new AssertionError();
        }
        Iterator iterator = this.breedingPopulation.values().iterator();
        while (iterator.hasNext()) {
            GAIndividual individual = (GAIndividual)iterator.next();
            if (index == 0) {
                return individual;
            }
            --index;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private GAIndividual getBreedingIndividual(double value) {
        if (!$assertionsDisabled && !(value <= this.breedingPopulationSum)) {
            throw new AssertionError();
        }
        Iterator iterator = this.breedingPopulation.values().iterator();
        while (iterator.hasNext()) {
            GAIndividual individual = (GAIndividual)iterator.next();
            if (!((value -= individual.getValue().doubleValue()) <= 0.0)) continue;
            return individual;
        }
        return (GAIndividual)this.breedingPopulation.get(this.breedingPopulation.lastKey());
    }

    public int getBreedingPopulationSize() {
        return this.breedingPopulation.size();
    }

    public int getNextBreedingPopulationSize() {
        return this.nextBreedingPopulation.size();
    }

    public Expression getBuyRule() {
        return this.buyRule;
    }

    public Expression getSellRule() {
        return this.sellRule;
    }

    private void competeForBreeding(GAIndividual individual, Money value) {
        GAIndividual sameTradeIndividual;
        if (value.isGreaterThan(this.initialCapital) && (sameTradeIndividual = (GAIndividual)this.nextBreedingPopulation.get(value)) == null) {
            if (this.nextBreedingPopulation.size() < this.breedingPopulationSize) {
                this.nextBreedingPopulation.put(value, individual);
            } else {
                Money weakestValue = (Money)this.nextBreedingPopulation.firstKey();
                if (value.isGreaterThan(weakestValue)) {
                    this.nextBreedingPopulation.remove(weakestValue);
                    this.nextBreedingPopulation.put(value, individual);
                }
            }
        }
    }

    public Portfolio paperTrade(QuoteBundle quoteBundle, OrderCache orderCache, TradingDate startDate, TradingDate endDate, Expression buyRule, Expression sellRule, Money initialCapital, Money stockValue, int numberStocks, Money tradeCost, Variables variables, String tradeValueBuy, String tradeValueSell) throws EvaluationException {
        Portfolio portfolio = null;
        portfolio = stockValue == null ? PaperTrade.paperTrade(PORTFOLIO_NAME, quoteBundle, variables, orderCache, startDate, endDate, buyRule, sellRule, initialCapital, numberStocks, tradeCost, tradeValueBuy, tradeValueSell) : PaperTrade.paperTrade(PORTFOLIO_NAME, quoteBundle, variables, orderCache, startDate, endDate, buyRule, sellRule, initialCapital, stockValue, tradeCost, tradeValueBuy, tradeValueSell);
        return portfolio;
    }

    static {
        $assertionsDisabled = !GeneticAlgorithm.class.desiredAssertionStatus();
        PORTFOLIO_NAME = Locale.getString("GENETIC_ALGORITHM_PORTFOLIO");
    }
}

