/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser.gp;

import java.util.Iterator;
import java.util.List;
import org.mov.parser.EvaluationException;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.quote.QuoteBundleIterator;
import org.mov.quote.QuoteCache;
import org.mov.quote.QuoteRange;
import org.mov.quote.Symbol;
import org.mov.quote.WeekendDateException;
import org.mov.util.TradingDate;

public class GPQuoteBundle
implements QuoteBundle {
    private QuoteBundle quoteBundle;
    private int window;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GPQuoteBundle(QuoteBundle quoteBundle, int window) {
        this.quoteBundle = quoteBundle;
        this.window = window;
    }

    public double getQuote(Symbol symbol, int quoteType, int dateOffset) throws MissingQuoteException {
        return this.quoteBundle.getQuote(symbol, quoteType, dateOffset);
    }

    public double getQuote(Symbol symbol, int quoteType, int today, int offset) throws EvaluationException, MissingQuoteException {
        if (offset > 0) {
            throw EvaluationException.FUTURE_DATE_EXCEPTION;
        }
        if (offset <= this.window) {
            throw EvaluationException.PAST_DATE_EXCEPTION;
        }
        return this.quoteBundle.getQuote(symbol, quoteType, today + offset);
    }

    public double getQuote(Symbol symbol, int quoteType, TradingDate date) throws MissingQuoteException {
        double quote;
        try {
            quote = this.getQuote(symbol, quoteType, QuoteCache.getInstance().dateToOffset(date));
        }
        catch (WeekendDateException e) {
            throw MissingQuoteException.getInstance();
        }
        return quote;
    }

    public boolean containsQuote(Symbol symbol, int dateOffset) {
        return this.quoteBundle.containsQuote(symbol, dateOffset);
    }

    public boolean containsQuote(Symbol symbol, TradingDate date) {
        return this.quoteBundle.containsQuote(symbol, date);
    }

    public Iterator iterator() {
        return new QuoteBundleIterator(this);
    }

    public QuoteRange getQuoteRange() {
        return this.quoteBundle.getQuoteRange();
    }

    public void setQuoteRange(QuoteRange quoteRange) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public Symbol getFirstSymbol() {
        return this.quoteBundle.getFirstSymbol();
    }

    public List getAllSymbols() {
        return this.quoteBundle.getAllSymbols();
    }

    public List getSymbols(int dateOffset) {
        return this.quoteBundle.getSymbols(dateOffset);
    }

    public List getSymbols(TradingDate date) {
        return this.quoteBundle.getSymbols(date);
    }

    public TradingDate getFirstDate() {
        return this.quoteBundle.getFirstDate();
    }

    public TradingDate getLastDate() {
        return this.quoteBundle.getLastDate();
    }

    public int getFirstDateOffset() {
        return this.quoteBundle.getFirstDateOffset();
    }

    public int getLastDateOffset() {
        return this.quoteBundle.getLastDateOffset();
    }

    public TradingDate offsetToDate(int dateOffset) {
        return this.quoteBundle.offsetToDate(dateOffset);
    }

    public int dateToOffset(TradingDate date) throws WeekendDateException {
        return this.quoteBundle.dateToOffset(date);
    }

    static {
        $assertionsDisabled = !GPQuoteBundle.class.desiredAssertionStatus();
    }
}

