/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser.gp;

import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import org.mov.analyser.GPGondolaSelection;
import org.mov.analyser.OrderCache;
import org.mov.analyser.gp.GPQuoteBundle;
import org.mov.analyser.gp.Individual;
import org.mov.analyser.gp.Mutator;
import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class GeneticProgramme {
    private final int MIN_SIZE = 12;
    private final int MAX_SIZE = 48;
    private final int BUY_RULE = 0;
    private final int SELL_RULE = 1;
    private final int NUMBER_RULES = 2;
    private static final int MUTATION_PERCENT = 95;
    private int breedingPopulationSize;
    private double breedingPopulationSum;
    private TreeMap breedingPopulation;
    private TreeMap nextBreedingPopulation;
    private Mutator buyRuleMutator;
    private Mutator sellRuleMutator;
    private Random random;
    private GPQuoteBundle quoteBundle;
    private GPGondolaSelection GPGondolaSelection;
    private OrderCache orderCache;
    private TradingDate startDate;
    private TradingDate endDate;
    private Money initialCapital;
    private Money stockValue;
    private int numberStocks;
    private Money tradeCost;
    private int generation;
    private String tradeValueBuy;
    private String tradeValueSell;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GeneticProgramme(GPQuoteBundle quoteBundle, GPGondolaSelection GPGondolaSelection2, OrderCache orderCache, TradingDate startDate, TradingDate endDate, Money initialCapital, Money stockValue, int numberStocks, Money tradeCost, int breedingPopulationSize, String tradeValueBuy, String tradeValueSell) {
        this.quoteBundle = quoteBundle;
        this.GPGondolaSelection = GPGondolaSelection2;
        this.orderCache = orderCache;
        this.startDate = startDate;
        this.endDate = endDate;
        this.initialCapital = initialCapital;
        this.stockValue = stockValue;
        this.numberStocks = numberStocks;
        this.tradeCost = tradeCost;
        this.breedingPopulationSize = breedingPopulationSize;
        this.tradeValueBuy = tradeValueBuy;
        this.tradeValueSell = tradeValueSell;
        this.nextBreedingPopulation = new TreeMap();
        this.breedingPopulation = new TreeMap();
        this.random = new Random(System.currentTimeMillis());
        this.buyRuleMutator = new Mutator(this.random, GPGondolaSelection2, false, orderCache.isOrdered());
        this.sellRuleMutator = new Mutator(this.random, GPGondolaSelection2, true, orderCache.isOrdered());
        this.generation = 1;
    }

    public void nextIndividual(Expression buyRule, Expression sellRule, int mutations) {
        boolean validIndividual = false;
        boolean twice = false;
        while (!validIndividual) {
            Individual individual = this.createIndividual(buyRule, sellRule, mutations, twice);
            twice = true;
            if (!individual.isValid(12, 48)) continue;
            try {
                Money value = individual.paperTrade(this.quoteBundle, this.orderCache, this.startDate, this.endDate, this.initialCapital, this.stockValue, this.numberStocks, this.tradeCost, this.tradeValueBuy, this.tradeValueSell);
                this.competeForBreeding(individual, value);
                validIndividual = true;
            }
            catch (EvaluationException e) {}
        }
    }

    public int nextGeneration() {
        this.breedingPopulation = new TreeMap(this.nextBreedingPopulation);
        this.breedingPopulationSum = 0.0;
        Iterator iterator = this.breedingPopulation.keySet().iterator();
        while (iterator.hasNext()) {
            Money value = (Money)iterator.next();
            this.breedingPopulationSum += value.doubleValue();
        }
        return ++this.generation;
    }

    public Individual getBreedingIndividual(int index) {
        if (!$assertionsDisabled && index >= this.breedingPopulation.size()) {
            throw new AssertionError();
        }
        Iterator iterator = this.breedingPopulation.values().iterator();
        while (iterator.hasNext()) {
            Individual individual = (Individual)iterator.next();
            if (index == 0) {
                return individual;
            }
            --index;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private Individual getBreedingIndividual(double value) {
        if (!$assertionsDisabled && !(value <= this.breedingPopulationSum)) {
            throw new AssertionError();
        }
        Iterator iterator = this.breedingPopulation.values().iterator();
        while (iterator.hasNext()) {
            Individual individual = (Individual)iterator.next();
            if (!((value -= individual.getValue().doubleValue()) <= 0.0)) continue;
            return individual;
        }
        return (Individual)this.breedingPopulation.get(this.breedingPopulation.lastKey());
    }

    public int getBreedingPopulationSize() {
        return this.breedingPopulation.size();
    }

    public int getNextBreedingPopulationSize() {
        return this.nextBreedingPopulation.size();
    }

    private Individual createIndividual(Expression buyRule, Expression sellRule, int mutations, boolean twice) {
        if (this.generation == 1) {
            Expression newSellExpression;
            Expression newBuyExpression;
            if (buyRule == null || sellRule == null) {
                return new Individual(this.buyRuleMutator, this.sellRuleMutator);
            }
            if (twice) {
                newBuyExpression = this.buyRuleMutator.mutate(buyRule, 95);
                newSellExpression = this.sellRuleMutator.mutate(sellRule, 95);
            } else {
                newBuyExpression = buyRule;
                newSellExpression = sellRule;
            }
            for (int i = 0; i < mutations; ++i) {
                newBuyExpression = this.buyRuleMutator.mutate(newBuyExpression, 95);
                newSellExpression = this.sellRuleMutator.mutate(newSellExpression, 95);
            }
            return new Individual(newBuyExpression.simplify(), newSellExpression.simplify());
        }
        double motherValue = this.random.nextDouble() * this.breedingPopulationSum;
        double fatherValue = this.random.nextDouble() * this.breedingPopulationSum;
        Individual mother = this.getBreedingIndividual(motherValue);
        Individual father = this.getBreedingIndividual(fatherValue);
        return new Individual(this.random, this.buyRuleMutator, this.sellRuleMutator, mother, father);
    }

    private void competeForBreeding(Individual individual, Money value) {
        if (value.isGreaterThan(this.initialCapital)) {
            Individual sameTradeIndividual = (Individual)this.nextBreedingPopulation.get(value);
            if (sameTradeIndividual != null) {
                if (individual.getTotalEquationSize() < sameTradeIndividual.getTotalEquationSize()) {
                    this.nextBreedingPopulation.put(value, individual);
                }
            } else if (this.nextBreedingPopulation.size() < this.breedingPopulationSize) {
                this.nextBreedingPopulation.put(value, individual);
            } else {
                Money weakestValue = (Money)this.nextBreedingPopulation.firstKey();
                if (value.isGreaterThan(weakestValue)) {
                    this.nextBreedingPopulation.remove(weakestValue);
                    this.nextBreedingPopulation.put(value, individual);
                }
            }
        }
    }

    static {
        $assertionsDisabled = !GeneticProgramme.class.desiredAssertionStatus();
    }
}

