/*
 * Decompiled with CFR 0.152.
 */
package org.mov.analyser.gp;

import java.util.Random;
import org.mov.analyser.OrderCache;
import org.mov.analyser.PaperTrade;
import org.mov.analyser.gp.GPQuoteBundle;
import org.mov.analyser.gp.Mutator;
import org.mov.parser.EvaluationException;
import org.mov.parser.Expression;
import org.mov.parser.TypeMismatchException;
import org.mov.parser.Variables;
import org.mov.portfolio.Portfolio;
import org.mov.quote.MissingQuoteException;
import org.mov.quote.QuoteBundle;
import org.mov.util.Locale;
import org.mov.util.Money;
import org.mov.util.TradingDate;

public class Individual
implements Comparable {
    private Expression buyRule = null;
    private Expression sellRule = null;
    private Portfolio portfolio = null;
    private Money value = null;
    private static final int CLONE_PERCENT = 10;
    private static final int SWAP_PERCENT = 5;
    private static final int RECOMBINE_PERCENT = 35;
    private static final int SWAP_AND_RECOMBINE_PERCENT = 40;
    private static final int DOUBLE_RECOMBINE_PERCENT = 10;
    private static final int BREED_BY_CLONING = 0;
    private static final int BREED_BY_SWAPPING = 1;
    private static final int BREED_BY_RECOMBINING = 2;
    private static final int BREED_BY_SWAPPING_AND_RECOMBINING = 3;
    private static final int BREED_BY_DOUBLE_RECOMBINING = 4;
    private static final String PORTFOLIO_NAME;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Individual(Expression buyRule, Expression sellRule) {
        this.buyRule = buyRule;
        this.sellRule = sellRule;
        this.checkType();
    }

    public Individual(Mutator buyRuleMutator, Mutator sellRuleMutator) {
        this.buyRule = buyRuleMutator.createRandomNonTerminal(0, 0);
        this.sellRule = sellRuleMutator.createRandomNonTerminal(0, 0);
        this.buyRule = this.buyRule.simplify();
        this.sellRule = this.sellRule.simplify();
        this.checkType();
    }

    public Individual(Random random, Mutator buyRuleMutator, Mutator sellRuleMutator, Individual father, Individual mother) {
        int breedType = this.getRandomBreedType(random);
        this.buyRule = (Expression)father.getBuyRule().clone();
        this.sellRule = breedType == 1 || breedType == 3 ? (Expression)mother.getSellRule().clone() : (Expression)father.getSellRule().clone();
        if (breedType == 2 || breedType == 4 || breedType == 3) {
            this.buyRule = this.recombine(buyRuleMutator, this.buyRule, mother.getBuyRule());
            if (breedType == 4) {
                this.sellRule = this.recombine(sellRuleMutator, this.sellRule, mother.getSellRule());
            }
        }
        if (breedType == 0) {
            int randomNumber = random.nextInt(3);
            if (randomNumber == 0 || randomNumber == 2) {
                this.buyRule = buyRuleMutator.mutate(this.buyRule, 100);
            }
            if (randomNumber == 1 || randomNumber == 2) {
                this.sellRule = sellRuleMutator.mutate(this.sellRule, 100);
            }
        } else {
            this.buyRule = buyRuleMutator.mutate(this.buyRule);
            this.sellRule = sellRuleMutator.mutate(this.sellRule);
        }
        this.sellRule = this.sellRule.simplify();
        this.buyRule = this.buyRule.simplify();
        this.checkType();
    }

    public boolean isValid(int min, int max) {
        int sellRuleSize = this.sellRule.size();
        int buyRuleSize = this.buyRule.size();
        return sellRuleSize >= min && sellRuleSize <= max && buyRuleSize >= min && buyRuleSize <= max && (this.buyRule.size(3) > 0 || this.buyRule.size(4) > 0);
    }

    public int getTotalEquationSize() {
        return this.buyRule.size() + this.sellRule.size();
    }

    public Money paperTrade(GPQuoteBundle quoteBundle, OrderCache orderCache, TradingDate startDate, TradingDate endDate, Money initialCapital, Money stockValue, int numberStocks, Money tradeCost, String tradeValueBuy, String tradeValueSell) throws EvaluationException {
        block2: {
            this.portfolio = stockValue == null ? PaperTrade.paperTrade(PORTFOLIO_NAME, (QuoteBundle)quoteBundle, new Variables(), orderCache, startDate, endDate, this.getBuyRule(), this.getSellRule(), initialCapital, numberStocks, tradeCost, tradeValueBuy, tradeValueSell) : PaperTrade.paperTrade(PORTFOLIO_NAME, (QuoteBundle)quoteBundle, new Variables(), orderCache, startDate, endDate, this.getBuyRule(), this.getSellRule(), initialCapital, stockValue, tradeCost, tradeValueBuy, tradeValueSell);
            try {
                this.value = this.portfolio.getValue((QuoteBundle)quoteBundle, endDate);
            }
            catch (MissingQuoteException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return this.value;
    }

    public Money getValue() {
        return this.value;
    }

    public Expression getBuyRule() {
        return this.buyRule;
    }

    public Expression getSellRule() {
        return this.sellRule;
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public int compareTo(Object object) {
        Individual other = (Individual)object;
        return this.getValue().compareTo(other.getValue());
    }

    public boolean equals(Object object) {
        Individual other = (Individual)object;
        return this.getValue().equals(other.getValue());
    }

    public int hashCode() {
        return ((Object)this.getBuyRule()).hashCode() + ((Object)this.getSellRule()).hashCode();
    }

    private int getRandomBreedType(Random random) {
        int percent = random.nextInt(100);
        if (10 > percent) {
            return 0;
        }
        if (5 > (percent -= 10)) {
            return 1;
        }
        if (35 > (percent -= 5)) {
            return 2;
        }
        if (40 > (percent -= 35)) {
            return 3;
        }
        percent -= 40;
        return 4;
    }

    private Expression recombine(Mutator mutator, Expression destination, Expression source) {
        Expression destinationSubTree = mutator.findRandomSite(destination);
        Expression sourceSubTree = mutator.findRandomSite(source, destinationSubTree.getType());
        if (sourceSubTree != null) {
            if (!$assertionsDisabled && sourceSubTree.getType() != destinationSubTree.getType()) {
                throw new AssertionError();
            }
            destination = mutator.insert(destination, destinationSubTree, (Expression)sourceSubTree.clone());
        }
        return destination;
    }

    private void checkType() {
        block4: {
            try {
                if (!$assertionsDisabled && this.buyRule.checkType() != 0) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.sellRule.checkType() != 0) {
                    throw new AssertionError();
                }
            }
            catch (TypeMismatchException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    static {
        $assertionsDisabled = !Individual.class.desiredAssertionStatus();
        PORTFOLIO_NAME = Locale.getString("GENETIC_PROGRAMME_PORTFOLIO");
    }
}

